/*
 * Decompiled with CFR 0.152.
 */
package io.github.netmikey.logunit.log4j2;

import io.github.netmikey.logunit.log4j2.LevelMapper;
import java.io.Serializable;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.slf4j.event.LoggingEvent;
import org.slf4j.event.SubstituteLoggingEvent;

public class ListAppender
extends AbstractAppender {
    private ConcurrentLinkedQueue<LoggingEvent> list = new ConcurrentLinkedQueue();

    public static ListAppender create(String name) {
        return new ListAppender(name, null, (Layout<? extends Serializable>)PatternLayout.createDefaultLayout(), true, Property.EMPTY_ARRAY);
    }

    protected ListAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, Property[] properties) {
        super(name, filter, layout, ignoreExceptions, properties);
    }

    public void append(LogEvent event) {
        this.list.add(this.mapEvent(event));
    }

    private LoggingEvent mapEvent(LogEvent iEvent) {
        SubstituteLoggingEvent e = new SubstituteLoggingEvent();
        e.setTimeStamp(iEvent.getTimeMillis());
        e.setThrowable(iEvent.getThrown());
        e.setThreadName(iEvent.getThreadName());
        e.setMessage(iEvent.getMessage().getFormattedMessage());
        e.setLoggerName(iEvent.getLoggerName());
        e.setLevel(LevelMapper.mapLevel(iEvent.getLevel()));
        return e;
    }

    public Spliterator<LoggingEvent> spliterator() {
        return this.list.spliterator();
    }
}

