/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.api.internal;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.HierarchicalConfig;
import io.gitlab.arturbosch.detekt.api.Notification;
import io.gitlab.arturbosch.detekt.api.internal.BaseConfig;
import io.gitlab.arturbosch.detekt.api.internal.ValidatableConfiguration;
import io.gitlab.arturbosch.detekt.api.internal.ValidatableConfigurationKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B1\b\u0000\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0016J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J'\u0010\u001c\u001a\u0002H\u001d\"\b\b\u0000\u0010\u001d*\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u0002H\u001dH\u0016\u00a2\u0006\u0002\u0010\u001fJ!\u0010 \u001a\u0004\u0018\u0001H\u001d\"\b\b\u0000\u0010\u001d*\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010!R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Lio/gitlab/arturbosch/detekt/api/internal/YamlConfig;", "Lio/gitlab/arturbosch/detekt/api/internal/BaseConfig;", "Lio/gitlab/arturbosch/detekt/api/internal/ValidatableConfiguration;", "properties", "", "", "", "parent", "Lio/gitlab/arturbosch/detekt/api/HierarchicalConfig$Parent;", "parentPath", "(Ljava/util/Map;Lio/gitlab/arturbosch/detekt/api/HierarchicalConfig$Parent;Ljava/lang/String;)V", "getParent", "()Lio/gitlab/arturbosch/detekt/api/HierarchicalConfig$Parent;", "getParentPath", "()Ljava/lang/String;", "getProperties", "()Ljava/util/Map;", "subConfig", "Lio/gitlab/arturbosch/detekt/api/Config;", "key", "toString", "validate", "", "Lio/gitlab/arturbosch/detekt/api/Notification;", "baseline", "excludePatterns", "", "Lkotlin/text/Regex;", "valueOrDefault", "T", "default", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "valueOrNull", "(Ljava/lang/String;)Ljava/lang/Object;", "Companion", "detekt-api"})
public final class YamlConfig
extends BaseConfig
implements ValidatableConfiguration {
    @NotNull
    private final Map<String, Object> properties;
    @Nullable
    private final HierarchicalConfig.Parent parent;
    @Nullable
    private final String parentPath;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Config subConfig(@NotNull String key) {
        Object subProperties;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Map<String, Object> map = this.properties;
        boolean bl = false;
        Object object = map.get(key);
        if (object == null) {
            boolean bl2 = false;
            boolean bl3 = false;
            object = MapsKt.emptyMap();
        }
        Object object2 = subProperties = object;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
        }
        return new YamlConfig((Map)object2, new HierarchicalConfig.Parent(this, key), this.getParentPath() == null ? key : this.getParentPath() + " > " + key);
    }

    @Override
    @NotNull
    public <T> T valueOrDefault(@NotNull String key, @NotNull T t) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(t, (String)"default");
        Object result = this.properties.get(key);
        Object object = this.valueOrDefaultInternal(key, result, t);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type T");
        }
        return (T)object;
    }

    @Override
    @Nullable
    public <T> T valueOrNull(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Object object = this.properties.get(key);
        if (!(object instanceof Object)) {
            object = null;
        }
        return (T)object;
    }

    @NotNull
    public String toString() {
        return "YamlConfig(properties=" + this.properties + ')';
    }

    @Override
    @NotNull
    public List<Notification> validate(@NotNull Config baseline, @NotNull Set<Regex> excludePatterns) {
        Intrinsics.checkParameterIsNotNull((Object)baseline, (String)"baseline");
        Intrinsics.checkParameterIsNotNull(excludePatterns, (String)"excludePatterns");
        return ValidatableConfigurationKt.validateConfig(this, baseline, excludePatterns);
    }

    @NotNull
    public final Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    @Nullable
    public HierarchicalConfig.Parent getParent() {
        return this.parent;
    }

    @Override
    @Nullable
    public String getParentPath() {
        return this.parentPath;
    }

    public YamlConfig(@NotNull Map<String, ? extends Object> properties, @Nullable HierarchicalConfig.Parent parent, @Nullable String parentPath) {
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        this.properties = properties;
        this.parent = parent;
        this.parentPath = parentPath;
    }

    public /* synthetic */ YamlConfig(Map map, HierarchicalConfig.Parent parent, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        this(map, parent, string);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lio/gitlab/arturbosch/detekt/api/internal/YamlConfig$Companion;", "", "()V", "load", "Lio/gitlab/arturbosch/detekt/api/Config;", "reader", "Ljava/io/BufferedReader;", "path", "Ljava/nio/file/Path;", "loadResource", "url", "Ljava/net/URL;", "detekt-api"})
    public static final class Companion {
        @NotNull
        public final Config load(@NotNull Path path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            File file = path.toFile();
            Companion companion = this;
            boolean bl = false;
            int n = 0;
            File $this$apply = file;
            boolean bl2 = false;
            boolean bl3 = $this$apply.exists();
            boolean bl4 = false;
            boolean bl5 = false;
            if (!bl3) {
                boolean bl6 = false;
                String string = "Configuration does not exist: " + path;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl3 = $this$apply.isFile();
            bl4 = false;
            bl5 = false;
            if (!bl3) {
                boolean bl7 = false;
                String string = "Configuration must be a file: " + path;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl3 = $this$apply.canRead();
            bl4 = false;
            bl5 = false;
            if (!bl3) {
                boolean bl8 = false;
                String string = "Configuration must be readable: " + path;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Object object = file;
            File file2 = object;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"path.toFile().apply {\n  \u2026e: $path\" }\n            }");
            file = file2;
            Charset charset = Charsets.UTF_8;
            n = 8192;
            boolean bl9 = false;
            Object object2 = file;
            bl3 = false;
            Object object3 = object2;
            bl5 = false;
            object3 = new FileInputStream((File)object3);
            bl5 = false;
            object2 = new InputStreamReader((InputStream)object3, charset);
            bl3 = false;
            object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            return companion.load((BufferedReader)object);
        }

        @NotNull
        public final Config loadResource(@NotNull URL url) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            InputStream inputStream = url.openStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"url.openStream()");
            InputStream inputStream2 = inputStream;
            Companion companion = this;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Closeable closeable = inputStream2;
            int n = 0;
            closeable = new InputStreamReader((InputStream)closeable, charset);
            n = 8192;
            boolean bl2 = false;
            BufferedReader bufferedReader = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
            return companion.load(bufferedReader);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Config load(BufferedReader reader) {
            Config config;
            Closeable closeable = reader;
            boolean bl = false;
            Throwable throwable = null;
            try {
                Config config2;
                BufferedReader it = (BufferedReader)closeable;
                boolean bl2 = false;
                String yamlInput = SequencesKt.joinToString$default((Sequence)TextStreamsKt.lineSequence((BufferedReader)it), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                CharSequence charSequence = yamlInput;
                boolean bl3 = false;
                if (charSequence.length() == 0) {
                    config2 = Config.Companion.getEmpty();
                } else {
                    Object object = new Yaml().load(yamlInput);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Yaml().load(yamlInput)");
                    Object map = object;
                    if (!(map instanceof Map)) {
                        throw (Throwable)new Config.InvalidConfigurationError("Provided configuration file is invalid: Structure must be of type 'Map<String,Any>'.");
                    }
                    config2 = new YamlConfig((Map)map, null, null, 4, null);
                }
                config = config2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return config;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

