/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.cli;

import io.gitlab.arturbosch.detekt.api.CompositeConfig;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.YamlConfig;
import io.gitlab.arturbosch.detekt.cli.ClasspathResourceConverter;
import io.gitlab.arturbosch.detekt.cli.CliArgs;
import io.gitlab.arturbosch.detekt.cli.ConfigurationsKt;
import io.gitlab.arturbosch.detekt.cli.FailFastConfig;
import io.gitlab.arturbosch.detekt.cli.LOG;
import io.gitlab.arturbosch.detekt.cli.MultipleClasspathResourceConverter;
import io.gitlab.arturbosch.detekt.cli.MultipleExistingPathConverter;
import io.gitlab.arturbosch.detekt.core.PathFilter;
import java.net.URL;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\n\u001a\u0010\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\b*\u00020\n\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u0003H\u0002\u001a9\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00100\b\"\u0004\b\u0000\u0010\u0010*\u0004\u0018\u00010\u00012\u001d\u0010\u0011\u001a\u0019\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\b0\u0012\u00a2\u0006\u0002\b\u0013H\u0002\u001a\n\u0010\u0014\u001a\u00020\u0003*\u00020\n\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"DEFAULT_CONFIG", "", "loadDefaultConfig", "Lio/gitlab/arturbosch/detekt/api/Config;", "parsePathConfig", "configPath", "parseResourceConfig", "createPathFilters", "", "Lio/gitlab/arturbosch/detekt/core/PathFilter;", "Lio/gitlab/arturbosch/detekt/cli/CliArgs;", "createPlugins", "Ljava/nio/file/Path;", "deprecatedFailFastUsage", "", "letIfNonEmpty", "T", "init", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "loadConfiguration", "detekt-cli"})
public final class ConfigurationsKt {
    @NotNull
    public static final String DEFAULT_CONFIG = "default-detekt-config.yml";

    @NotNull
    public static final List<PathFilter> createPathFilters(@NotNull CliArgs $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return ConfigurationsKt.letIfNonEmpty($receiver.getFilters(), createPathFilters.1.INSTANCE);
    }

    @NotNull
    public static final List<Path> createPlugins(@NotNull CliArgs $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return ConfigurationsKt.letIfNonEmpty($receiver.getPlugins(), createPlugins.1.INSTANCE);
    }

    private static final <T> List<T> letIfNonEmpty(@Nullable String $receiver, Function1<? super String, ? extends List<? extends T>> init) {
        CharSequence charSequence;
        return $receiver == null || (charSequence = (CharSequence)$receiver).length() == 0 ? CollectionsKt.emptyList() : (List)init.invoke((Object)$receiver);
    }

    @NotNull
    public static final Config loadConfiguration(@NotNull CliArgs $receiver) {
        Config config;
        boolean failFastUsed;
        Config config2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        CharSequence charSequence = $receiver.getConfig();
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            String string = $receiver.getConfig();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            config2 = ConfigurationsKt.parsePathConfig(string);
        } else {
            charSequence = $receiver.getConfigResource();
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                String string = $receiver.getConfigResource();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                config2 = ConfigurationsKt.parseResourceConfig(string);
            } else {
                config2 = null;
            }
        }
        Config declaredConfig = config2;
        Config defaultConfig = null;
        if ($receiver.getBuildUponDefaultConfig()) {
            defaultConfig = ConfigurationsKt.loadDefaultConfig();
            Config config3 = declaredConfig;
            if (config3 == null) {
                config3 = defaultConfig;
            }
            declaredConfig = (Config)new CompositeConfig(config3, defaultConfig);
        }
        Config config4 = declaredConfig;
        boolean bl = failFastUsed = config4 != null ? ConfigurationsKt.deprecatedFailFastUsage(config4) : false;
        if ($receiver.getFailFast() || failFastUsed) {
            Config config5;
            Config initializedDefaultConfig;
            Config config6 = defaultConfig;
            if (config6 == null) {
                config6 = initializedDefaultConfig = ConfigurationsKt.loadDefaultConfig();
            }
            if ((config5 = declaredConfig) == null) {
                config5 = initializedDefaultConfig;
            }
            declaredConfig = new FailFastConfig(config5, initializedDefaultConfig);
        }
        if ($receiver.getDebug()) {
            String string = "" + '\n' + declaredConfig + '\n';
            System.out.println((Object)string);
        }
        if ((config = declaredConfig) == null) {
            config = ConfigurationsKt.loadDefaultConfig();
        }
        return config;
    }

    private static final boolean deprecatedFailFastUsage(@NotNull Config $receiver) {
        boolean value = (Boolean)$receiver.valueOrDefault("failFast", (Object)false);
        LOG.INSTANCE.getPrinter().println("Using deprecated property 'failFast' in the yaml config. Please migrate to the new '--fail-fast' cli-flag or 'failFast' detekt extension property.");
        return value;
    }

    /*
     * WARNING - void declaration
     */
    private static final Config parseResourceConfig(String configPath) {
        Config config;
        Object urls = new MultipleClasspathResourceConverter().convert(configPath);
        if (urls.size() == 1) {
            config = YamlConfig.Companion.loadResource((URL)urls.get(0));
        } else {
            Sequence $receiver$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)urls)), (Function1)parseResourceConfig.1.INSTANCE);
            Iterator iterator$iv = $receiver$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw (Throwable)new UnsupportedOperationException("Empty sequence can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void config2;
                Config config3 = (Config)iterator$iv.next();
                Config composite = (Config)accumulator$iv;
                boolean bl = false;
                accumulator$iv = new CompositeConfig((Config)config2, composite);
            }
            config = (Config)accumulator$iv;
        }
        return config;
    }

    /*
     * WARNING - void declaration
     */
    private static final Config parsePathConfig(String configPath) {
        Config config;
        Object paths = new MultipleExistingPathConverter().convert(configPath);
        if (paths.size() == 1) {
            config = YamlConfig.Companion.load((Path)paths.get(0));
        } else {
            Sequence $receiver$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)paths)), (Function1)parsePathConfig.1.INSTANCE);
            Iterator iterator$iv = $receiver$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw (Throwable)new UnsupportedOperationException("Empty sequence can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void config2;
                Config config3 = (Config)iterator$iv.next();
                Config composite = (Config)accumulator$iv;
                boolean bl = false;
                accumulator$iv = new CompositeConfig((Config)config2, composite);
            }
            config = (Config)accumulator$iv;
        }
        return config;
    }

    private static final Config loadDefaultConfig() {
        return YamlConfig.Companion.loadResource(new ClasspathResourceConverter().convert(DEFAULT_CONFIG));
    }
}

