/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.cli;

import io.gitlab.arturbosch.detekt.cli.out.HtmlOutputReport;
import io.gitlab.arturbosch.detekt.cli.out.TxtOutputReport;
import io.gitlab.arturbosch.detekt.cli.out.XmlOutputReport;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/cli/ReportPath;", "", "kind", "", "path", "Ljava/nio/file/Path;", "(Ljava/lang/String;Ljava/nio/file/Path;)V", "getKind", "()Ljava/lang/String;", "getPath", "()Ljava/nio/file/Path;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "detekt-cli"})
public final class ReportPath {
    @NotNull
    private final String kind;
    @NotNull
    private final Path path;
    private static final int NUM_OF_PARTS_UNIX = 2;
    private static final int NUM_OF_PARTS_WINDOWS = 3;
    private static final String REPORT_PATH_SEPARATOR = ":";
    private static final String ILLEGAL_PARTS_SIZE_ERROR = "Must consist of two parts for Unix OSs or three for Windows (report-id:path).";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getKind() {
        return this.kind;
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    public ReportPath(@NotNull String kind, @NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.kind = kind;
        this.path = path;
    }

    @NotNull
    public final String component1() {
        return this.kind;
    }

    @NotNull
    public final Path component2() {
        return this.path;
    }

    @NotNull
    public final ReportPath copy(@NotNull String kind, @NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return new ReportPath(kind, path);
    }

    @NotNull
    public static /* synthetic */ ReportPath copy$default(ReportPath reportPath, String string, Path path, int n, Object object) {
        if ((n & 1) != 0) {
            string = reportPath.kind;
        }
        if ((n & 2) != 0) {
            path = reportPath.path;
        }
        return reportPath.copy(string, path);
    }

    @NotNull
    public String toString() {
        return "ReportPath(kind=" + this.kind + ", path=" + this.path + ")";
    }

    public int hashCode() {
        String string = this.kind;
        Path path = this.path;
        return (string != null ? string.hashCode() : 0) * 31 + (path != null ? ((Object)path).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ReportPath)) break block3;
                ReportPath reportPath = (ReportPath)object;
                if (!Intrinsics.areEqual((Object)this.kind, (Object)reportPath.kind) || !Intrinsics.areEqual((Object)this.path, (Object)reportPath.path)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0018\u0010\r\u001a\n \u000e*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/gitlab/arturbosch/detekt/cli/ReportPath$Companion;", "", "()V", "ILLEGAL_PARTS_SIZE_ERROR", "", "NUM_OF_PARTS_UNIX", "", "NUM_OF_PARTS_WINDOWS", "REPORT_PATH_SEPARATOR", "assertNotEmpty", "", "kind", "path", "defaultMapping", "kotlin.jvm.PlatformType", "reportId", "from", "Lio/gitlab/arturbosch/detekt/cli/ReportPath;", "input", "detekt-cli"})
    public static final class Companion {
        @NotNull
        public final ReportPath from(@NotNull String input) {
            String string;
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            List parts = StringsKt.split$default((CharSequence)input, (String[])new String[]{ReportPath.REPORT_PATH_SEPARATOR}, (boolean)false, (int)0, (int)6, null);
            int partsSize = parts.size();
            boolean bl2 = bl = partsSize == 2 || partsSize == 3;
            if (!bl) {
                boolean bl3 = false;
                String string2 = ReportPath.ILLEGAL_PARTS_SIZE_ERROR;
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            String kind = (String)parts.get(0);
            switch (partsSize) {
                case 2: {
                    string = (String)parts.get(1);
                    break;
                }
                case 3: {
                    string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.slice((List)parts, (IntRange)RangesKt.until((int)1, (int)partsSize)), (CharSequence)ReportPath.REPORT_PATH_SEPARATOR, null, null, (int)0, null, null, (int)62, null);
                    break;
                }
                default: {
                    throw (Throwable)new IllegalStateException(ReportPath.ILLEGAL_PARTS_SIZE_ERROR);
                }
            }
            String path = string;
            this.assertNotEmpty(kind, path);
            String string3 = this.defaultMapping(kind);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"defaultMapping(kind)");
            Path path2 = Paths.get(path, new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(path)");
            return new ReportPath(string3, path2);
        }

        private final void assertNotEmpty(String kind, String path) {
            boolean bl;
            boolean bl2;
            CharSequence charSequence = kind;
            boolean bl3 = bl2 = charSequence.length() > 0;
            if (!bl2) {
                boolean bl4 = false;
                String string = "The kind of report must not be empty";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            CharSequence charSequence2 = path;
            boolean bl5 = bl = charSequence2.length() > 0;
            if (!bl) {
                boolean bl6 = false;
                String string = "The path of the report must not be empty";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }

        private final String defaultMapping(String reportId) {
            String string;
            switch (reportId) {
                case "txt": {
                    string = TxtOutputReport.class.getSimpleName();
                    break;
                }
                case "xml": {
                    string = XmlOutputReport.class.getSimpleName();
                    break;
                }
                case "html": {
                    string = HtmlOutputReport.class.getSimpleName();
                    break;
                }
                default: {
                    string = reportId;
                }
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

