/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.cli.baseline;

import io.gitlab.arturbosch.detekt.cli.baseline.Baseline;
import io.gitlab.arturbosch.detekt.cli.baseline.BaselineHandler;
import io.gitlab.arturbosch.detekt.cli.baseline.Blacklist;
import io.gitlab.arturbosch.detekt.cli.baseline.InvalidBaselineState;
import io.gitlab.arturbosch.detekt.cli.baseline.Whitelist;
import io.gitlab.arturbosch.detekt.cli.baseline.XmlExtensionsKt;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\u0010\u001a\u00020\u000e*\u00020\u00112\u0006\u0010\u000f\u001a\u00020\nH\u0002R$\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/cli/baseline/BaselineFormat;", "", "()V", "positions", "Lkotlin/Pair;", "", "Ljavax/xml/stream/XMLStreamException;", "getPositions", "(Ljavax/xml/stream/XMLStreamException;)Lkotlin/Pair;", "read", "Lio/gitlab/arturbosch/detekt/cli/baseline/Baseline;", "path", "Ljava/nio/file/Path;", "write", "", "baseline", "save", "Ljavax/xml/stream/XMLStreamWriter;", "detekt-cli"})
public final class BaselineFormat {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Baseline read(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        try {
            Closeable closeable = Files.newInputStream(path, new OpenOption[0]);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                SAXParser reader = SAXParserFactory.newInstance().newSAXParser();
                BaselineHandler handler = new BaselineHandler();
                reader.parse(it, (DefaultHandler)handler);
                Baseline baseline = handler.createBaseline$detekt_cli();
                return baseline;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (SAXParseException error) {
            void line;
            Pair pair = TuplesKt.to((Object)error.getLineNumber(), (Object)error.getColumnNumber());
            int n = ((Number)pair.component1()).intValue();
            int column = ((Number)pair.component2()).intValue();
            throw (Throwable)new InvalidBaselineState("Error on position " + (int)line + ':' + column + " while reading the baseline xml file!", error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void write(@NotNull Baseline baseline, @NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)baseline, (String)"baseline");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        try {
            Closeable closeable = Files.newBufferedWriter(path, new OpenOption[0]);
            Throwable throwable = null;
            try {
                BufferedWriter it = (BufferedWriter)closeable;
                boolean bl = false;
                BufferedWriter bufferedWriter = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)bufferedWriter, (String)"it");
                this.save(XmlExtensionsKt.prettyPrinter(XmlExtensionsKt.streamXml(bufferedWriter)), baseline);
                it = Unit.INSTANCE;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (XMLStreamException error) {
            void line;
            Pair<Integer, Integer> pair = this.getPositions(error);
            int n = ((Number)pair.component1()).intValue();
            int column = ((Number)pair.component2()).intValue();
            throw (Throwable)new InvalidBaselineState("Error on position " + (int)line + ':' + column + " while writing the baseline xml file!", error);
        }
    }

    private final Pair<Integer, Integer> getPositions(@NotNull XMLStreamException $receiver) {
        Location location = $receiver.getLocation();
        Intrinsics.checkExpressionValueIsNotNull((Object)location, (String)"location");
        Integer n = location.getLineNumber();
        Location location2 = $receiver.getLocation();
        Intrinsics.checkExpressionValueIsNotNull((Object)location2, (String)"location");
        return TuplesKt.to((Object)n, (Object)location2.getColumnNumber());
    }

    /*
     * WARNING - void declaration
     */
    private final void save(@NotNull XMLStreamWriter $receiver, Baseline baseline) {
        String it;
        Object element$iv;
        Set<String> ids;
        void $receiver$iv;
        void var23_23;
        void $receiver$iv2;
        void var15_15;
        XMLStreamWriter xMLStreamWriter;
        XMLStreamWriter $receiver$iv3 = $receiver;
        String version$iv = null;
        String encoding$iv = null;
        boolean $i$f$document = false;
        XMLStreamWriter $receiver$iv4 = xMLStreamWriter = $receiver$iv3;
        boolean bl = false;
        $receiver$iv4.writeStartDocument();
        XMLStreamWriter $receiver2 = $receiver$iv4;
        boolean bl2 = false;
        XMLStreamWriter xMLStreamWriter2 = $receiver2;
        String name$iv = "SmellBaseline";
        boolean $i$f$tag = false;
        void $receiver$iv5 = var15_15 = $receiver$iv2;
        boolean bl3 = false;
        $receiver$iv5.writeStartElement(name$iv);
        void $receiver3 = $receiver$iv5;
        boolean bl4 = false;
        void var20_20 = $receiver3;
        String name$iv2 = "Blacklist";
        boolean $i$f$tag2 = false;
        void $receiver$iv6 = var23_23 = $receiver$iv;
        $i$a$-apply-XmlExtensionsKt$tag$1 = false;
        $receiver$iv6.writeStartElement(name$iv2);
        void $receiver4 = $receiver$iv6;
        boolean bl5 = false;
        Blacklist blacklist = baseline.getBlacklist();
        Set<String> set = blacklist.component1();
        String timestamp = blacklist.component2();
        XmlExtensionsKt.attribute((XMLStreamWriter)$receiver4, "timestamp", timestamp);
        Object $receiver$iv7 = ids;
        Iterator iterator = $receiver$iv7.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl6 = false;
            XmlExtensionsKt.tag((XMLStreamWriter)$receiver4, "ID", it);
        }
        $receiver$iv6.writeEndElement();
        $receiver$iv = $receiver3;
        name$iv2 = "Whitelist";
        $i$f$tag2 = false;
        $receiver$iv6 = var23_23 = $receiver$iv;
        $i$a$-apply-XmlExtensionsKt$tag$1 = false;
        $receiver$iv6.writeStartElement(name$iv2);
        $receiver4 = $receiver$iv6;
        boolean bl7 = false;
        $receiver$iv7 = baseline.getWhitelist();
        ids = ((Whitelist)$receiver$iv7).component1();
        timestamp = ((Whitelist)$receiver$iv7).component2();
        XmlExtensionsKt.attribute((XMLStreamWriter)$receiver4, "timestamp", timestamp);
        $receiver$iv7 = ids;
        iterator = $receiver$iv7.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl8 = false;
            XmlExtensionsKt.tag((XMLStreamWriter)$receiver4, "ID", it);
        }
        $receiver$iv6.writeEndElement();
        $receiver$iv5.writeEndElement();
        $receiver$iv4.writeEndDocument();
    }
}

