/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.cli.console;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConsoleReport;
import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.SingleAssign;
import io.gitlab.arturbosch.detekt.cli.console.BuildFailure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\u0018\u0000 32\u00020\u0001:\u00013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010!\u001a\u00020\"H\u0002J \u0010#\u001a\u0012\u0012\b\u0012\u00060%j\u0002`&\u0012\u0004\u0012\u00020%0$2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020\u0004H\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010%2\u0006\u0010'\u001a\u00020(H\u0016J\u0012\u0010,\u001a\u00020-*\u00020\f2\u0006\u0010.\u001a\u00020\fJ \u0010/\u001a\u00020\f*\u0002002\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020%02H\u0002R+\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR+\u0010\r\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\f8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u000b\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R+\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\f8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u000b\u001a\u0004\b\u0014\u0010\u000f\"\u0004\b\u0015\u0010\u0011R\u0014\u0010\u0017\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000fR+\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\f8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u000b\u001a\u0004\b\u001a\u0010\u000f\"\u0004\b\u001b\u0010\u0011R+\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b \u0010\u000b\u001a\u0004\b\u001e\u0010\u0007\"\u0004\b\u001f\u0010\t\u00a8\u00064"}, d2={"Lio/gitlab/arturbosch/detekt/cli/console/BuildFailureReport;", "Lio/gitlab/arturbosch/detekt/api/ConsoleReport;", "()V", "<set-?>", "Lio/gitlab/arturbosch/detekt/api/Config;", "buildConfig", "getBuildConfig", "()Lio/gitlab/arturbosch/detekt/api/Config;", "setBuildConfig", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "buildConfig$delegate", "Lio/gitlab/arturbosch/detekt/api/SingleAssign;", "", "failThreshold", "getFailThreshold", "()I", "setFailThreshold", "(I)V", "failThreshold$delegate", "maxIssues", "getMaxIssues", "setMaxIssues", "maxIssues$delegate", "priority", "getPriority", "warningThreshold", "getWarningThreshold", "setWarningThreshold", "warningThreshold$delegate", "weightsConfig", "getWeightsConfig", "setWeightsConfig", "weightsConfig$delegate", "checkDeprecation", "", "extractRuleToRuleSetIdMap", "Ljava/util/HashMap;", "", "Lio/gitlab/arturbosch/detekt/api/RuleSetId;", "detektion", "Lio/gitlab/arturbosch/detekt/api/Detektion;", "init", "config", "render", "reached", "", "amount", "weighted", "Lio/gitlab/arturbosch/detekt/api/Finding;", "ids", "", "Companion", "detekt-cli"})
public final class BuildFailureReport
extends ConsoleReport {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final int priority = Integer.MIN_VALUE;
    private final SingleAssign weightsConfig$delegate = new SingleAssign();
    private final SingleAssign buildConfig$delegate = new SingleAssign();
    private final SingleAssign warningThreshold$delegate = new SingleAssign();
    private final SingleAssign failThreshold$delegate = new SingleAssign();
    private final SingleAssign maxIssues$delegate = new SingleAssign();
    private static final String BUILD = "build";
    private static final String WEIGHTS = "weights";
    private static final String WARNING_THRESHOLD = "warningThreshold";
    private static final String FAIL_THRESHOLD = "failThreshold";
    private static final String MAX_ISSUES = "maxIssues";
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BuildFailureReport.class), "weightsConfig", "getWeightsConfig()Lio/gitlab/arturbosch/detekt/api/Config;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BuildFailureReport.class), "buildConfig", "getBuildConfig()Lio/gitlab/arturbosch/detekt/api/Config;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BuildFailureReport.class), WARNING_THRESHOLD, "getWarningThreshold()I")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BuildFailureReport.class), FAIL_THRESHOLD, "getFailThreshold()I")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BuildFailureReport.class), MAX_ISSUES, "getMaxIssues()I"))};
        Companion = new Companion(null);
    }

    public int getPriority() {
        return this.priority;
    }

    private final Config getWeightsConfig() {
        return (Config)this.weightsConfig$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setWeightsConfig(Config config) {
        this.weightsConfig$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)config);
    }

    private final Config getBuildConfig() {
        return (Config)this.buildConfig$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final void setBuildConfig(Config config) {
        this.buildConfig$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)config);
    }

    private final int getWarningThreshold() {
        return ((Number)this.warningThreshold$delegate.getValue((Object)this, $$delegatedProperties[2])).intValue();
    }

    private final void setWarningThreshold(int n) {
        this.warningThreshold$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)n);
    }

    private final int getFailThreshold() {
        return ((Number)this.failThreshold$delegate.getValue((Object)this, $$delegatedProperties[3])).intValue();
    }

    private final void setFailThreshold(int n) {
        this.failThreshold$delegate.setValue((Object)this, $$delegatedProperties[3], (Object)n);
    }

    private final int getMaxIssues() {
        return ((Number)this.maxIssues$delegate.getValue((Object)this, $$delegatedProperties[4])).intValue();
    }

    private final void setMaxIssues(int n) {
        this.maxIssues$delegate.setValue((Object)this, $$delegatedProperties[4], (Object)n);
    }

    public void init(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.setBuildConfig(config.subConfig(BUILD));
        this.setWeightsConfig(this.getBuildConfig().subConfig(WEIGHTS));
        this.setWarningThreshold(((Number)this.getBuildConfig().valueOrDefault(WARNING_THRESHOLD, (Object)-1)).intValue());
        this.setFailThreshold(((Number)this.getBuildConfig().valueOrDefault(FAIL_THRESHOLD, (Object)-1)).intValue());
        this.setMaxIssues(((Number)this.getBuildConfig().valueOrDefault(MAX_ISSUES, (Object)-1)).intValue());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public String render(@NotNull Detektion detektion) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable list$iv$iv;
        void $receiver$iv$iv2;
        Map $receiver$iv2;
        Intrinsics.checkParameterIsNotNull((Object)detektion, (String)"detektion");
        Map map = $receiver$iv2 = detektion.getFindings();
        Collection destination$iv$iv = new ArrayList();
        void var6_6 = $receiver$iv$iv2;
        Iterator iterator = var6_6.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            list$iv$iv = (List)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List smells = (List)destination$iv$iv;
        HashMap<String, String> ruleToRuleSetId = this.extractRuleToRuleSetIdMap(detektion);
        list$iv$iv = $receiver$iv = (Iterable)smells;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Finding bl = (Finding)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            Integer n = this.weighted((Finding)it, (Map<String, String>)ruleToRuleSetId);
            collection.add(n);
        }
        int amount = CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv2));
        this.checkDeprecation();
        if (this.reached(this.getMaxIssues(), amount)) {
            throw (Throwable)new BuildFailure("Build failed with " + amount + " weighted issues " + "(threshold defined was " + this.getMaxIssues() + ").");
        }
        if (this.reached(this.getFailThreshold(), amount)) {
            throw (Throwable)new BuildFailure("Build failure threshold of " + this.getFailThreshold() + " reached with " + amount + " weighted smells!");
        }
        return this.reached(this.getWarningThreshold(), amount) ? "Warning: " + amount + " weighted code smells found. " + "Warning threshold is " + this.getWarningThreshold() + " and fail threshold is " + this.getFailThreshold() + '!' : null;
    }

    private final void checkDeprecation() {
        if (((Number)this.getBuildConfig().valueOrDefault(WARNING_THRESHOLD, (Object)Integer.MIN_VALUE)).intValue() != Integer.MIN_VALUE || ((Number)this.getBuildConfig().valueOrDefault(FAIL_THRESHOLD, (Object)Integer.MIN_VALUE)).intValue() != Integer.MIN_VALUE) {
            String string = "[Deprecation] - 'warningThreshold' and 'failThreshold' properties are deprecated. Please use the new 'maxIssues' config property.";
            System.out.println((Object)string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final HashMap<String, String> extractRuleToRuleSetIdMap(Detektion detektion) {
        HashMap<String, String> initial$iv;
        Object object;
        Object object2;
        Object destination$iv$iv;
        Iterable it;
        Object object3;
        Object object4;
        Map.Entry it$iv$iv;
        Map $receiver$iv$iv;
        Object $receiver$iv = detektion.getFindings();
        Map map = $receiver$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object t : $receiver$iv$iv$iv) {
            void $receiver$iv$iv2;
            Iterable $receiver$iv2;
            Map.Entry entry = (Map.Entry)t;
            Map map2 = destination$iv$iv2;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)t;
            object4 = k;
            object3 = map2;
            boolean bl = false;
            Iterable iterable = $receiver$iv2 = (Iterable)it.getValue();
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            object2 = $receiver$iv$iv2.iterator();
            while (object2.hasNext()) {
                void receiver;
                Object item$iv$iv;
                object = item$iv$iv = object2.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String string = ((Finding)receiver).getId();
                collection.add(string);
            }
            Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            object3.put(object4, set);
        }
        $receiver$iv = destination$iv$iv2;
        $receiver$iv$iv = $receiver$iv;
        Collection destination$iv$iv3 = new ArrayList($receiver$iv.size());
        Object object5 = $receiver$iv$iv;
        Iterator<Object> iterator = object5.entrySet().iterator();
        while (iterator.hasNext()) {
            void $receiver$iv$iv3;
            void map3;
            Iterable $receiver$iv3;
            Map.Entry entry;
            it$iv$iv = entry = (Map.Entry)iterator.next();
            object3 = destination$iv$iv3;
            boolean bl = false;
            it = $receiver$iv3 = (Iterable)map3.getValue();
            Collection destination$iv$iv32 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv3) {
                void it2;
                destination$iv$iv = (String)item$iv$iv2;
                object2 = destination$iv$iv32;
                boolean bl3 = false;
                object = TuplesKt.to((Object)it2, map3.getKey());
                object2.add(object);
            }
            object4 = MapsKt.toMap((Iterable)((List)destination$iv$iv32));
            object3.add(object4);
        }
        $receiver$iv = (List)destination$iv$iv3;
        HashMap<String, String> accumulator$iv = initial$iv = new HashMap<String, String>();
        object5 = $receiver$iv.iterator();
        while (object5.hasNext()) {
            Object element$iv = object5.next();
            Map map3 = (Map)element$iv;
            HashMap<String, String> result = accumulator$iv;
            boolean bl = false;
            result.putAll(map3);
            accumulator$iv = result;
        }
        return accumulator$iv;
    }

    private final int weighted(@NotNull Finding $receiver, Map<String, String> ids) {
        String key = ids.get($receiver.getId());
        return ((Number)this.getWeightsConfig().valueOrDefault($receiver.getId(), (Object)(key != null ? ((Number)this.getWeightsConfig().valueOrDefault(key, (Object)1)).intValue() : 1))).intValue();
    }

    public final boolean reached(int $receiver, int amount) {
        return ($receiver != 0 || amount != 0) && $receiver != -1 && $receiver <= amount;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/gitlab/arturbosch/detekt/cli/console/BuildFailureReport$Companion;", "", "()V", "BUILD", "", "FAIL_THRESHOLD", "MAX_ISSUES", "WARNING_THRESHOLD", "WEIGHTS", "detekt-cli"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

