/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.cli.console;

import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.cli.console.ComplexityMetric;
import io.gitlab.arturbosch.detekt.cli.console.ReportFormattingKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u0004\u0018\u00010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/gitlab/arturbosch/detekt/cli/console/ComplexityReportGenerator;", "", "complexityMetric", "Lio/gitlab/arturbosch/detekt/cli/console/ComplexityMetric;", "(Lio/gitlab/arturbosch/detekt/cli/console/ComplexityMetric;)V", "commentSourceRatio", "", "mccPerThousandLines", "numberOfSmells", "smellPerThousandLines", "cannotGenerate", "", "generate", "", "Factory", "detekt-cli"})
public final class ComplexityReportGenerator {
    private int numberOfSmells;
    private int smellPerThousandLines;
    private int mccPerThousandLines;
    private int commentSourceRatio;
    private final ComplexityMetric complexityMetric;
    public static final Factory Factory = new Factory(null);

    @Nullable
    public final String generate() {
        StringBuilder stringBuilder;
        if (this.cannotGenerate()) {
            return null;
        }
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        boolean bl = false;
        $receiver.append(ReportFormattingKt.format$default("Complexity Report:", null, null, 3, null));
        $receiver.append(ReportFormattingKt.format$default(this.complexityMetric.getLoc() + " lines of code (loc)", "\t- ", null, 2, null));
        $receiver.append(ReportFormattingKt.format$default(this.complexityMetric.getSloc() + " source lines of code (sloc)", "\t- ", null, 2, null));
        $receiver.append(ReportFormattingKt.format$default(this.complexityMetric.getLloc() + " logical lines of code (lloc)", "\t- ", null, 2, null));
        $receiver.append(ReportFormattingKt.format$default(this.complexityMetric.getCloc() + " comment lines of code (cloc)", "\t- ", null, 2, null));
        $receiver.append(ReportFormattingKt.format$default(this.complexityMetric.getMcc() + " McCabe complexity (mcc)", "\t- ", null, 2, null));
        $receiver.append(ReportFormattingKt.format$default(this.numberOfSmells + " number of total code smells", "\t- ", null, 2, null));
        $receiver.append(ReportFormattingKt.format$default(this.commentSourceRatio + " % comment source ratio", "\t- ", null, 2, null));
        $receiver.append(ReportFormattingKt.format$default(this.mccPerThousandLines + " mcc per 1000 lloc", "\t- ", null, 2, null));
        $receiver.append(ReportFormattingKt.format$default(this.smellPerThousandLines + " code smells per 1000 lloc", "\t- ", null, 2, null));
        return $receiver.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean cannotGenerate() {
        void var2_3;
        int n;
        void $receiver$iv;
        if (this.complexityMetric.getMcc() == null) {
            return true;
        }
        if (this.complexityMetric.getLloc() == null) return true;
        Integer n2 = this.complexityMetric.getLloc();
        if (n2 != null && n2 == 0) {
            return true;
        }
        if (this.complexityMetric.getSloc() == null) return true;
        Integer n3 = this.complexityMetric.getSloc();
        if (n3 != null && n3 == 0) {
            return true;
        }
        if (this.complexityMetric.getCloc() == null) {
            return true;
        }
        Iterable iterable = this.complexityMetric.getFindings();
        ComplexityReportGenerator complexityReportGenerator = this;
        int sum$iv = 0;
        for (Object element$iv : $receiver$iv) {
            void it;
            Map.Entry entry = (Map.Entry)element$iv;
            n = sum$iv;
            boolean bl = false;
            int n4 = ((List)it.getValue()).size();
            sum$iv = n + n4;
        }
        complexityReportGenerator.numberOfSmells = n = var2_3;
        this.smellPerThousandLines = this.numberOfSmells * 1000 / this.complexityMetric.getLloc();
        this.mccPerThousandLines = this.complexityMetric.getMcc() * 1000 / this.complexityMetric.getLloc();
        this.commentSourceRatio = this.complexityMetric.getCloc() * 100 / this.complexityMetric.getSloc();
        return false;
    }

    public ComplexityReportGenerator(@NotNull ComplexityMetric complexityMetric) {
        Intrinsics.checkParameterIsNotNull((Object)complexityMetric, (String)"complexityMetric");
        this.complexityMetric = complexityMetric;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/cli/console/ComplexityReportGenerator$Factory;", "", "()V", "create", "Lio/gitlab/arturbosch/detekt/cli/console/ComplexityReportGenerator;", "detektion", "Lio/gitlab/arturbosch/detekt/api/Detektion;", "detekt-cli"})
    public static final class Factory {
        @NotNull
        public final ComplexityReportGenerator create(@NotNull Detektion detektion) {
            Intrinsics.checkParameterIsNotNull((Object)detektion, (String)"detektion");
            return new ComplexityReportGenerator(new ComplexityMetric(detektion));
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

