/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.documentation;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.StringExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lio/gitlab/arturbosch/detekt/rules/documentation/EndOfSentenceFormat;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "endOfSentenceFormat", "Lkotlin/text/Regex;", "htmlTag", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "verify", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "startsWithHtmlTag", "", "", "Companion", "detekt-rules-documentation"})
public final class EndOfSentenceFormat
extends Rule {
    @NotNull
    private final Issue issue;
    private final Regex endOfSentenceFormat;
    private final Regex htmlTag;
    @NotNull
    public static final String END_OF_SENTENCE_FORMAT = "endOfSentenceFormat";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public final void verify(@NotNull KtDeclaration declaration) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            KDoc kDoc = declaration.getDocComment();
            if (kDoc == null) break block2;
            KDoc kDoc2 = kDoc;
            boolean bl = false;
            boolean bl2 = false;
            KDoc it = kDoc2;
            boolean bl3 = false;
            String text = it.getDefaultSection().getContent();
            CharSequence charSequence = text;
            boolean bl4 = false;
            if (charSequence.length() == 0 || this.startsWithHtmlTag(text)) {
                return;
            }
            if (!this.endOfSentenceFormat.containsMatchIn((CharSequence)text) && !StringExtensionsKt.lastArgumentMatchesUrl((String)text)) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)declaration), (int)0, (int)2, null), "The first sentence of this KDoc does not end with the correct punctuation.", null, null, 24, null));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean startsWithHtmlTag(String $this$startsWithHtmlTag) {
        if (!StringsKt.startsWith$default((String)$this$startsWithHtmlTag, (String)"<", (boolean)false, (int)2, null)) return false;
        CharSequence charSequence = $this$startsWithHtmlTag;
        Regex regex = this.htmlTag;
        boolean bl = false;
        if (!regex.containsMatchIn(charSequence)) return false;
        return true;
    }

    public EndOfSentenceFormat(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Maintainability, "The first sentence in a KDoc comment should end with correct punctuation.", Debt.Companion.getFIVE_MINS());
        this.endOfSentenceFormat = new Regex((String)this.valueOrDefault(END_OF_SENTENCE_FORMAT, "([.?!][ \\t\\n\\r\\f<])|([.?!:]$)"));
        this.htmlTag = new Regex("<.+>");
    }

    public /* synthetic */ EndOfSentenceFormat(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public EndOfSentenceFormat() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/documentation/EndOfSentenceFormat$Companion;", "", "()V", "END_OF_SENTENCE_FORMAT", "", "detekt-rules-documentation"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

