/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.empty;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.JunkKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r0\u0011H\u0004J\n\u0010\u0012\u001a\u00020\r*\u00020\u0013J\n\u0010\u0014\u001a\u00020\r*\u00020\u0013J\u0016\u0010\u0015\u001a\u00020\r*\u00020\u00132\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lio/gitlab/arturbosch/detekt/rules/empty/EmptyRule;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "description", "", "codeSmellMessage", "(Lio/gitlab/arturbosch/detekt/api/Config;Ljava/lang/String;Ljava/lang/String;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "checkThenBodyForLoneSemicolon", "", "expression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "reportBlock", "Lkotlin/Function1;", "addFindingIfBlockExprIsEmpty", "Lorg/jetbrains/kotlin/psi/KtExpression;", "addFindingIfBlockExprIsEmptyAndNotCommented", "checkBlockExpr", "skipIfCommented", "", "detekt-rules-empty"})
public abstract class EmptyRule
extends Rule {
    @NotNull
    private final String codeSmellMessage;
    @NotNull
    private final Issue issue;

    public EmptyRule(@NotNull Config config, @NotNull String description, @NotNull String codeSmellMessage) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)codeSmellMessage, (String)"codeSmellMessage");
        super(config, null, 2, null);
        this.codeSmellMessage = codeSmellMessage;
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Minor, description, Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ EmptyRule(Config config, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "Empty block of code detected. As they serve no purpose they should be removed.";
        }
        if ((n & 4) != 0) {
            string2 = "This empty block of code can be removed.";
        }
        this(config, string, string2);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public final void addFindingIfBlockExprIsEmpty(@NotNull KtExpression $this$addFindingIfBlockExprIsEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$addFindingIfBlockExprIsEmpty, (String)"<this>");
        this.checkBlockExpr($this$addFindingIfBlockExprIsEmpty, false);
    }

    public final void addFindingIfBlockExprIsEmptyAndNotCommented(@NotNull KtExpression $this$addFindingIfBlockExprIsEmptyAndNotCommented) {
        Intrinsics.checkNotNullParameter((Object)$this$addFindingIfBlockExprIsEmptyAndNotCommented, (String)"<this>");
        this.checkBlockExpr($this$addFindingIfBlockExprIsEmptyAndNotCommented, true);
    }

    protected final void checkThenBodyForLoneSemicolon(@NotNull KtIfExpression expression, @NotNull Function1<? super KtIfExpression, Unit> reportBlock) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter(reportBlock, (String)"reportBlock");
        PsiElement psiElement = expression.getNextSibling();
        LeafPsiElement leafPsiElement = psiElement instanceof LeafPsiElement ? (LeafPsiElement)psiElement : null;
        IElementType iElementType = leafPsiElement != null ? leafPsiElement.getElementType() : null;
        KtSingleValueToken valueOfNextSibling = iElementType instanceof KtSingleValueToken ? (KtSingleValueToken)iElementType : null;
        Object object = valueOfNextSibling;
        if (Intrinsics.areEqual(object != null && (object = object.getValue()) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString() : null, (Object)";")) {
            reportBlock.invoke((Object)expression);
        }
    }

    private final void checkBlockExpr(KtExpression $this$checkBlockExpr, boolean skipIfCommented) {
        if (!($this$checkBlockExpr instanceof KtBlockExpression)) {
            return;
        }
        boolean hasComment = JunkKt.hasCommentInside((PsiElement)((PsiElement)$this$checkBlockExpr));
        if (skipIfCommented && hasComment) {
            return;
        }
        PsiElement[] psiElementArray = ((KtBlockExpression)$this$checkBlockExpr).getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        if (((Object[])psiElementArray).length == 0 && !hasComment) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)$this$checkBlockExpr), (int)0, (int)2, null), this.codeSmellMessage, null, null, 24, null));
        }
    }

    static /* synthetic */ void checkBlockExpr$default(EmptyRule emptyRule, KtExpression ktExpression, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkBlockExpr");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        emptyRule.checkBlockExpr(ktExpression, bl);
    }
}

