/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.exceptions;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/PrintStackTrace;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "hasPrintStacktraceCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "visitCallExpression", "", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitCatchSection", "catchClause", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "detekt-rules-exceptions"})
public final class PrintStackTrace
extends Rule {
    @NotNull
    private final Issue issue;

    public PrintStackTrace(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("PrintStackTrace", Severity.CodeSmell, "Do not print a stack trace. These debug statements should be removed or replaced with a logger.", Debt.Companion.getTWENTY_MINS());
    }

    public /* synthetic */ PrintStackTrace(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        KtSimpleNameExpression callNameExpression;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        KtSimpleNameExpression ktSimpleNameExpression = callNameExpression = KtPsiUtilKt.getCallNameExpression((KtCallElement)((KtCallElement)expression));
        if (Intrinsics.areEqual((Object)(ktSimpleNameExpression != null ? ktSimpleNameExpression.getText() : null), (Object)"dumpStack")) {
            KtExpression ktExpression = KtPsiUtilKt.getReceiverExpression((KtSimpleNameExpression)callNameExpression);
            if (Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)"Thread")) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitCatchSection(@NotNull KtCatchClause catchClause) {
        block0: {
            void $this$forEachDescendantOfType$iv;
            Intrinsics.checkNotNullParameter((Object)catchClause, (String)"catchClause");
            KtExpression ktExpression = catchClause.getCatchBody();
            if (ktExpression == null) break block0;
            PsiElement psiElement = (PsiElement)ktExpression;
            Function1 action$iv = (Function1)new Function1<KtNameReferenceExpression, Unit>(catchClause, this){
                final /* synthetic */ KtCatchClause $catchClause;
                final /* synthetic */ PrintStackTrace this$0;
                {
                    this.$catchClause = $catchClause;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull KtNameReferenceExpression it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    KtParameter ktParameter = this.$catchClause.getCatchParameter();
                    if (Intrinsics.areEqual((Object)it.getText(), (Object)(ktParameter != null ? ktParameter.getName() : null)) && PrintStackTrace.access$hasPrintStacktraceCallExpression(this.this$0, it)) {
                        this.this$0.report((Finding)new CodeSmell(this.this$0.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)it), (int)0, (int)2, null), this.this$0.getIssue().getDescription(), null, null, 24, null));
                    }
                }
            };
            boolean $i$f$forEachDescendantOfType = false;
            void $this$forEachDescendantOfType$iv$iv = $this$forEachDescendantOfType$iv;
            boolean $i$f$forEachDescendantOfType2 = false;
            $this$forEachDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $action;
                }

                public void visitElement(@NotNull PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                    if (element instanceof KtNameReferenceExpression) {
                        this.$action.invoke((Object)element);
                    }
                }
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasPrintStacktraceCallExpression(KtNameReferenceExpression expression) {
        PsiElement psiElement = expression.getNextSibling();
        PsiElement methodCall = psiElement != null ? psiElement.getNextSibling() : null;
        if (!(methodCall instanceof KtCallExpression)) return false;
        String string = ((KtCallExpression)methodCall).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"methodCall.text");
        if (!StringsKt.startsWith$default((String)string, (String)"printStackTrace(", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public PrintStackTrace() {
        this(null, 1, null);
    }

    public static final /* synthetic */ boolean access$hasPrintStacktraceCallExpression(PrintStackTrace $this, KtNameReferenceExpression expression) {
        return $this.hasPrintStacktraceCallExpression(expression);
    }
}

