/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.exceptions;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.exceptions.TooGenericExceptionThrown;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R'\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/TooGenericExceptionThrown;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "exceptionNames", "", "", "getExceptionNames$annotations", "()V", "getExceptionNames", "()Ljava/util/Set;", "exceptionNames$delegate", "Lkotlin/properties/ReadOnlyProperty;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitThrowExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "detekt-rules-exceptions"})
public final class TooGenericExceptionThrown
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty exceptionNames$delegate;

    public TooGenericExceptionThrown(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Defect, "The thrown exception is too generic. Prefer throwing project specific exceptions to handle error cases.", Debt.Companion.getTWENTY_MINS());
        Object[] objectArray = new String[]{"Error", "Exception", "RuntimeException", "Throwable"};
        this.exceptionNames$delegate = ConfigPropertyKt.config((Object)CollectionsKt.listOf((Object[])objectArray), (Function1)exceptionNames.2.INSTANCE);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final Set<String> getExceptionNames() {
        return (Set)this.exceptionNames$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="exceptions which are too generic and should not be thrown")
    private static /* synthetic */ void getExceptionNames$annotations() {
    }

    public void visitThrowExpression(@NotNull KtThrowExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Object object = expression.getThrownExpression();
        if (object != null && (object = KtPsiUtilKt.referenceExpression((KtExpression)object)) != null && (object = object.getText()) != null) {
            Object it = object;
            boolean bl = false;
            if (this.getExceptionNames().contains(it)) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), (String)it + " is a too generic Exception. Prefer throwing specific exceptions that indicate a specific error case.", null, null, 24, null));
            }
        }
        super.visitThrowExpression(expression);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TooGenericExceptionThrown.class, "exceptionNames", "getExceptionNames()Ljava/util/Set;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

