/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.exceptions;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/ThrowingExceptionFromFinally;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitFinallySection", "", "finallySection", "Lorg/jetbrains/kotlin/psi/KtFinallySection;", "detekt-rules-exceptions"})
@SourceDebugExtension(value={"SMAP\nThrowingExceptionFromFinally.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThrowingExceptionFromFinally.kt\nio/gitlab/arturbosch/detekt/rules/exceptions/ThrowingExceptionFromFinally\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,45:1\n222#2,9:46\n241#2:55\n*S KotlinDebug\n*F\n+ 1 ThrowingExceptionFromFinally.kt\nio/gitlab/arturbosch/detekt/rules/exceptions/ThrowingExceptionFromFinally\n*L\n40#1:46,9\n40#1:55\n*E\n"})
public final class ThrowingExceptionFromFinally
extends Rule {
    @NotNull
    private final Issue issue;

    public ThrowingExceptionFromFinally(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("ThrowingExceptionFromFinally", Severity.Defect, "Do not throw an exception within a finally statement. This can discard exceptions and is confusing.", Debt.Companion.getTWENTY_MINS());
    }

    public /* synthetic */ ThrowingExceptionFromFinally(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public void visitFinallySection(@NotNull KtFinallySection finallySection) {
        void $this$forEachDescendantOfType$iv;
        Intrinsics.checkNotNullParameter((Object)finallySection, (String)"finallySection");
        KtBlockExpression ktBlockExpression = finallySection.getFinalExpression();
        Intrinsics.checkNotNullExpressionValue((Object)ktBlockExpression, (String)"getFinalExpression(...)");
        PsiElement psiElement = (PsiElement)ktBlockExpression;
        Function1 action$iv = arg_0 -> ThrowingExceptionFromFinally.visitFinallySection$lambda$0(this, arg_0);
        boolean $i$f$forEachDescendantOfType = false;
        void $this$forEachDescendantOfType$iv$iv = $this$forEachDescendantOfType$iv;
        boolean $i$f$forEachDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv);
        $this$forEachDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtThrowExpression) {
                    this.$action.invoke((Object)element);
                }
            }
        });
    }

    private static final Unit visitFinallySection$lambda$0(ThrowingExceptionFromFinally this$0, KtThrowExpression it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.report((Finding)new CodeSmell(this$0.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)it), (int)0, (int)2, null), this$0.getIssue().getDescription(), null, null, 24, null));
        return Unit.INSTANCE;
    }

    public ThrowingExceptionFromFinally() {
        this(null, 1, null);
    }
}

