/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.PathFiltersKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0017H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenMethodCall;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "forbiddenMethods", "", "", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "check", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitPostfixExpression", "Lorg/jetbrains/kotlin/psi/KtPostfixExpression;", "visitPrefixExpression", "Lorg/jetbrains/kotlin/psi/KtPrefixExpression;", "Companion", "detekt-rules-style"})
public final class ForbiddenMethodCall
extends Rule {
    @NotNull
    private final Issue issue;
    private final List<String> forbiddenMethods;
    @NotNull
    public static final String METHODS = "methods";
    @NotNull
    private static final List<String> DEFAULT_METHODS;
    public static final Companion Companion;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitCallExpression(expression);
        this.check((KtExpression)expression);
    }

    public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitBinaryExpression(expression);
        KtOperationReferenceExpression ktOperationReferenceExpression = expression.getOperationReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"expression.operationReference");
        this.check((KtExpression)ktOperationReferenceExpression);
    }

    public void visitPrefixExpression(@NotNull KtPrefixExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitPrefixExpression(expression);
        KtSimpleNameExpression ktSimpleNameExpression = expression.getOperationReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"expression.operationReference");
        this.check((KtExpression)ktSimpleNameExpression);
    }

    public void visitPostfixExpression(@NotNull KtPostfixExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitPostfixExpression(expression);
        KtSimpleNameExpression ktSimpleNameExpression = expression.getOperationReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"expression.operationReference");
        this.check((KtExpression)ktSimpleNameExpression);
    }

    private final void check(KtExpression expression) {
        String fqName;
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)this.getBindingContext());
        if (resolvedCall == null) {
            return;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        FqName fqName2 = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)resolvedCall2.getResultingDescriptor()));
        String string = fqName = fqName2 != null ? fqName2.asString() : null;
        if (fqName != null && this.forbiddenMethods.contains(fqName)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "The method " + fqName + " has been forbidden in the Detekt config.", null, null, 24, null));
        }
    }

    public ForbiddenMethodCall(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Mark forbidden methods. A forbidden method could be an invocation of an unstable / experimental method and hence you might want to mark it as forbidden in order to get warned about the usage.", Debt.Companion.getTEN_MINS());
        this.forbiddenMethods = PathFiltersKt.valueOrDefaultCommaSeparated((Config)this, (String)METHODS, DEFAULT_METHODS);
    }

    public /* synthetic */ ForbiddenMethodCall(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public ForbiddenMethodCall() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_METHODS = CollectionsKt.listOf((Object[])new String[]{"kotlin.io.println", "kotlin.io.print"});
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenMethodCall$Companion;", "", "()V", "DEFAULT_METHODS", "", "", "getDEFAULT_METHODS", "()Ljava/util/List;", "METHODS", "detekt-rules-style"})
    public static final class Companion {
        @NotNull
        public final List<String> getDEFAULT_METHODS() {
            return DEFAULT_METHODS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

