/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ProtectedMemberInFinalClass;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitor", "Lio/gitlab/arturbosch/detekt/rules/style/ProtectedMemberInFinalClass$DeclarationVisitor;", "hasModifiers", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitClass", "", "DeclarationVisitor", "detekt-rules-style"})
public final class ProtectedMemberInFinalClass
extends Rule {
    @NotNull
    private final Issue issue;
    private final DeclarationVisitor visitor;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (this.hasModifiers(klass)) {
            KtDeclaration it;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            Object object;
            KtPrimaryConstructor ktPrimaryConstructor = klass.getPrimaryConstructor();
            if (ktPrimaryConstructor != null) {
                ktPrimaryConstructor.accept((PsiElementVisitor)this.visitor);
            }
            if ((object = klass.getBody()) != null && (object = object.getDeclarations()) != null) {
                $this$forEach$iv = (Iterable)object;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (KtDeclaration)element$iv;
                    boolean bl = false;
                    it.accept((PsiElementVisitor)this.visitor);
                }
            }
            $this$forEach$iv = klass.getCompanionObjects();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KtObjectDeclaration)element$iv;
                boolean bl = false;
                it.accept((PsiElementVisitor)this.visitor);
            }
        }
        super.visitClass(klass);
    }

    private final boolean hasModifiers(KtClass klass) {
        boolean isNotAbstract = !KtPsiUtilKt.isAbstract((KtClass)klass);
        boolean isFinal = !KtModifierListKt.isOpen((KtModifierListOwner)((KtModifierListOwner)klass));
        boolean isNotSealed = !klass.isSealed();
        boolean isNotEnum = !klass.isEnum();
        return isNotAbstract && isFinal && isNotSealed && isNotEnum;
    }

    public ProtectedMemberInFinalClass(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Warning, "Member with protected visibility in final class is private. Consider using private or internal as modifier.", Debt.Companion.getFIVE_MINS());
        this.visitor = new DeclarationVisitor();
    }

    public /* synthetic */ ProtectedMemberInFinalClass(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public ProtectedMemberInFinalClass() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ProtectedMemberInFinalClass$DeclarationVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "(Lio/gitlab/arturbosch/detekt/rules/style/ProtectedMemberInFinalClass;)V", "visitDeclaration", "", "dcl", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "detekt-rules-style"})
    public final class DeclarationVisitor
    extends DetektVisitor {
        public void visitDeclaration(@NotNull KtDeclaration dcl) {
            Intrinsics.checkNotNullParameter((Object)dcl, (String)"dcl");
            if (KtPsiUtilKt.isProtected((KtModifierListOwner)((KtModifierListOwner)dcl)) && !KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)dcl))) {
                ProtectedMemberInFinalClass.this.report((Finding)new CodeSmell(ProtectedMemberInFinalClass.this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)dcl), (int)0, (int)2, null), ProtectedMemberInFinalClass.this.getIssue().getDescription(), null, null, 24, null));
            }
        }
    }
}

