/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtBinaryExpressionKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.style.CanBeNonNullable;
import io.gitlab.arturbosch.detekt.rules.style.CanBeNonNullable$ParameterCheckVisitor$visitNamedFunction$;
import io.gitlab.arturbosch.detekt.rules.style.CanBeNonNullable$PropertyCheckVisitor$isNullableType$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowUtilsKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \r2\u00020\u0001:\u0004\r\u000e\u000f\u0010B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/CanBeNonNullable;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "NullableParam", "ParameterCheckVisitor", "PropertyCheckVisitor", "detekt-rules-style"})
public final class CanBeNonNullable
extends Rule {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @Deprecated
    @NotNull
    private static final String REQUIRE_NOT_NULL_NAME = "requireNotNull";
    @Deprecated
    @NotNull
    private static final String CHECK_NOT_NULL_NAME = "checkNotNull";
    @Deprecated
    private static final boolean INELIGIBLE_SINGLE_EXPRESSION = false;
    @Deprecated
    private static final boolean ELIGIBLE_SINGLE_EXPRESSION = true;

    public CanBeNonNullable(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Variable can be changed to non-nullable, as it is never set to null.", Debt.Companion.getTEN_MINS());
    }

    public /* synthetic */ CanBeNonNullable(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitKtFile(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super.visitKtFile(file);
        new PropertyCheckVisitor().visitKtFile(file);
        new ParameterCheckVisitor().visitKtFile(file);
    }

    public CanBeNonNullable() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\"H\u0016J\u001c\u0010#\u001a\u00020\b*\u0004\u0018\u00010\u000f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050%H\u0002J\u0012\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'*\u00020\u0013H\u0002J\u0018\u0010)\u001a\u00020\r*\u0004\u0018\u00010\u000f2\b\u0010*\u001a\u0004\u0018\u00010\u000fH\u0002J\u0012\u0010+\u001a\b\u0012\u0004\u0012\u00020(0'*\u00020,H\u0002J\"\u0010-\u001a\u00020\r*\b\u0012\u0004\u0012\u00020.0'2\u0006\u0010\u000e\u001a\u00020\"2\u0006\u0010/\u001a\u00020(H\u0002J\u0016\u00100\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010'*\u0004\u0018\u00010\u000fH\u0002J\u0010\u00101\u001a\u0004\u0018\u00010\u000f*\u0004\u0018\u00010\u000fH\u0002J\u0016\u00102\u001a\u00020\b*\u0004\u0018\u00010\n2\u0006\u00103\u001a\u000204H\u0002J\u000e\u00105\u001a\u00020\b*\u0004\u0018\u00010\u000fH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/CanBeNonNullable$ParameterCheckVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "(Lio/gitlab/arturbosch/detekt/rules/style/CanBeNonNullable;)V", "nullableParams", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lio/gitlab/arturbosch/detekt/rules/style/CanBeNonNullable$NullableParam;", "isNullableCheck", "", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "isNegated", "updateNullableParam", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "updateCallback", "Lkotlin/Function1;", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitDotQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "visitIfExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitPostfixExpression", "Lorg/jetbrains/kotlin/psi/KtPostfixExpression;", "visitSafeQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtSafeQualifiedExpression;", "visitWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "determineSingleExpression", "candidateDescriptors", "", "evaluateBinaryExpression", "", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "evaluateCheckStatement", "elseExpression", "evaluateIsExpression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "evaluateSubjectWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "subjectDescriptor", "getNonNullChecks", "getRootExpression", "isNullable", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isValidElseExpression", "detekt-rules-style"})
    private final class ParameterCheckVisitor
    extends DetektVisitor {
        @NotNull
        private final Map<DeclarationDescriptor, NullableParam> nullableParams = new LinkedHashMap();

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public void visitNamedFunction(@NotNull KtNamedFunction function) {
            block7: {
                block6: {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    if (KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)function))) {
                        return;
                    }
                    candidateDescriptors = new LinkedHashSet<E>();
                    v0 = function.getValueParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"function.valueParameters");
                    $this$forEach$iv = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)v0), (Function1)visitNamedFunction.1.INSTANCE), (Function1)((Function1)new Function1<KtParameter, Pair<? extends DeclarationDescriptor, ? extends KtParameter>>(CanBeNonNullable.this){
                        final /* synthetic */ CanBeNonNullable this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        @Nullable
                        public final Pair<DeclarationDescriptor, KtParameter> invoke(KtParameter parameter) {
                            Pair pair;
                            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)this.this$0.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)parameter);
                            if (declarationDescriptor != null) {
                                DeclarationDescriptor it = declarationDescriptor;
                                boolean bl = false;
                                pair = TuplesKt.to((Object)it, (Object)parameter);
                            } else {
                                pair = null;
                            }
                            return pair;
                        }
                    }));
                    $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        var7_11 = (Pair)element$iv /* !! */ ;
                        $i$a$-forEach-CanBeNonNullable$ParameterCheckVisitor$visitNamedFunction$3 = false;
                        descriptor = (DeclarationDescriptor)var7_11.component1();
                        param = (KtParameter)var7_11.component2();
                        Intrinsics.checkNotNullExpressionValue((Object)descriptor, (String)"descriptor");
                        candidateDescriptors.add(descriptor);
                        Intrinsics.checkNotNullExpressionValue((Object)param, (String)"param");
                        this.nullableParams.put(descriptor, new NullableParam(param));
                    }
                    if (function.getInitializer() != null) break block6;
                    var5_8 = function.getBodyBlockExpression();
                    if (var5_8 == null || (element$iv /* !! */  = PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)var5_8))) == null) ** GOTO lbl-1000
                    $i$a$-forEach-CanBeNonNullable$ParameterCheckVisitor$visitNamedFunction$3 = (Sequence)element$iv /* !! */ ;
                    $i$f$filterIsInstance = false;
                    var7_11 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)ParameterCheckVisitor$visitNamedFunction$$inlined$filterIsInstance$1.INSTANCE);
                    if (var7_11 != null) {
                        v1 = SequencesKt.toList((Sequence)var7_11);
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = v2 = null;
                    }
                    if (v1 == null) {
                        v2 = CollectionsKt.emptyList();
                    }
                    v3 = (children = v2).size() == 1 ? this.determineSingleExpression((KtExpression)CollectionsKt.first((List)children), candidateDescriptors) : false;
                    break block7;
                }
                v3 = false;
            }
            validSingleChildExpression = v3;
            super.visitNamedFunction(function);
            children = SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)candidateDescriptors), (Function1)((Function1)new Function1<DeclarationDescriptor, NullableParam>(this.nullableParams){

                @Nullable
                public final NullableParam invoke(@NotNull DeclarationDescriptor p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return (NullableParam)((Map)this.receiver).remove(p0);
                }
            })), (Function1)((Function1)new Function1<NullableParam, Boolean>(validSingleChildExpression){
                final /* synthetic */ boolean $validSingleChildExpression;
                {
                    this.$validSingleChildExpression = $validSingleChildExpression;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull NullableParam it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    boolean onlyNonNullCheck = this.$validSingleChildExpression && it.isNonNullChecked() && !it.isNullChecked();
                    return it.isNonNullForced() || onlyNonNullCheck;
                }
            }));
            var5_8 = CanBeNonNullable.this;
            $i$f$forEach = false;
            for (E element$iv : $this$forEach$iv) {
                nullableParam = (NullableParam)element$iv;
                $i$a$-forEach-CanBeNonNullable$ParameterCheckVisitor$visitNamedFunction$6 = false;
                var5_8.report((Finding)new CodeSmell(var5_8.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)nullableParam.getParam()), (int)0, (int)2, null), "The nullable parameter '" + nullableParam.getParam().getName() + "' can be made non-nullable.", null, null, 24, null));
            }
        }

        public void visitCallExpression(@NotNull KtCallExpression expression) {
            Object object;
            CallableDescriptor callableDescriptor;
            String calleeName;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression.getCalleeExpression()), (BindingContext)CanBeNonNullable.this.getBindingContext());
            String string = calleeName = resolvedCall != null && (callableDescriptor = resolvedCall.getResultingDescriptor()) != null && (object = callableDescriptor.getName()) != null ? object.toString() : null;
            if (Intrinsics.areEqual(calleeName, (Object)CanBeNonNullable.REQUIRE_NOT_NULL_NAME) || Intrinsics.areEqual(calleeName, (Object)CanBeNonNullable.CHECK_NOT_NULL_NAME)) {
                List list = expression.getValueArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"expression.valueArguments");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtValueArgument valueArgument = (KtValueArgument)element$iv;
                    boolean bl = false;
                    if (valueArgument.getArgumentExpression() != null) {
                        KtExpression argumentExpression;
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)argumentExpression, (String)"argumentExpression");
                        this.updateNullableParam(argumentExpression, (Function1<? super NullableParam, Unit>)((Function1)visitCallExpression.1.1.1.INSTANCE));
                    }
                }
            }
            super.visitCallExpression(expression);
        }

        public void visitPostfixExpression(@NotNull KtPostfixExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (Intrinsics.areEqual((Object)expression.getOperationToken(), (Object)KtTokens.EXCLEXCL)) {
                KtExpression ktExpression = expression.getBaseExpression();
                if (ktExpression != null) {
                    KtExpression baseExpression = ktExpression;
                    boolean bl = false;
                    this.updateNullableParam(baseExpression, (Function1<? super NullableParam, Unit>)((Function1)visitPostfixExpression.1.1.INSTANCE));
                }
            }
            super.visitPostfixExpression(expression);
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public void visitWhenExpression(@NotNull KtWhenExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            var3_2 = expression.getSubjectExpression();
            if (var3_2 == null) ** GOTO lbl-1000
            it /* !! */  = var3_2;
            $i$a$-let-CanBeNonNullable$ParameterCheckVisitor$visitWhenExpression$subjectDescriptor$1 = false;
            var4_6 = it /* !! */  instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)it /* !! */  : null;
            if (var4_6 != null && (var5_7 = CallUtilKt.getResolvedCall((KtElement)((KtElement)var4_6), (BindingContext)CanBeNonNullable.this.getBindingContext())) != null) {
                v0 = var5_7.getResultingDescriptor();
            } else lbl-1000:
            // 2 sources

            {
                v0 = null;
            }
            subjectDescriptor = v0;
            v1 = expression.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"expression.entries");
            $this$flatMap$iv = v1;
            $i$f$flatMap = false;
            it /* !! */  = $this$flatMap$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$flatMapTo = false;
            for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (KtWhenEntry)element$iv$iv;
                $i$a$-flatMap-CanBeNonNullable$ParameterCheckVisitor$visitWhenExpression$whenConditions$1 = false;
                v2 = it.getConditions();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it.conditions");
                list$iv$iv = ArraysKt.asList((Object[])v2);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            whenConditions = (List)destination$iv$iv;
            if (subjectDescriptor != null) {
                this.evaluateSubjectWhenExpression(whenConditions, expression, subjectDescriptor);
            } else {
                $this$forEach$iv = whenConditions;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    whenCondition = (KtWhenCondition)element$iv;
                    $i$a$-forEach-CanBeNonNullable$ParameterCheckVisitor$visitWhenExpression$1 = false;
                    if (!(whenCondition instanceof KtWhenConditionWithExpression)) continue;
                    this.evaluateCheckStatement(((KtWhenConditionWithExpression)whenCondition).getExpression(), expression.getElseExpression());
                }
            }
            super.visitWhenExpression(expression);
        }

        public void visitIfExpression(@NotNull KtIfExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            this.evaluateCheckStatement(expression.getCondition(), expression.getElse());
            super.visitIfExpression(expression);
        }

        public void visitSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            this.updateNullableParam(expression.getReceiverExpression(), (Function1<? super NullableParam, Unit>)((Function1)visitSafeQualifiedExpression.1.INSTANCE));
            super.visitSafeQualifiedExpression(expression);
        }

        public void visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression) {
            KotlinType kotlinType;
            ReceiverParameterDescriptor receiverParameterDescriptor;
            CallableDescriptor callableDescriptor;
            Boolean isExtensionForNullable;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)CanBeNonNullable.this.getBindingContext());
            Boolean bl = isExtensionForNullable = resolvedCall != null && (callableDescriptor = resolvedCall.getResultingDescriptor()) != null && (receiverParameterDescriptor = callableDescriptor.getExtensionReceiverParameter()) != null && (kotlinType = receiverParameterDescriptor.getType()) != null ? Boolean.valueOf(kotlinType.isMarkedNullable()) : null;
            if (Intrinsics.areEqual(isExtensionForNullable, (Object)true) && (resolvedCall = this.getRootExpression(expression.getReceiverExpression())) != null) {
                ResolvedCall rootExpression = resolvedCall;
                boolean bl2 = false;
                this.updateNullableParam((KtExpression)rootExpression, (Function1<? super NullableParam, Unit>)((Function1)visitDotQualifiedExpression.1.1.INSTANCE));
            }
            super.visitDotQualifiedExpression(expression);
        }

        public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
            KtExpression ktExpression;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (Intrinsics.areEqual((Object)expression.getOperationToken(), (Object)KtTokens.ELVIS) && (ktExpression = this.getRootExpression(expression.getLeft())) != null) {
                KtExpression rootExpression = ktExpression;
                boolean bl = false;
                this.updateNullableParam(rootExpression, (Function1<? super NullableParam, Unit>)((Function1)visitBinaryExpression.1.1.INSTANCE));
            }
            super.visitBinaryExpression(expression);
        }

        private final KtExpression getRootExpression(KtExpression $this$getRootExpression) {
            KtExpression receiverExpression = $this$getRootExpression;
            while (receiverExpression instanceof KtQualifiedExpression) {
                receiverExpression = ((KtQualifiedExpression)receiverExpression).getReceiverExpression();
            }
            return receiverExpression;
        }

        private final boolean determineSingleExpression(KtExpression $this$determineSingleExpression, Set<? extends DeclarationDescriptor> candidateDescriptors) {
            boolean bl;
            KtExpression ktExpression = $this$determineSingleExpression;
            if (ktExpression instanceof KtReturnExpression) {
                bl = false;
            } else if (ktExpression instanceof KtIfExpression) {
                bl = true;
            } else if (ktExpression instanceof KtDotQualifiedExpression) {
                CallableDescriptor callableDescriptor;
                ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)this.getRootExpression($this$determineSingleExpression)), (BindingContext)CanBeNonNullable.this.getBindingContext());
                if (resolvedCall != null && (callableDescriptor = resolvedCall.getResultingDescriptor()) != null) {
                    DeclarationDescriptor p0 = (DeclarationDescriptor)callableDescriptor;
                    boolean bl2 = false;
                    bl = candidateDescriptors.contains(p0);
                } else {
                    bl = false;
                }
            } else {
                bl = !(ktExpression instanceof KtCallExpression);
            }
            return bl;
        }

        private final List<CallableDescriptor> getNonNullChecks(KtExpression $this$getNonNullChecks) {
            KtExpression ktExpression = $this$getNonNullChecks;
            return ktExpression instanceof KtBinaryExpression ? this.evaluateBinaryExpression((KtBinaryExpression)$this$getNonNullChecks) : (ktExpression instanceof KtIsExpression ? this.evaluateIsExpression((KtIsExpression)$this$getNonNullChecks) : null);
        }

        private final void evaluateCheckStatement(KtExpression $this$evaluateCheckStatement, KtExpression elseExpression) {
            block1: {
                List<CallableDescriptor> list = this.getNonNullChecks($this$evaluateCheckStatement);
                if (list == null) break block1;
                List<CallableDescriptor> nonNullChecks = list;
                boolean bl = false;
                Function1 nullableParamCallback2 = this.isValidElseExpression(elseExpression) ? (Function1)evaluateCheckStatement.1.nullableParamCallback.1.INSTANCE : (Function1)evaluateCheckStatement.1.nullableParamCallback.2.INSTANCE;
                Iterable $this$forEach$iv = nonNullChecks;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CallableDescriptor it = (CallableDescriptor)element$iv;
                    boolean bl2 = false;
                    NullableParam nullableParam = this.nullableParams.get(it);
                    if (nullableParam == null) continue;
                    nullableParamCallback2.invoke((Object)nullableParam);
                }
            }
        }

        private final List<CallableDescriptor> evaluateBinaryExpression(KtBinaryExpression $this$evaluateBinaryExpression) {
            List nonNullChecks;
            block7: {
                Collection p0;
                KtExpression leftExpression = $this$evaluateBinaryExpression.getLeft();
                KtExpression rightExpression = $this$evaluateBinaryExpression.getRight();
                nonNullChecks = new ArrayList();
                if (KtBinaryExpressionKt.isNullCheck((KtBinaryExpression)$this$evaluateBinaryExpression)) {
                    CallableDescriptor callableDescriptor = ParameterCheckVisitor.evaluateBinaryExpression$getDescriptor(CanBeNonNullable.this, leftExpression, rightExpression);
                    if (callableDescriptor != null) {
                        Object it = callableDescriptor;
                        boolean bl = false;
                        NullableParam nullableParam = this.nullableParams.get(it);
                        if (nullableParam != null) {
                            it = nullableParam;
                            boolean bl2 = false;
                            ((NullableParam)it).setNullChecked(true);
                        }
                    }
                } else if (KtBinaryExpressionKt.isNonNullCheck((KtBinaryExpression)$this$evaluateBinaryExpression)) {
                    CallableDescriptor callableDescriptor = ParameterCheckVisitor.evaluateBinaryExpression$getDescriptor(CanBeNonNullable.this, leftExpression, rightExpression);
                    if (callableDescriptor != null) {
                        p0 = callableDescriptor;
                        boolean bl = false;
                        nonNullChecks.add(p0);
                    }
                }
                List<CallableDescriptor> list = this.getNonNullChecks(leftExpression);
                if (list != null) {
                    p0 = list;
                    boolean bl = false;
                    nonNullChecks.addAll(p0);
                }
                List<CallableDescriptor> list2 = this.getNonNullChecks(rightExpression);
                if (list2 == null) break block7;
                p0 = list2;
                boolean bl = false;
                nonNullChecks.addAll(p0);
            }
            return nonNullChecks;
        }

        private final List<CallableDescriptor> evaluateIsExpression(KtIsExpression $this$evaluateIsExpression) {
            List list;
            ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)$this$evaluateIsExpression.getLeftHandSide()), (BindingContext)CanBeNonNullable.this.getBindingContext());
            if (resolvedCall == null || (resolvedCall = resolvedCall.getResultingDescriptor()) == null) {
                return CollectionsKt.emptyList();
            }
            ResolvedCall descriptor = resolvedCall;
            if (this.isNullableCheck($this$evaluateIsExpression.getTypeReference(), $this$evaluateIsExpression.isNegated())) {
                NullableParam nullableParam = this.nullableParams.get(descriptor);
                if (nullableParam != null) {
                    NullableParam it = nullableParam;
                    boolean bl = false;
                    it.setNullChecked(true);
                }
                list = CollectionsKt.emptyList();
            } else {
                list = CollectionsKt.listOf((Object)descriptor);
            }
            return list;
        }

        private final void evaluateSubjectWhenExpression(List<? extends KtWhenCondition> $this$evaluateSubjectWhenExpression, KtWhenExpression expression, CallableDescriptor subjectDescriptor) {
            block9: {
                boolean isNonNullChecked = false;
                boolean isNullChecked = false;
                Iterable $this$forEach$iv = $this$evaluateSubjectWhenExpression;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtWhenCondition whenCondition = (KtWhenCondition)element$iv;
                    boolean bl = false;
                    KtWhenCondition ktWhenCondition = whenCondition;
                    if (ktWhenCondition instanceof KtWhenConditionWithExpression) {
                        KtExpression ktExpression = ((KtWhenConditionWithExpression)whenCondition).getExpression();
                        if (!Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)"null")) continue;
                        isNullChecked = true;
                        continue;
                    }
                    if (!(ktWhenCondition instanceof KtWhenConditionIsPattern)) continue;
                    if (this.isNullableCheck(((KtWhenConditionIsPattern)whenCondition).getTypeReference(), ((KtWhenConditionIsPattern)whenCondition).isNegated())) {
                        isNullChecked = true;
                        continue;
                    }
                    isNonNullChecked = true;
                }
                if (this.isValidElseExpression(expression.getElseExpression())) {
                    if (isNullChecked) {
                        isNonNullChecked = true;
                    } else if (isNonNullChecked) {
                        isNullChecked = true;
                    }
                }
                NullableParam nullableParam = this.nullableParams.get(subjectDescriptor);
                if (nullableParam == null) break block9;
                NullableParam it = nullableParam;
                boolean bl = false;
                if (isNullChecked) {
                    it.setNullChecked(true);
                }
                if (isNonNullChecked) {
                    it.setNonNullChecked(true);
                }
            }
        }

        private final boolean isNullableCheck(KtTypeReference typeReference, boolean isNegated) {
            boolean isNullable = this.isNullable(typeReference, CanBeNonNullable.this.getBindingContext());
            return isNullable && !isNegated || !isNullable && isNegated;
        }

        private final boolean isValidElseExpression(KtExpression $this$isValidElseExpression) {
            return $this$isValidElseExpression != null && !($this$isValidElseExpression instanceof KtIfExpression) && !($this$isValidElseExpression instanceof KtWhenExpression);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isNullable(KtTypeReference $this$isNullable, BindingContext bindingContext) {
            KtTypeReference ktTypeReference = $this$isNullable;
            KtTypeReference ktTypeReference2 = ktTypeReference;
            if (ktTypeReference == null) return false;
            KtTypeReference it = ktTypeReference2;
            boolean bl = false;
            KotlinType kotlinType = (KotlinType)bindingContext.get((ReadOnlySlice)BindingContext.TYPE, (Object)it);
            ktTypeReference2 = kotlinType;
            if (kotlinType == null) return false;
            if (!ktTypeReference2.isMarkedNullable()) return false;
            return true;
        }

        private final void updateNullableParam(KtExpression expression, Function1<? super NullableParam, Unit> updateCallback) {
            block1: {
                CallableDescriptor callableDescriptor;
                ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)CanBeNonNullable.this.getBindingContext());
                if (resolvedCall == null || (callableDescriptor = resolvedCall.getResultingDescriptor()) == null) break block1;
                CallableDescriptor it = callableDescriptor;
                boolean bl = false;
                NullableParam nullableParam = this.nullableParams.get(it);
                if (nullableParam != null) {
                    NullableParam nullableParam2 = nullableParam;
                    updateCallback.invoke((Object)nullableParam2);
                }
            }
        }

        private static final CallableDescriptor evaluateBinaryExpression$getDescriptor(CanBeNonNullable this$0, KtExpression leftExpression, KtExpression rightExpression) {
            ResolvedCall resolvedCall;
            KtNameReferenceExpression ktNameReferenceExpression = leftExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)leftExpression : (rightExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)rightExpression : null);
            return ktNameReferenceExpression != null && (resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)ktNameReferenceExpression), (BindingContext)this$0.getBindingContext())) != null ? resolvedCall.getResultingDescriptor() : null;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\tR\u001a\u0010\f\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0007\"\u0004\b\r\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/CanBeNonNullable$NullableParam;", "", "param", "Lorg/jetbrains/kotlin/psi/KtParameter;", "(Lorg/jetbrains/kotlin/psi/KtParameter;)V", "isNonNullChecked", "", "()Z", "setNonNullChecked", "(Z)V", "isNonNullForced", "setNonNullForced", "isNullChecked", "setNullChecked", "getParam", "()Lorg/jetbrains/kotlin/psi/KtParameter;", "detekt-rules-style"})
    private static final class NullableParam {
        @NotNull
        private final KtParameter param;
        private boolean isNullChecked;
        private boolean isNonNullChecked;
        private boolean isNonNullForced;

        public NullableParam(@NotNull KtParameter param) {
            Intrinsics.checkNotNullParameter((Object)param, (String)"param");
            this.param = param;
        }

        @NotNull
        public final KtParameter getParam() {
            return this.param;
        }

        public final boolean isNullChecked() {
            return this.isNullChecked;
        }

        public final void setNullChecked(boolean bl) {
            this.isNullChecked = bl;
        }

        public final boolean isNonNullChecked() {
            return this.isNonNullChecked;
        }

        public final void setNonNullChecked(boolean bl) {
            this.isNonNullChecked = bl;
        }

        public final boolean isNonNullForced() {
            return this.isNonNullForced;
        }

        public final void setNonNullForced(boolean bl) {
            this.isNonNullForced = bl;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0006H\u0002J\u000e\u0010\u0015\u001a\u00020\u0014*\u0004\u0018\u00010\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u0014*\u0004\u0018\u00010\u0018H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/CanBeNonNullable$PropertyCheckVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "(Lio/gitlab/arturbosch/detekt/rules/style/CanBeNonNullable;)V", "candidateProps", "", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitBinaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitProperty", "property", "isCandidate", "", "isNullableType", "Lorg/jetbrains/kotlin/psi/KtExpression;", "returnsNullable", "Lorg/jetbrains/kotlin/psi/KtPropertyDelegate;", "detekt-rules-style"})
    private final class PropertyCheckVisitor
    extends DetektVisitor {
        @NotNull
        private final Map<FqName, KtProperty> candidateProps = new LinkedHashMap();

        /*
         * WARNING - void declaration
         */
        public void visitKtFile(@NotNull KtFile file) {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super.visitKtFile(file);
            Map<FqName, KtProperty> map = this.candidateProps;
            CanBeNonNullable canBeNonNullable = CanBeNonNullable.this;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                KtProperty property = (KtProperty)entry.getValue();
                canBeNonNullable.report((Finding)new CodeSmell(canBeNonNullable.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)property), (int)0, (int)2, null), "The nullable variable '" + property.getName() + "' can be made non-nullable.", null, null, 24, null));
            }
        }

        public void visitClass(@NotNull KtClass klass) {
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            if (!klass.isInterface()) {
                super.visitClass(klass);
            }
        }

        public void visitProperty(@NotNull KtProperty property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            KotlinType kotlinType = DataFlowUtilsKt.getKotlinTypeForComparison((KtExpression)((KtExpression)property), (BindingContext)CanBeNonNullable.this.getBindingContext());
            boolean bl = kotlinType != null ? KotlinTypeKt.isNullable((KotlinType)kotlinType) : false;
            if (bl) {
                FqName fqName = property.getFqName();
                if (this.isCandidate(property) && fqName != null) {
                    this.candidateProps.put(fqName, property);
                }
            }
            super.visitProperty(property);
        }

        public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (Intrinsics.areEqual((Object)expression.getOperationToken(), (Object)KtTokens.EQ)) {
                CallableDescriptor callableDescriptor;
                ResolvedCall resolvedCall;
                FqName fqName;
                KtExpression ktExpression = expression.getLeft();
                FqName fqName2 = fqName = ktExpression != null && (resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)ktExpression), (BindingContext)CanBeNonNullable.this.getBindingContext())) != null && (callableDescriptor = resolvedCall.getResultingDescriptor()) != null ? DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)callableDescriptor)) : null;
                if (fqName != null && this.candidateProps.containsKey(fqName)) {
                    KtExpression ktExpression2 = expression.getRight();
                    boolean bl = ktExpression2 != null ? this.isNullableType(ktExpression2) : false;
                    if (bl) {
                        this.candidateProps.remove(fqName);
                    }
                }
            }
            super.visitBinaryExpression(expression);
        }

        /*
         * Unable to fully structure code
         */
        private final boolean isCandidate(KtProperty $this$isCandidate) {
            if (KtModifierListKt.isOpen((KtModifierListOwner)((KtModifierListOwner)$this$isCandidate)) || KtModifierListKt.isAbstract((KtModifierListOwner)((KtModifierListOwner)$this$isCandidate))) {
                return false;
            }
            v0 = $this$isCandidate.getInitializer();
            if (v0 != null ? this.isNullableType(v0) : false) ** GOTO lbl-1000
            v1 = $this$isCandidate.getGetter();
            if (v1 != null ? this.isNullableType((KtExpression)v1) : false) ** GOTO lbl-1000
            v2 = $this$isCandidate.getDelegate();
            if (!(v2 != null ? this.returnsNullable(v2) : false)) {
                v3 = true;
            } else lbl-1000:
            // 3 sources

            {
                v3 = isSetToNonNullable = false;
            }
            if (!$this$isCandidate.isVar() || KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)$this$isCandidate))) ** GOTO lbl-1000
            v4 = $this$isCandidate.getSetter();
            v5 = v4 != null ? KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)v4)) : false;
            if (v5) lbl-1000:
            // 2 sources

            {
                v6 = true;
            } else {
                v6 = false;
            }
            cannotSetViaNonPrivateMeans = v6;
            return isSetToNonNullable != false && cannotSetViaNonPrivateMeans != false;
        }

        private final boolean returnsNullable(KtPropertyDelegate $this$returnsNullable) {
            boolean bl;
            KtPropertyDelegate ktPropertyDelegate = $this$returnsNullable;
            Object object = ktPropertyDelegate != null ? ktPropertyDelegate.getParent() : null;
            KtProperty ktProperty = object instanceof KtProperty ? (KtProperty)object : null;
            if (ktProperty == null) {
                return false;
            }
            KtProperty property = ktProperty;
            object = CanBeNonNullable.this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)property);
            PropertyDescriptor propertyDescriptor = object instanceof PropertyDescriptor ? (PropertyDescriptor)object : null;
            PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
            if (propertyDescriptor2 != null && (propertyDescriptor2 = propertyDescriptor2.getGetter()) != null) {
                KotlinType kotlinType;
                FunctionDescriptor functionDescriptor;
                PropertyDescriptor propertyDescriptor3 = propertyDescriptor2;
                CanBeNonNullable canBeNonNullable = CanBeNonNullable.this;
                PropertyDescriptor it = propertyDescriptor3;
                boolean bl2 = false;
                ResolvedCall resolvedCall = (ResolvedCall)canBeNonNullable.getBindingContext().get((ReadOnlySlice)BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, (Object)it);
                bl = resolvedCall != null && (functionDescriptor = (FunctionDescriptor)resolvedCall.getResultingDescriptor()) != null && (kotlinType = functionDescriptor.getReturnType()) != null ? KotlinTypeKt.isNullable((KotlinType)kotlinType) : false;
            } else {
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isNullableType(KtExpression $this$isNullableType) {
            KtExpression ktExpression = $this$isNullableType;
            if (!(ktExpression instanceof KtConstantExpression)) {
                if (ktExpression instanceof KtIfExpression) {
                    if (this.isNullableType(((KtIfExpression)$this$isNullableType).getThen())) return true;
                    if (!this.isNullableType(((KtIfExpression)$this$isNullableType).getElse())) return false;
                    return true;
                }
                if (ktExpression instanceof KtPropertyAccessor) {
                    KtReturnExpression it;
                    void $this$any$iv;
                    void $this$forEachDescendantOfType$iv$iv$iv$iv;
                    void $this$collectDescendantsOfTypeTo$iv$iv$iv;
                    Iterable $this$collectDescendantsOfType_u24default$iv;
                    boolean bl;
                    KtExpression ktExpression2 = ((KtPropertyAccessor)$this$isNullableType).getInitializer();
                    if (ktExpression2 != null && (ktExpression2 = CallUtilKt.getType((KtExpression)ktExpression2, (BindingContext)CanBeNonNullable.this.getBindingContext())) != null) {
                        if (KotlinTypeKt.isNullable((KotlinType)ktExpression2)) {
                            return true;
                        }
                        bl = false;
                    } else {
                        bl = false;
                    }
                    if (bl) return true;
                    KtExpression ktExpression3 = ((KtPropertyAccessor)$this$isNullableType).getBodyExpression();
                    if (ktExpression3 == null) return false;
                    PsiElement psiElement = (PsiElement)ktExpression3;
                    Function1 predicate$iv = PropertyCheckVisitor$isNullableType$$inlined$collectDescendantsOfType$default$1.INSTANCE;
                    boolean $i$f$collectDescendantsOfType = false;
                    void $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType_u24default$iv;
                    boolean $i$f$collectDescendantsOfType2 = false;
                    void var9_12 = $this$collectDescendantsOfType$iv$iv;
                    Collection to$iv$iv$iv = new ArrayList();
                    boolean $i$f$collectDescendantsOfTypeTo = false;
                    void var12_16 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
                    Function1 action$iv$iv$iv$iv = (Function1)new Function1<KtReturnExpression, Unit>(predicate$iv, to$iv$iv$iv){
                        final /* synthetic */ Function1 $predicate;
                        final /* synthetic */ Collection $to;
                        {
                            this.$predicate = $predicate;
                            this.$to = $to;
                            super(1);
                        }

                        /*
                         * Ignored method signature, as it can't be verified against descriptor
                         */
                        public final void invoke(@NotNull PsiElement it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                                this.$to.add(it);
                            }
                        }
                    };
                    boolean $i$f$forEachDescendantOfType = false;
                    $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
                        final /* synthetic */ Function1 $action;
                        {
                            this.$action = $action;
                        }

                        public void visitElement(@NotNull PsiElement element) {
                            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                            PsiElement it = element;
                            boolean bl = false;
                            super.visitElement(element);
                            if (element instanceof KtReturnExpression) {
                                this.$action.invoke((Object)element);
                            }
                        }
                    });
                    $this$collectDescendantsOfType_u24default$iv = (List)to$iv$iv$iv;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        return false;
                    }
                    Iterator iterator = $this$any$iv.iterator();
                    do {
                        if (!iterator.hasNext()) return false;
                        Object element$iv = iterator.next();
                        it = (KtReturnExpression)element$iv;
                        boolean bl2 = false;
                    } while (!this.isNullableType(it.getReturnedExpression()));
                    return true;
                }
                KtExpression ktExpression4 = $this$isNullableType;
                KtExpression ktExpression5 = ktExpression4;
                if (ktExpression4 == null) return false;
                KotlinType kotlinType = CallUtilKt.getType((KtExpression)ktExpression5, (BindingContext)CanBeNonNullable.this.getBindingContext());
                ktExpression5 = kotlinType;
                if (kotlinType == null) return false;
                if (!KotlinTypeKt.isNullable((KotlinType)ktExpression5)) return false;
                return true;
            }
            boolean bl = Intrinsics.areEqual((Object)((KtConstantExpression)$this$isNullableType).getText(), (Object)"null");
            return bl;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/CanBeNonNullable$Companion;", "", "()V", "CHECK_NOT_NULL_NAME", "", "ELIGIBLE_SINGLE_EXPRESSION", "", "INELIGIBLE_SINGLE_EXPRESSION", "REQUIRE_NOT_NULL_NAME", "detekt-rules-style"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

