/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0019H\u0016J\f\u0010\u001a\u001a\u00020\u0006*\u00020\u0014H\u0002J\f\u0010\u001b\u001a\u00020\u0006*\u00020\u0014H\u0002R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/CascadingCallWrapping;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "includeElvis", "", "getIncludeElvis$annotations", "()V", "getIncludeElvis", "()Z", "includeElvis$delegate", "Lkotlin/properties/ReadOnlyProperty;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "checkExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "callExpression", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "containsNewline", "receiverContainsNewline", "detekt-rules-style"})
public final class CascadingCallWrapping
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty includeElvis$delegate;

    public CascadingCallWrapping(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "If a chained call is wrapped to a new line, subsequent chained calls should be as well.", Debt.Companion.getFIVE_MINS());
        this.includeElvis$delegate = ConfigPropertyKt.config((Object)true);
    }

    public /* synthetic */ CascadingCallWrapping(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getIncludeElvis() {
        return (Boolean)this.includeElvis$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="require trailing elvis expressions to be wrapped on a new line")
    private static /* synthetic */ void getIncludeElvis$annotations() {
    }

    public void visitQualifiedExpression(@NotNull KtQualifiedExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitQualifiedExpression(expression);
        this.checkExpression((KtExpression)expression, expression.getSelectorExpression());
    }

    public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitBinaryExpression(expression);
        if (this.getIncludeElvis() && Intrinsics.areEqual((Object)expression.getOperationToken(), (Object)KtTokens.ELVIS)) {
            this.checkExpression((KtExpression)expression, expression.getRight());
        }
    }

    private final void checkExpression(KtExpression expression, KtExpression callExpression) {
        if (!this.containsNewline(expression) && this.receiverContainsNewline(expression)) {
            String string;
            String string2;
            Object object = callExpression;
            if (object != null && (object = object.getText()) != null) {
                Object it = object;
                boolean bl = false;
                string2 = " `" + (String)it + '`';
            } else {
                string2 = string = null;
            }
            if (string2 == null) {
                string = "";
            }
            String callTextOrEmpty = string;
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "Chained call" + callTextOrEmpty + " should be wrapped to a new line since preceding calls were.", null, null, 24, null));
        }
    }

    private final boolean containsNewline(KtExpression $this$containsNewline) {
        boolean bl;
        block11: {
            KtExpression lhs = null;
            KtExpression rhs = null;
            KtExpression ktExpression = $this$containsNewline;
            if (ktExpression instanceof KtQualifiedExpression) {
                lhs = ((KtQualifiedExpression)$this$containsNewline).getReceiverExpression();
                KtExpression ktExpression2 = ((KtQualifiedExpression)$this$containsNewline).getSelectorExpression();
                if (ktExpression2 == null) {
                    return false;
                }
                rhs = ktExpression2;
            } else if (ktExpression instanceof KtBinaryExpression) {
                if (!Intrinsics.areEqual((Object)((KtBinaryExpression)$this$containsNewline).getOperationToken(), (Object)KtTokens.ELVIS)) {
                    return false;
                }
                KtExpression ktExpression3 = ((KtBinaryExpression)$this$containsNewline).getLeft();
                if (ktExpression3 == null) {
                    return false;
                }
                lhs = ktExpression3;
                KtExpression ktExpression4 = ((KtBinaryExpression)$this$containsNewline).getRight();
                if (ktExpression4 == null) {
                    return false;
                }
                rhs = ktExpression4;
            } else {
                return false;
            }
            int receiverEnd = lhs.getStartOffsetInParent() + lhs.getTextLength();
            int selectorStart = rhs.getStartOffsetInParent();
            Iterable $this$any$iv = (Iterable)RangesKt.until((int)receiverEnd, (int)selectorStart);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (!($this$containsNewline.getText().charAt(it) == '\n')) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean receiverContainsNewline(KtExpression $this$receiverContainsNewline) {
        boolean bl;
        KtExpression lhs;
        KtExpression ktExpression;
        KtExpression ktExpression2 = $this$receiverContainsNewline;
        if (ktExpression2 instanceof KtQualifiedExpression) {
            ktExpression = ((KtQualifiedExpression)$this$receiverContainsNewline).getReceiverExpression();
        } else if (ktExpression2 instanceof KtBinaryExpression) {
            ktExpression = ((KtBinaryExpression)$this$receiverContainsNewline).getLeft();
            if (ktExpression == null) {
                return false;
            }
        } else {
            return false;
        }
        ktExpression2 = lhs = ktExpression;
        if (ktExpression2 instanceof KtQualifiedExpression) {
            bl = this.containsNewline(lhs);
        } else if (ktExpression2 instanceof KtUnaryExpression) {
            KtExpression ktExpression3 = ((KtUnaryExpression)lhs).getBaseExpression();
            KtQualifiedExpression ktQualifiedExpression = ktExpression3 instanceof KtQualifiedExpression ? (KtQualifiedExpression)ktExpression3 : null;
            bl = ktQualifiedExpression != null ? this.containsNewline((KtExpression)ktQualifiedExpression) : false;
        } else {
            bl = false;
        }
        return bl;
    }

    public CascadingCallWrapping() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(CascadingCallWrapping.class, "includeElvis", "getIncludeElvis()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

