/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.style.ClassOrderingKt;
import io.gitlab.arturbosch.detekt.rules.style.Section;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ClassOrdering;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitClassBody", "", "classBody", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "detekt-rules-style"})
public final class ClassOrdering
extends Rule {
    @NotNull
    private final Issue issue;

    public ClassOrdering(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Class contents should be in this order: Property declarations/initializer blocks; secondary constructors; method declarations then companion objects.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ ClassOrdering(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitClassBody(@NotNull KtClassBody classBody) {
        Intrinsics.checkNotNullParameter((Object)classBody, (String)"classBody");
        super.visitClassBody(classBody);
        Section currentSection = new Section(0);
        for (KtDeclaration ktDeclaration : classBody.getDeclarations()) {
            Section section;
            Intrinsics.checkNotNullExpressionValue((Object)ktDeclaration, (String)"ktDeclaration");
            if (ClassOrderingKt.access$toSection(ktDeclaration) == null) continue;
            if (section.compareTo(currentSection) < 0) {
                String message = ClassOrderingKt.access$toDescription(ktDeclaration) + " should be declared before " + currentSection.toDescription() + '.';
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)ktDeclaration), (int)0, (int)2, null), message, null, CollectionsKt.listOf((Object)Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)classBody), (int)0, (int)2, null)), 8, null));
                continue;
            }
            if (section.compareTo(currentSection) <= 0) continue;
            currentSection = section;
        }
    }

    public ClassOrdering() {
        this(null, 1, null);
    }
}

