/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0014H\u0002J\f\u0010\u0017\u001a\u00020\n*\u00020\u0018H\u0002J\f\u0010\u0019\u001a\u00020\u0016*\u00020\u0018H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u00020\n8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/MaxChainedCallsOnSameLine;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "maxChainedCalls", "", "getMaxChainedCalls$annotations", "()V", "getMaxChainedCalls", "()I", "maxChainedCalls$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitQualifiedExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "callOnNewLine", "", "countChainedCalls", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isReferenceToPackage", "detekt-rules-style"})
public final class MaxChainedCallsOnSameLine
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty maxChainedCalls$delegate;

    public MaxChainedCallsOnSameLine(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Chained calls beyond the maximum should be wrapped to a new line.", Debt.Companion.getFIVE_MINS());
        this.maxChainedCalls$delegate = ConfigPropertyKt.config((Object)5);
    }

    public /* synthetic */ MaxChainedCallsOnSameLine(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getMaxChainedCalls() {
        return ((Number)this.maxChainedCalls$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="maximum chained calls allowed on a single line")
    private static /* synthetic */ void getMaxChainedCalls$annotations() {
    }

    public void visitQualifiedExpression(@NotNull KtQualifiedExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitQualifiedExpression(expression);
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        PsiElement parent = expression.getParent();
        if (parent instanceof KtQualifiedExpression && !this.callOnNewLine((KtQualifiedExpression)parent)) {
            return;
        }
        if (parent instanceof KtImportDirective || parent instanceof KtPackageDirective) {
            return;
        }
        int chainedCalls = this.countChainedCalls((KtExpression)expression) + 1;
        if (chainedCalls > this.getMaxChainedCalls()) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), chainedCalls + " chained calls on a single line; more than " + this.getMaxChainedCalls() + " calls should be wrapped to a new line.", null, null, 24, null));
        }
    }

    private final int countChainedCalls(KtExpression $this$countChainedCalls) {
        int n;
        KtExpression ktExpression = $this$countChainedCalls;
        if (ktExpression instanceof KtQualifiedExpression) {
            n = this.isReferenceToPackage(((KtQualifiedExpression)$this$countChainedCalls).getReceiverExpression()) || this.callOnNewLine((KtQualifiedExpression)$this$countChainedCalls) ? 0 : this.countChainedCalls(((KtQualifiedExpression)$this$countChainedCalls).getReceiverExpression()) + 1;
        } else if (ktExpression instanceof KtUnaryExpression) {
            KtExpression ktExpression2 = ((KtUnaryExpression)$this$countChainedCalls).getBaseExpression();
            n = ktExpression2 != null ? this.countChainedCalls(ktExpression2) : 0;
        } else {
            n = 0;
        }
        return n;
    }

    private final boolean isReferenceToPackage(KtExpression $this$isReferenceToPackage) {
        KtQualifiedExpression selectorOrThis;
        KtQualifiedExpression ktQualifiedExpression = $this$isReferenceToPackage instanceof KtQualifiedExpression ? (KtQualifiedExpression)$this$isReferenceToPackage : null;
        if (ktQualifiedExpression == null || (ktQualifiedExpression = ktQualifiedExpression.getSelectorExpression()) == null) {
            ktQualifiedExpression = $this$isReferenceToPackage;
        }
        if (!((selectorOrThis = ktQualifiedExpression) instanceof KtReferenceExpression)) {
            return false;
        }
        return this.getBindingContext().get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)selectorOrThis) instanceof PackageViewDescriptor;
    }

    private final boolean callOnNewLine(KtQualifiedExpression $this$callOnNewLine) {
        KtExpression receiver = $this$callOnNewLine.getReceiverExpression();
        KtExpression ktExpression = $this$callOnNewLine.getSelectorExpression();
        if (ktExpression == null) {
            return false;
        }
        KtExpression selector = ktExpression;
        int receiverEnd = receiver.getStartOffsetInParent() + receiver.getTextLength();
        int selectorStart = selector.getStartOffsetInParent();
        return StringsKt.contains$default((CharSequence)$this$callOnNewLine.getText().subSequence(receiverEnd, selectorStart), (char)'\n', (boolean)false, (int)2, null);
    }

    public MaxChainedCallsOnSameLine() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MaxChainedCallsOnSameLine.class, "maxChainedCalls", "getMaxChainedCalls()I", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

