/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002J\f\u0010\u0010\u001a\u00020\u000e*\u00020\u0011H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/OptionalWhenBraces;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitWhenExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "hasUnnecessaryBraces", "", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "isLambdaExpressionWithoutArrow", "Lorg/jetbrains/kotlin/psi/KtExpression;", "detekt-rules-style"})
public final class OptionalWhenBraces
extends Rule {
    @NotNull
    private final Issue issue;

    public OptionalWhenBraces(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Optional braces in when expression detected.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ OptionalWhenBraces(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitWhenExpression(@NotNull KtWhenExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        for (KtWhenEntry entry : expression.getEntries()) {
            KtBlockExpression blockExpression;
            KtExpression ktExpression = entry.getExpression();
            KtBlockExpression ktBlockExpression = blockExpression = ktExpression instanceof KtBlockExpression ? (KtBlockExpression)ktExpression : null;
            boolean bl = ktBlockExpression != null ? this.hasUnnecessaryBraces(ktBlockExpression) : false;
            if (!bl) continue;
            Issue issue = this.getIssue();
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"entry");
            this.report((Finding)new CodeSmell(issue, Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)entry), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
        super.visitWhenExpression(expression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasUnnecessaryBraces(KtBlockExpression $this$hasUnnecessaryBraces) {
        PsiElement it;
        KtExpression ktExpression;
        if ($this$hasUnnecessaryBraces.getLBrace() == null) return false;
        if ($this$hasUnnecessaryBraces.getRBrace() == null) return false;
        List list = $this$hasUnnecessaryBraces.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"statements");
        KtExpression ktExpression2 = (KtExpression)CollectionsKt.singleOrNull((List)list);
        if (ktExpression2 == null) return false;
        KtExpression it2 = ktExpression = ktExpression2;
        boolean bl = false;
        if (this.isLambdaExpressionWithoutArrow(it2)) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        KtExpression ktExpression3 = ktExpression;
        if (ktExpression3 == null) return false;
        Sequence $this$none$iv = (Sequence)PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)$this$hasUnnecessaryBraces));
        boolean $i$f$none = false;
        Iterator iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (PsiElement)element$iv;
            boolean bl3 = false;
        } while (!(it instanceof PsiComment));
        return false;
    }

    private final boolean isLambdaExpressionWithoutArrow(KtExpression $this$isLambdaExpressionWithoutArrow) {
        return $this$isLambdaExpressionWithoutArrow instanceof KtLambdaExpression && ((KtLambdaExpression)$this$isLambdaExpressionWithoutArrow).getFunctionLiteral().getArrow() == null;
    }

    public OptionalWhenBraces() {
        this(null, 1, null);
    }
}

