/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementUtilsKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0012\u001a\u00020\u000e*\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0014\u0010\u0017\u001a\u00020\u000e*\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\fH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001d"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/RedundantHigherOrderMapUsage;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "isInheritorOf", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "isRedundant", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "lambdaStatements", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isReferenceTo", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "lambda", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "Companion", "detekt-rules-style"})
public final class RedundantHigherOrderMapUsage
extends Rule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @NotNull
    private static final List<FqName> mapFqNames;
    @NotNull
    private static final FqName listFqName;
    @NotNull
    private static final FqName setFqName;
    @NotNull
    private static final FqName sequenceFqName;

    public RedundantHigherOrderMapUsage(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Checks for redundant 'map' calls, which can be removed.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ RedundantHigherOrderMapUsage(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        KtExpression calleeExpression;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitCallExpression(expression);
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        KtExpression ktExpression = calleeExpression = expression.getCalleeExpression();
        if (!Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)"map")) {
            return;
        }
        KtLambdaExpression ktLambdaExpression = this.lambda(expression);
        Object functionLiteral = ktLambdaExpression != null ? ktLambdaExpression.getFunctionLiteral() : null;
        Object object = functionLiteral;
        if (object == null || (object = object.getBodyExpression()) == null || (object = object.getStatements()) == null) {
            return;
        }
        Object lambdaStatements = object;
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)this.getBindingContext());
        if (resolvedCall == null) {
            return;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        if (!CollectionsKt.contains((Iterable)mapFqNames, (Object)DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)resolvedCall2.getResultingDescriptor())))) {
            return;
        }
        ReceiverValue receiverValue = resolvedCall2.getExtensionReceiver();
        if (receiverValue == null || (receiverValue = receiverValue.getType()) == null) {
            return;
        }
        ReceiverValue receiverType = receiverValue;
        boolean receiverIsList = this.isInheritorOf((KotlinType)receiverType, listFqName);
        boolean receiverIsSet = this.isInheritorOf((KotlinType)receiverType, setFqName);
        boolean receiverIsSequence = this.isInheritorOf((KotlinType)receiverType, sequenceFqName);
        if (!(receiverIsList || receiverIsSet || receiverIsSequence)) {
            return;
        }
        if (!this.isRedundant((KtFunctionLiteral)functionLiteral, (List<? extends KtExpression>)lambdaStatements)) {
            return;
        }
        String message = lambdaStatements.size() != 1 ? "This 'map' call can be replaced with 'onEach' or 'forEach'." : (receiverIsSet ? "This 'map' call can be replaced with 'toList'." : "This 'map' call can be removed.");
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)calleeExpression), (int)0, (int)2, null), message, null, null, 24, null));
    }

    private final KtLambdaExpression lambda(KtCallExpression $this$lambda) {
        KtValueArgument argument;
        KtValueArgument ktValueArgument;
        KtValueArgument ktValueArgument2;
        List list = $this$lambda.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"lambdaArguments");
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.singleOrNull((List)list);
        if (ktLambdaArgument != null) {
            ktValueArgument2 = (KtValueArgument)ktLambdaArgument;
        } else {
            List list2 = $this$lambda.getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"valueArguments");
            ktValueArgument2 = (KtValueArgument)CollectionsKt.singleOrNull((List)list2);
        }
        if ((ktValueArgument = (argument = ktValueArgument2)) == null || (ktValueArgument = ktValueArgument.getArgumentExpression()) == null || (ktValueArgument = KtElementUtilsKt.unpackFunctionLiteral$default((KtExpression)ktValueArgument, (boolean)false, (int)1, null)) == null) {
            return null;
        }
        KtValueArgument lambda = ktValueArgument;
        List list3 = lambda.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"lambda.valueParameters");
        KtParameter ktParameter = (KtParameter)CollectionsKt.firstOrNull((List)list3);
        if ((ktParameter != null ? ktParameter.getDestructuringDeclaration() : null) != null) {
            return null;
        }
        return lambda;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInheritorOf(KotlinType $this$isInheritorOf, FqName fqName) {
        KotlinType it;
        if (Intrinsics.areEqual((Object)TypeUtilsKt.fqNameOrNull((KotlinType)$this$isInheritorOf), (Object)fqName)) return true;
        Iterable $this$any$iv = org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt.immediateSupertypes((KotlinType)$this$isInheritorOf);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (KotlinType)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual((Object)TypeUtilsKt.fqNameOrNull((KotlinType)it), (Object)fqName));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isRedundant(KtFunctionLiteral $this$isRedundant, List<? extends KtExpression> lambdaStatements) {
        boolean bl;
        block7: {
            void $this$forEachDescendantOfType$iv$iv$iv$iv;
            void $this$collectDescendantsOfTypeTo$iv$iv$iv;
            void $this$collectDescendantsOfType$iv;
            SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.FUNCTION, (Object)$this$isRedundant);
            if (simpleFunctionDescriptor == null) {
                return false;
            }
            SimpleFunctionDescriptor lambdaDescriptor = simpleFunctionDescriptor;
            List list = lambdaDescriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"lambdaDescriptor.valueParameters");
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.singleOrNull((List)list);
            if (valueParameterDescriptor == null) {
                return false;
            }
            ValueParameterDescriptor lambdaParameter = valueParameterDescriptor;
            KtExpression ktExpression = (KtExpression)CollectionsKt.lastOrNull(lambdaStatements);
            if (ktExpression == null) {
                return false;
            }
            KtExpression lastStatement = ktExpression;
            if (!this.isReferenceTo(lastStatement, lambdaParameter)) {
                return false;
            }
            PsiElement psiElement = (PsiElement)$this$isRedundant;
            Function1 predicate$iv = (Function1)new Function1<KtReturnExpression, Boolean>(lastStatement, this, lambdaDescriptor){
                final /* synthetic */ KtExpression $lastStatement;
                final /* synthetic */ RedundantHigherOrderMapUsage this$0;
                final /* synthetic */ SimpleFunctionDescriptor $lambdaDescriptor;
                {
                    this.$lastStatement = $lastStatement;
                    this.this$0 = $receiver;
                    this.$lambdaDescriptor = $lambdaDescriptor;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull KtReturnExpression it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !Intrinsics.areEqual((Object)it, (Object)this.$lastStatement) && Intrinsics.areEqual((Object)BindingContextUtilsKt.getTargetFunctionDescriptor((KtReturnExpression)it, (BindingContext)this.this$0.getBindingContext()), (Object)this.$lambdaDescriptor);
                }
            };
            boolean $i$f$collectDescendantsOfType = false;
            void $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
            boolean $i$f$collectDescendantsOfType2 = false;
            void var12_14 = $this$collectDescendantsOfType$iv$iv;
            Collection to$iv$iv$iv = new ArrayList();
            boolean $i$f$collectDescendantsOfTypeTo = false;
            void var15_18 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
            Function1 action$iv$iv$iv$iv = (Function1)new Function1<KtReturnExpression, Unit>(predicate$iv, to$iv$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Collection $to;
                {
                    this.$predicate = $predicate;
                    this.$to = $to;
                    super(1);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final void invoke(@NotNull PsiElement it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                        this.$to.add(it);
                    }
                }
            };
            boolean $i$f$forEachDescendantOfType = false;
            $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $action;
                }

                public void visitElement(@NotNull PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                    if (element instanceof KtReturnExpression) {
                        this.$action.invoke((Object)element);
                    }
                }
            });
            List returnExpressions2 = (List)to$iv$iv$iv;
            Iterable $this$all$iv = returnExpressions2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    KtReturnExpression it = (KtReturnExpression)element$iv;
                    boolean bl2 = false;
                    if (this.isReferenceTo((KtExpression)it, lambdaParameter)) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean isReferenceTo(KtExpression $this$isReferenceTo, ValueParameterDescriptor descriptor) {
        KtExpression ktExpression = $this$isReferenceTo instanceof KtReturnExpression ? ((KtReturnExpression)$this$isReferenceTo).getReturnedExpression() : $this$isReferenceTo;
        KtNameReferenceExpression nameReference = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
        KtNameReferenceExpression ktNameReferenceExpression = nameReference;
        return Intrinsics.areEqual(ktNameReferenceExpression != null && (ktNameReferenceExpression = CallUtilKt.getResolvedCall((KtElement)((KtElement)ktNameReferenceExpression), (BindingContext)this.getBindingContext())) != null ? ktNameReferenceExpression.getResultingDescriptor() : null, (Object)descriptor);
    }

    public RedundantHigherOrderMapUsage() {
        this(null, 1, null);
    }

    static {
        Object[] objectArray = new FqName[]{new FqName("kotlin.collections.map"), new FqName("kotlin.sequences.map")};
        mapFqNames = CollectionsKt.listOf((Object[])objectArray);
        listFqName = new FqName("kotlin.collections.List");
        setFqName = new FqName("kotlin.collections.Set");
        sequenceFqName = new FqName("kotlin.sequences.Sequence");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/RedundantHigherOrderMapUsage$Companion;", "", "()V", "listFqName", "Lorg/jetbrains/kotlin/name/FqName;", "mapFqNames", "", "sequenceFqName", "setFqName", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

