/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J$\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/SafeCast;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "addReport", "", "expression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "isIfElseNull", "", "thenClause", "Lorg/jetbrains/kotlin/psi/KtExpression;", "elseClause", "identifier", "", "visitIfExpression", "detekt-rules-style"})
public final class SafeCast
extends Rule {
    @NotNull
    private final Issue issue;

    public SafeCast(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Prefer to use a safe cast instead of if-else-null.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ SafeCast(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitIfExpression(@NotNull KtIfExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        KtExpression condition = expression.getCondition();
        if (condition instanceof KtIsExpression) {
            KtExpression ktExpression = ((KtIsExpression)condition).getLeftHandSide();
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"condition.leftHandSide");
            KtExpression leftHandSide = ktExpression;
            if (leftHandSide instanceof KtNameReferenceExpression) {
                boolean bl;
                String identifier = ((KtNameReferenceExpression)leftHandSide).getText();
                KtExpression thenClause = expression.getThen();
                KtExpression elseClause = expression.getElse();
                boolean bl2 = ((KtIsExpression)condition).isNegated();
                if (bl2) {
                    Intrinsics.checkNotNullExpressionValue((Object)identifier, (String)"identifier");
                    bl = this.isIfElseNull(elseClause, thenClause, identifier);
                } else if (!bl2) {
                    Intrinsics.checkNotNullExpressionValue((Object)identifier, (String)"identifier");
                    bl = this.isIfElseNull(thenClause, elseClause, identifier);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                boolean result = bl;
                if (result) {
                    this.addReport(expression);
                }
            }
        }
    }

    private final boolean isIfElseNull(KtExpression thenClause, KtExpression elseClause, String identifier) {
        PsiElement psiElement = thenClause;
        boolean hasIdentifier = Intrinsics.areEqual(psiElement != null && (psiElement = psiElement.getChildren()) != null && (psiElement = (PsiElement)ArraysKt.firstOrNull((Object[])psiElement)) != null ? psiElement.getText() : null, (Object)identifier);
        Object[] objectArray = elseClause;
        PsiElement elseStatement = elseClause != null && (objectArray = objectArray.getChildren()) != null ? (PsiElement)ArraysKt.firstOrNull((Object[])objectArray) : null;
        boolean hasNull = elseStatement instanceof KtConstantExpression && Intrinsics.areEqual((Object)((KtConstantExpression)elseStatement).getNode().getElementType(), (Object)KtNodeTypes.NULL);
        return hasIdentifier && hasNull;
    }

    private final void addReport(KtIfExpression expression) {
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "This cast should be replaced with a safe cast: as?", null, null, 24, null));
    }

    public SafeCast() {
        this(null, 1, null);
    }
}

