/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.JunkKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/SerialVersionUIDInSerializableClass;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "versionUID", "", "hasCorrectSerialVersionUUID", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "hasLongAssignment", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "hasLongType", "isImplementingSerializable", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "isLongProperty", "visitClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitObjectDeclaration", "detekt-rules-style"})
public final class SerialVersionUIDInSerializableClass
extends Rule {
    @NotNull
    private final Issue issue;
    @NotNull
    private final String versionUID;

    public SerialVersionUIDInSerializableClass(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Warning, "A class which implements the Serializable interface does not define a correct serialVersionUID field. The serialVersionUID field should be a constant long value inside a companion object.", Debt.Companion.getFIVE_MINS());
        this.versionUID = "serialVersionUID";
    }

    public /* synthetic */ SerialVersionUIDInSerializableClass(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitClass(@NotNull KtClass klass) {
        KtObjectDeclaration companionObject;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (!(klass.isInterface() || !this.isImplementingSerializable((KtClassOrObject)klass) || (companionObject = JunkKt.companionObject((KtClass)klass)) != null && this.hasCorrectSerialVersionUUID(companionObject))) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)klass), (int)0, (int)2, null), "The class " + klass.getNameAsSafeName() + " implements the Serializable interface and should thus define a serialVersionUID.", null, null, 24, null));
        }
        super.visitClass(klass);
    }

    public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!declaration.isCompanion() && this.isImplementingSerializable((KtClassOrObject)declaration) && !this.hasCorrectSerialVersionUUID(declaration)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)declaration), (int)0, (int)2, null), "The object " + declaration.getNameAsSafeName() + " implements the Serializable interface and should thus define a serialVersionUID.", null, null, 24, null));
        }
        super.visitObjectDeclaration(declaration);
    }

    private final boolean isImplementingSerializable(KtClassOrObject classOrObject) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = classOrObject.getSuperTypeListEntries();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtSuperTypeListEntry it = (KtSuperTypeListEntry)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getText(), (Object)"Serializable")) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean hasCorrectSerialVersionUUID(KtObjectDeclaration declaration) {
        KtProperty ktProperty;
        Object object = declaration.getBody();
        if (object != null && (object = object.getProperties()) != null) {
            Object v1;
            block3: {
                Iterable $this$firstOrNull$iv = (Iterable)object;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KtProperty it = (KtProperty)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)this.versionUID)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            ktProperty = v1;
        } else {
            ktProperty = null;
        }
        KtProperty property = ktProperty;
        return property != null && KtModifierListKt.isConstant((KtModifierListOwner)((KtModifierListOwner)property)) && this.isLongProperty(property);
    }

    private final boolean isLongProperty(KtProperty property) {
        return this.hasLongType(property) || this.hasLongAssignment(property);
    }

    private final boolean hasLongType(KtProperty property) {
        KtTypeReference ktTypeReference = property.getTypeReference();
        return Intrinsics.areEqual((Object)(ktTypeReference != null ? ktTypeReference.getText() : null), (Object)"Long");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasLongAssignment(KtProperty property) {
        Object v1;
        block2: {
            void $this$singleOrNull$iv;
            PsiElement[] psiElementArray = property.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"property.children");
            Object[] objectArray = psiElementArray;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (void element$iv : $this$singleOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof KtConstantExpression || it instanceof KtPrefixExpression)) continue;
                if (found$iv) {
                    v1 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        PsiElement psiElement = v1;
        if (psiElement == null) return false;
        String string = psiElement.getText();
        String assignmentText = string;
        if (assignmentText == null) return false;
        if (StringsKt.last((CharSequence)assignmentText) != 'L') return false;
        String string2 = assignmentText.substring(0, assignmentText.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        if (StringsKt.toLongOrNull((String)string2) == null) return false;
        return true;
    }

    public SerialVersionUIDInSerializableClass() {
        this(null, 1, null);
    }
}

