/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.style.UnderscoresInNumericLiterals;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty0;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 /2\u00020\u0001:\u0001/B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010$\u001a\u00020 H\u0002J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020 H\u0002J\u0010\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020 H\u0002J\u0010\u0010,\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0016J\f\u0010-\u001a\u00020\u0012*\u00020 H\u0002J\f\u0010.\u001a\u00020\u0012*\u00020\"H\u0002R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR!\u0010\r\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\f\u0012\u0004\b\u000e\u0010\b\u001a\u0004\b\u000f\u0010\nR!\u0010\u0011\u001a\u00020\u00128BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\f\u0012\u0004\b\u0013\u0010\b\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnderscoresInNumericLiterals;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "acceptableDecimalLength", "", "getAcceptableDecimalLength$annotations", "()V", "getAcceptableDecimalLength", "()I", "acceptableDecimalLength$delegate", "Lkotlin/properties/ReadOnlyProperty;", "acceptableLength", "getAcceptableLength$annotations", "getAcceptableLength", "acceptableLength$delegate", "allowNonStandardGrouping", "", "getAllowNonStandardGrouping$annotations", "getAllowNonStandardGrouping", "()Z", "allowNonStandardGrouping$delegate", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "nonCompliantRegex", "Lkotlin/text/Regex;", "checkNormalized", "", "normalizedText", "", "expression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "doReport", "message", "isNotDecimalNumber", "rawText", "isSerializable", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "normalizeForMatching", "text", "visitConstantExpression", "hasNonStandardGrouping", "isSerialUidProperty", "Companion", "detekt-rules-style"})
public final class UnderscoresInNumericLiterals
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty acceptableDecimalLength$delegate;
    @NotNull
    private final ReadOnlyProperty acceptableLength$delegate;
    @NotNull
    private final ReadOnlyProperty allowNonStandardGrouping$delegate;
    @NotNull
    private final Regex nonCompliantRegex;
    @NotNull
    private static final Regex HAS_ONLY_STANDARD_GROUPING;
    @NotNull
    private static final String HEX_PREFIX = "0x";
    @NotNull
    private static final String BIN_PREFIX = "0b";
    @NotNull
    private static final String SERIALIZABLE = "Serializable";
    @NotNull
    private static final String SERIAL_UID_PROPERTY_NAME = "serialVersionUID";

    public UnderscoresInNumericLiterals(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Report missing or invalid underscores in base 10 numbers. Numeric literals should be underscore separated to increase readability.", Debt.Companion.getFIVE_MINS());
        this.acceptableDecimalLength$delegate = ConfigPropertyKt.config((Object)5, (Function1)acceptableDecimalLength.2.INSTANCE);
        this.acceptableLength$delegate = ConfigPropertyKt.configWithFallback((KProperty0)((KProperty0)new PropertyReference0Impl((Object)this){

            @Nullable
            public Object get() {
                return UnderscoresInNumericLiterals.access$getAcceptableDecimalLength((UnderscoresInNumericLiterals)((Object)this.receiver));
            }
        }), (Object)4);
        this.allowNonStandardGrouping$delegate = ConfigPropertyKt.config((Object)false);
        this.nonCompliantRegex = new Regex("\\d{" + (this.getAcceptableLength() + 1) + ",}");
    }

    public /* synthetic */ UnderscoresInNumericLiterals(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getAcceptableDecimalLength() {
        return ((Number)this.acceptableDecimalLength$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="Length under which base 10 numbers are not required to have underscores")
    @Deprecated(message="Use `acceptableLength` instead")
    private static /* synthetic */ void getAcceptableDecimalLength$annotations() {
    }

    private final int getAcceptableLength() {
        return ((Number)this.acceptableLength$delegate.getValue((Object)this, $$delegatedProperties[1])).intValue();
    }

    @Configuration(description="Maximum number of consecutive digits that a numeric literal can have without using an underscore")
    private static /* synthetic */ void getAcceptableLength$annotations() {
    }

    private final boolean getAllowNonStandardGrouping() {
        return (Boolean)this.allowNonStandardGrouping$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @Configuration(description="If set to false, groups of exactly three digits must be used. If set to true, 100_00 is allowed.")
    private static /* synthetic */ void getAllowNonStandardGrouping$annotations() {
    }

    public void visitConstantExpression(@NotNull KtConstantExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        String string = expression.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expression.text");
        String normalizedText = this.normalizeForMatching(string);
        this.checkNormalized(normalizedText, expression);
    }

    private final void checkNormalized(String normalizedText, KtConstantExpression expression) {
        if (this.isNotDecimalNumber(normalizedText)) {
            return;
        }
        if (this.isSerialUidProperty(expression)) {
            return;
        }
        Object object = new char[]{'.'};
        String numberString = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)normalizedText, (char[])object, (boolean)false, (int)0, (int)6, null));
        if (!this.getAllowNonStandardGrouping() && this.hasNonStandardGrouping(numberString)) {
            this.doReport(expression, "The number contains a non standard grouping.");
            return;
        }
        object = numberString;
        if (this.nonCompliantRegex.containsMatchIn((CharSequence)object)) {
            this.doReport(expression, "This number should be separated by underscores in order to increase readability.");
            return;
        }
    }

    private final boolean isNotDecimalNumber(String rawText) {
        return StringsKt.toDoubleOrNull((String)StringsKt.replace$default((String)rawText, (String)"_", (String)"", (boolean)false, (int)4, null)) == null || StringsKt.startsWith$default((String)rawText, (String)HEX_PREFIX, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)rawText, (String)BIN_PREFIX, (boolean)false, (int)2, null);
    }

    private final boolean isSerialUidProperty(KtConstantExpression $this$isSerialUidProperty) {
        Object object;
        if ($this$isSerialUidProperty.getParent() instanceof KtPrefixExpression) {
            PsiElement psiElement = $this$isSerialUidProperty.getParent();
            object = psiElement != null ? psiElement.getParent() : null;
        } else {
            object = $this$isSerialUidProperty.getParent();
        }
        PsiElement propertyElement = object;
        KtProperty property = propertyElement instanceof KtProperty ? (KtProperty)propertyElement : null;
        return property != null && Intrinsics.areEqual((Object)property.getName(), (Object)SERIAL_UID_PROPERTY_NAME) && this.isSerializable(property);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isSerializable(KtProperty property) {
        boolean bl;
        List list;
        KtClassOrObject ktClassOrObject;
        KtClassOrObject containingClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)property));
        if (containingClassOrObject instanceof KtObjectDeclaration && ((KtObjectDeclaration)containingClassOrObject).isCompanion()) {
            containingClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)containingClassOrObject));
        }
        if ((ktClassOrObject = containingClassOrObject) != null && (list = ktClassOrObject.getSuperTypeListEntries()) != null) {
            boolean bl2;
            block6: {
                void $this$any$iv;
                Iterable iterable = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtSuperTypeListEntry it = (KtSuperTypeListEntry)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getText(), (Object)SERIALIZABLE)) continue;
                        bl2 = true;
                        break block6;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    private final String normalizeForMatching(String text) {
        String string = ((Object)StringsKt.trim((CharSequence)text)).toString();
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        return StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)string2, (CharSequence)"l"), (CharSequence)"d"), (CharSequence)"f");
    }

    private final void doReport(KtConstantExpression expression, String message) {
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), message, null, null, 24, null));
    }

    private final boolean hasNonStandardGrouping(String $this$hasNonStandardGrouping) {
        CharSequence charSequence;
        return StringsKt.contains$default((CharSequence)$this$hasNonStandardGrouping, (char)'_', (boolean)false, (int)2, null) && !HAS_ONLY_STANDARD_GROUPING.matches(charSequence = (CharSequence)$this$hasNonStandardGrouping);
    }

    public UnderscoresInNumericLiterals() {
        this(null, 1, null);
    }

    public static final /* synthetic */ int access$getAcceptableDecimalLength(UnderscoresInNumericLiterals $this) {
        return $this.getAcceptableDecimalLength();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(UnderscoresInNumericLiterals.class, "acceptableDecimalLength", "getAcceptableDecimalLength()I", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(UnderscoresInNumericLiterals.class, "acceptableLength", "getAcceptableLength()I", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(UnderscoresInNumericLiterals.class, "allowNonStandardGrouping", "getAllowNonStandardGrouping()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        HAS_ONLY_STANDARD_GROUPING = new Regex("\\d{1,3}(?:_\\d{3})*");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnderscoresInNumericLiterals$Companion;", "", "()V", "BIN_PREFIX", "", "HAS_ONLY_STANDARD_GROUPING", "Lkotlin/text/Regex;", "HEX_PREFIX", "SERIALIZABLE", "SERIAL_UID_PROPERTY_NAME", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

