/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style.optional;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslatorKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0018H\u0002J\f\u0010\u0019\u001a\u00020\u0017*\u00020\u0018H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/optional/OptionalUnit;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "checkFunctionWithExplicitReturnType", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "checkFunctionWithInferredReturnType", "createMessage", "", "visitBlockExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "visitNamedFunction", "canBeUsedAsValue", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isGenericOrNothingType", "Companion", "detekt-rules-style"})
public final class OptionalUnit
extends Rule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @NotNull
    private static final String UNIT = "Unit";

    public OptionalUnit(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Return type of `Unit` is unnecessary and can be safely removed.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ OptionalUnit(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        KtTypeReference typeReference = function.getTypeReference();
        if (typeReference != null) {
            this.checkFunctionWithExplicitReturnType(function, typeReference);
        } else if (!KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)function))) {
            this.checkFunctionWithInferredReturnType(function);
        }
        super.visitNamedFunction(function);
    }

    /*
     * WARNING - void declaration
     */
    public void visitBlockExpression(@NotNull KtBlockExpression expression) {
        void $this$onEach$iv;
        KtExpression it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        List list = expression.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"expression.statements");
        List statements = list;
        KtExpression ktExpression = (KtExpression)CollectionsKt.lastOrNull((List)statements);
        if (ktExpression == null) {
            return;
        }
        KtExpression lastStatement = ktExpression;
        Iterable iterable = statements;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            it = (KtExpression)element$iv$iv;
            boolean bl2 = false;
            if (!(it instanceof KtNameReferenceExpression) || !Intrinsics.areEqual((Object)((KtNameReferenceExpression)it).getText(), (Object)UNIT)) {
                bl = false;
            } else if (!Intrinsics.areEqual((Object)it, (Object)lastStatement) || Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
                bl = true;
            } else if (!BindingContextUtilsKt.isUsedAsExpression((KtExpression)it, (BindingContext)this.getBindingContext())) {
                bl = true;
            } else {
                KtExpression prev;
                KtExpression ktExpression2;
                Object v3;
                block10: {
                    Sequence $this$firstIsInstanceOrNull$iv = PsiUtilsKt.siblings((PsiElement)((PsiElement)it), (boolean)false, (boolean)false);
                    boolean $i$f$firstIsInstanceOrNull = false;
                    for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                        if (!(element$iv instanceof KtExpression)) continue;
                        v3 = element$iv;
                        break block10;
                    }
                    v3 = null;
                }
                bl = ((ktExpression2 = (prev = (KtExpression)v3)) != null && (ktExpression2 = CallUtilKt.getType((KtExpression)ktExpression2, (BindingContext)this.getBindingContext())) != null ? TypeUtilsKt.isUnit((KotlinType)ktExpression2) : false) && this.canBeUsedAsValue(prev);
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$onEach = false;
        void $this$onEach_u24lambda_u2d16$iv = var6_6 = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2d16$iv) {
            it = (KtExpression)element$iv;
            boolean bl3 = false;
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "A single Unit expression is unnecessary and can safely be removed.", null, null, 24, null));
        }
        super.visitBlockExpression(expression);
    }

    private final boolean canBeUsedAsValue(KtExpression $this$canBeUsedAsValue) {
        boolean bl;
        KtExpression ktExpression = $this$canBeUsedAsValue;
        if (ktExpression instanceof KtIfExpression) {
            KtExpression elseExpression = ((KtIfExpression)$this$canBeUsedAsValue).getElse();
            bl = elseExpression instanceof KtIfExpression ? this.canBeUsedAsValue(elseExpression) : elseExpression != null;
        } else if (ktExpression instanceof KtWhenExpression) {
            List list = ((KtWhenExpression)$this$canBeUsedAsValue).getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"entries");
            KtWhenEntry ktWhenEntry = (KtWhenEntry)CollectionsKt.lastOrNull((List)list);
            bl = (ktWhenEntry != null ? ktWhenEntry.getElseKeyword() : null) != null || WhenChecker.INSTANCE.getMissingCases((KtWhenExpression)$this$canBeUsedAsValue, this.getBindingContext()).isEmpty();
        } else {
            bl = true;
        }
        return bl;
    }

    private final void checkFunctionWithExplicitReturnType(KtNamedFunction function, KtTypeReference typeReference) {
        String typeElementText;
        KtTypeElement ktTypeElement = typeReference.getTypeElement();
        String string = typeElementText = ktTypeElement != null ? ktTypeElement.getText() : null;
        if (Intrinsics.areEqual((Object)typeElementText, (Object)UNIT)) {
            KtExpression initializer;
            KtExpression ktExpression = initializer = function.getInitializer();
            boolean bl = ktExpression != null ? this.isGenericOrNothingType(ktExpression) : false;
            if (bl) {
                return;
            }
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)typeReference), (int)0, (int)2, null), this.createMessage(function), null, null, 24, null));
        }
    }

    private final void checkFunctionWithInferredReturnType(KtNamedFunction function) {
        KtNameReferenceExpression referenceExpression;
        KtExpression ktExpression = function.getBodyExpression();
        KtNameReferenceExpression ktNameReferenceExpression = referenceExpression = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
        if (referenceExpression != null && Intrinsics.areEqual((Object)referenceExpression.getText(), (Object)UNIT)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)referenceExpression), (int)0, (int)2, null), this.createMessage(function), null, null, 24, null));
        }
    }

    private final String createMessage(KtNamedFunction function) {
        return "The function " + function.getName() + " defines a return type of Unit. This is unnecessary and can safely be removed.";
    }

    private final boolean isGenericOrNothingType(KtExpression $this$isGenericOrNothingType) {
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return false;
        }
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)$this$isGenericOrNothingType), (BindingContext)this.getBindingContext());
        boolean isGenericType = resolvedCall != null && (resolvedCall = CallTranslatorKt.getReturnType((ResolvedCall)resolvedCall)) != null ? TypeUtilsKt.isTypeParameter((KotlinType)resolvedCall) : false;
        KotlinType kotlinType = CallUtilKt.getType((KtExpression)$this$isGenericOrNothingType, (BindingContext)this.getBindingContext());
        boolean isNothingType = kotlinType != null ? TypeUtilsKt.isNothing((KotlinType)kotlinType) : false;
        return isGenericType && !isNothingType || isNothingType && !isGenericType;
    }

    public OptionalUnit() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/optional/OptionalUnit$Companion;", "", "()V", "UNIT", "", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

