/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.style.BracesOnIfStatements;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001&B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u001e\u0010\u001e\u001a\u00020\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 2\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\"H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00180 2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010$\u001a\u0004\u0018\u00010%*\u00020\u0018H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u00020\n8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR!\u0010\u0011\u001a\u00020\n8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0010\u0012\u0004\b\u0012\u0010\f\u001a\u0004\b\u0013\u0010\u000e\u00a8\u0006'"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/BracesOnIfStatements;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "multiLine", "Lio/gitlab/arturbosch/detekt/rules/style/BracesOnIfStatements$BracePolicy;", "getMultiLine$annotations", "()V", "getMultiLine", "()Lio/gitlab/arturbosch/detekt/rules/style/BracesOnIfStatements$BracePolicy;", "multiLine$delegate", "Lkotlin/properties/ReadOnlyProperty;", "singleLine", "getSingleLine$annotations", "getSingleLine", "singleLine$delegate", "hasBraces", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isMultiStatement", "policy", "report", "", "violator", "validate", "list", "", "visitIfExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "walk", "parentIfCandidate", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "BracePolicy", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nBracesOnIfStatements.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BracesOnIfStatements.kt\nio/gitlab/arturbosch/detekt/rules/style/BracesOnIfStatements\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,271:1\n1#2:272\n766#3:273\n857#3,2:274\n766#3:276\n857#3,2:277\n766#3:279\n857#3,2:280\n1774#3,4:282\n1774#3,4:286\n1855#3,2:290\n*S KotlinDebug\n*F\n+ 1 BracesOnIfStatements.kt\nio/gitlab/arturbosch/detekt/rules/style/BracesOnIfStatements\n*L\n190#1:273\n190#1:274,2\n194#1:276\n194#1:277,2\n198#1:279\n198#1:280,2\n202#1:282,4\n203#1:286,4\n211#1:290,2\n*E\n"})
public final class BracesOnIfStatements
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty singleLine$delegate;
    @NotNull
    private final ReadOnlyProperty multiLine$delegate;

    public BracesOnIfStatements(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Braces do not comply with the specified policy", Debt.Companion.getFIVE_MINS());
        this.singleLine$delegate = ConfigPropertyKt.config((Object)"never", (Function1)singleLine.2.INSTANCE);
        this.multiLine$delegate = ConfigPropertyKt.config((Object)"always", (Function1)multiLine.2.INSTANCE);
    }

    public /* synthetic */ BracesOnIfStatements(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final BracePolicy getSingleLine() {
        return (BracePolicy)((Object)this.singleLine$delegate.getValue((Object)this, $$delegatedProperties[0]));
    }

    @Configuration(description="single-line braces policy")
    private static /* synthetic */ void getSingleLine$annotations() {
    }

    private final BracePolicy getMultiLine() {
        return (BracePolicy)((Object)this.multiLine$delegate.getValue((Object)this, $$delegatedProperties[1]));
    }

    @Configuration(description="multi-line braces policy")
    private static /* synthetic */ void getMultiLine$annotations() {
    }

    public void visitIfExpression(@NotNull KtIfExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitIfExpression(expression);
        PsiElement parent = this.parentIfCandidate((KtExpression)expression);
        if (parent instanceof KtIfExpression && ((KtIfExpression)parent).getElse() == expression) {
            return;
        }
        List<KtExpression> branches = this.walk((KtExpression)expression);
        this.validate(branches, this.policy((KtExpression)expression));
    }

    private final List<KtExpression> walk(KtExpression expression) {
        List list = new ArrayList();
        KtExpression current = expression;
        while (current instanceof KtIfExpression) {
            Object object;
            if (((KtIfExpression)current).getThen() != null) {
                KtExpression it;
                boolean bl = false;
                list.add(it);
            }
            if ((object = ((KtIfExpression)current).getElse()) != null) {
                KtExpression ktExpression;
                KtExpression it = ktExpression = object;
                boolean bl = false;
                object = !(it instanceof KtIfExpression) ? ktExpression : null;
                if (object != null) {
                    it = object;
                    boolean bl2 = false;
                    list.add(it);
                }
            }
            current = ((KtIfExpression)current).getElse();
        }
        return list;
    }

    private final void validate(List<? extends KtExpression> list, BracePolicy policy) {
        List list2;
        switch (WhenMappings.$EnumSwitchMapping$0[policy.ordinal()]) {
            case 1: {
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    KtExpression it = (KtExpression)element$iv$iv;
                    boolean bl = false;
                    if (!(!this.hasBraces(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
                break;
            }
            case 2: {
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable $this$filterTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    KtExpression it = (KtExpression)element$iv$iv;
                    boolean bl = false;
                    if (!(!this.isMultiStatement(it) && this.hasBraces(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
                break;
            }
            case 3: {
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable $this$filterTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    KtExpression it = (KtExpression)element$iv$iv;
                    boolean bl = false;
                    if (!this.hasBraces(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
                break;
            }
            case 4: {
                int noBraces;
                int n;
                int n2;
                Iterable $this$count$iv = list;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n2 = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        KtExpression it = (KtExpression)element$iv;
                        boolean bl = false;
                        if (!this.hasBraces(it) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n2 = count$iv;
                }
                int braces = n2;
                Iterable $this$count$iv2 = list;
                boolean $i$f$count2 = false;
                if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv2) {
                        KtExpression it = (KtExpression)element$iv;
                        boolean bl = false;
                        if (!(!this.hasBraces(it)) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = noBraces = count$iv;
                }
                if (braces != 0 && noBraces != 0) {
                    list2 = CollectionsKt.take((Iterable)list, (int)1);
                    break;
                }
                list2 = CollectionsKt.emptyList();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List violators = list2;
        Iterable $this$forEach$iv = violators;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtExpression it = (KtExpression)element$iv;
            boolean bl = false;
            this.report(it, policy);
        }
    }

    private final void report(KtExpression violator, BracePolicy policy) {
        String string;
        PsiElement psiElement;
        PsiElement psiElement2 = this.parentIfCandidate(violator);
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
        KtIfExpression iff = (KtIfExpression)psiElement2;
        if (iff.getThen() == violator) {
            psiElement = iff.getIfKeyword();
        } else if (iff.getElse() == violator) {
            psiElement = iff.getElseKeyword();
        } else {
            throw new IllegalStateException(("Violating element (" + violator.getText() + ") is not part of this if (" + iff.getText() + ')').toString());
        }
        PsiElement reported = psiElement;
        switch (WhenMappings.$EnumSwitchMapping$0[policy.ordinal()]) {
            case 1: {
                string = "Missing braces on this branch, add them.";
                break;
            }
            case 4: {
                string = "Inconsistent braces, make sure all branches either have or don't have braces.";
                break;
            }
            case 2: {
                string = "Extra braces exist on this branch, remove them (ignore multi-statement).";
                break;
            }
            case 3: {
                string = "Extra braces exist on this branch, remove them.";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String message = string;
        Issue issue = this.getIssue();
        PsiElement psiElement3 = reported;
        if (psiElement3 == null) {
            psiElement3 = (PsiElement)violator;
        }
        this.report((Finding)new CodeSmell(issue, Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)psiElement3, (int)0, (int)2, null), message, null, null, 24, null));
    }

    private final PsiElement parentIfCandidate(KtExpression $this$parentIfCandidate) {
        return $this$parentIfCandidate.getParent().getParent();
    }

    private final boolean isMultiStatement(KtExpression expression) {
        return expression instanceof KtBlockExpression && ((KtBlockExpression)expression).getStatements().size() > 1;
    }

    private final BracePolicy policy(KtExpression expression) {
        return expression.textContains('\n') ? this.getMultiLine() : this.getSingleLine();
    }

    private final boolean hasBraces(KtExpression expression) {
        return expression instanceof KtBlockExpression;
    }

    public BracesOnIfStatements() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(BracesOnIfStatements.class, "singleLine", "getSingleLine()Lio/gitlab/arturbosch/detekt/rules/style/BracesOnIfStatements$BracePolicy;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(BracesOnIfStatements.class, "multiLine", "getMultiLine()Lio/gitlab/arturbosch/detekt/rules/style/BracesOnIfStatements$BracePolicy;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000bB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/BracesOnIfStatements$BracePolicy;", "", "config", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getConfig", "()Ljava/lang/String;", "Always", "Consistent", "Necessary", "Never", "Companion", "detekt-rules-style"})
    public static final class BracePolicy
    extends Enum<BracePolicy> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String config;
        public static final /* enum */ BracePolicy Always;
        public static final /* enum */ BracePolicy Consistent;
        public static final /* enum */ BracePolicy Necessary;
        public static final /* enum */ BracePolicy Never;
        private static final /* synthetic */ BracePolicy[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private BracePolicy(String config) {
            this.config = config;
        }

        @NotNull
        public final String getConfig() {
            return this.config;
        }

        public static BracePolicy[] values() {
            return (BracePolicy[])$VALUES.clone();
        }

        public static BracePolicy valueOf(String value) {
            return Enum.valueOf(BracePolicy.class, value);
        }

        @NotNull
        public static EnumEntries<BracePolicy> getEntries() {
            return $ENTRIES;
        }

        static {
            Always = new BracePolicy("always");
            Consistent = new BracePolicy("consistent");
            Necessary = new BracePolicy("necessary");
            Never = new BracePolicy("never");
            $VALUES = bracePolicyArray = new BracePolicy[]{BracePolicy.Always, BracePolicy.Consistent, BracePolicy.Necessary, BracePolicy.Never};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/BracesOnIfStatements$BracePolicy$Companion;", "", "()V", "getValue", "Lio/gitlab/arturbosch/detekt/rules/style/BracesOnIfStatements$BracePolicy;", "arg", "", "detekt-rules-style"})
        @SourceDebugExtension(value={"SMAP\nBracesOnIfStatements.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BracesOnIfStatements.kt\nio/gitlab/arturbosch/detekt/rules/style/BracesOnIfStatements$BracePolicy$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,271:1\n3133#2,11:272\n*S KotlinDebug\n*F\n+ 1 BracesOnIfStatements.kt\nio/gitlab/arturbosch/detekt/rules/style/BracesOnIfStatements$BracePolicy$Companion\n*L\n266#1:272,11\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BracePolicy getValue(@NotNull String arg2) {
                BracePolicy bracePolicy;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)arg2, (String)"arg");
                    BracePolicy[] $this$singleOrNull$iv = BracePolicy.values();
                    boolean $i$f$singleOrNull = false;
                    BracePolicy single$iv = null;
                    boolean found$iv = false;
                    int n = $this$singleOrNull$iv.length;
                    for (int i = 0; i < n; ++i) {
                        BracePolicy element$iv;
                        BracePolicy it = element$iv = $this$singleOrNull$iv[i];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getConfig(), (Object)arg2)) continue;
                        if (found$iv) {
                            bracePolicy = null;
                            break block3;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    bracePolicy = !found$iv ? null : single$iv;
                }
                if (bracePolicy == null) {
                    throw new IllegalStateException(("Unknown value " + arg2 + ", allowed values are: " + ArraysKt.joinToString$default((Object[])BracePolicy.values(), (CharSequence)"|", null, null, (int)0, null, null, (int)62, null)).toString());
                }
                return bracePolicy;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BracePolicy.values().length];
            try {
                nArray[BracePolicy.Always.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BracePolicy.Necessary.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BracePolicy.Never.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BracePolicy.Consistent.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

