/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.style.ClassOrderingKt;
import io.gitlab.arturbosch.detekt.rules.style.Section;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J@\u0010\t\u001a,\u0012\u001a\u0012\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\nj\u0002`\u000e0\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u000b\u0018\u00010\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ClassOrdering;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "getMinimalNumberOfViolations", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Lio/gitlab/arturbosch/detekt/rules/style/Section;", "Lio/gitlab/arturbosch/detekt/rules/style/DeclarationToSectionPair;", "declarations", "visitClassBody", "", "classBody", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nClassOrdering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassOrdering.kt\nio/gitlab/arturbosch/detekt/rules/style/ClassOrdering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n1855#2:170\n1856#2:172\n1603#2,9:173\n1855#2:182\n1856#2:184\n1612#2:185\n1963#2,14:186\n1549#2:200\n1620#2,3:201\n1#3:171\n1#3:183\n*S KotlinDebug\n*F\n+ 1 ClassOrdering.kt\nio/gitlab/arturbosch/detekt/rules/style/ClassOrdering\n*L\n73#1:170\n73#1:172\n96#1:173,9\n96#1:182\n96#1:184\n96#1:185\n118#1:186,14\n129#1:200\n129#1:201,3\n96#1:183\n*E\n"})
public final class ClassOrdering
extends Rule {
    @NotNull
    private final Issue issue;

    public ClassOrdering(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Class contents should be in this order: Property declarations/initializer blocks; secondary constructors; method declarations then companion objects.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ ClassOrdering(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitClassBody(@NotNull KtClassBody classBody) {
        Intrinsics.checkNotNullParameter((Object)classBody, (String)"classBody");
        super.visitClassBody(classBody);
        List sectionList = CollectionsKt.filterNotNull((Iterable)classBody.getDeclarations());
        if (sectionList.isEmpty()) {
            return;
        }
        Pair<List<Pair<KtDeclaration, Section>>, List<Section>> pair = this.getMinimalNumberOfViolations(sectionList);
        if (pair == null) {
            return;
        }
        Pair<List<Pair<KtDeclaration, Section>>, List<Section>> pair2 = pair;
        List violationDeclarationToSectionPair = (List)pair2.component1();
        List listOfIncreasingSection = (List)pair2.component2();
        Iterable $this$forEach$iv = violationDeclarationToSectionPair;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Section section;
            KtDeclaration declaration;
            block9: {
                Object v4;
                String string;
                block7: {
                    Section section2;
                    block8: {
                        Object v1;
                        block6: {
                            Pair pair3 = (Pair)element$iv;
                            boolean bl = false;
                            declaration = (KtDeclaration)pair3.component1();
                            section2 = (Section)pair3.component2();
                            Iterable iterable = listOfIncreasingSection;
                            for (Object t : iterable) {
                                Section it = (Section)t;
                                boolean bl2 = false;
                                if (!(it.getPriority() > section2.getPriority())) continue;
                                v1 = t;
                                break block6;
                            }
                            v1 = null;
                        }
                        if ((section = (Section)v1) == null) break block8;
                        Section it = section;
                        boolean bl = false;
                        Pair pair4 = TuplesKt.to((Object)"before", (Object)it);
                        section = pair4;
                        if (pair4 != null) break block9;
                    }
                    ClassOrdering $this$visitClassBody_u24lambda_u244_u24lambda_u243 = this;
                    boolean bl = false;
                    List list = listOfIncreasingSection;
                    string = "after";
                    List list2 = list;
                    ListIterator listIterator = list2.listIterator(list2.size());
                    while (listIterator.hasPrevious()) {
                        Object e = listIterator.previous();
                        Section it = (Section)e;
                        boolean bl3 = false;
                        if (!(it.getPriority() < section2.getPriority())) continue;
                        v4 = e;
                        break block7;
                    }
                    v4 = null;
                }
                section = TuplesKt.to((Object)string, v4);
            }
            Section section3 = section;
            String directionMsg = (String)section3.component1();
            Section anchorSection = (Section)section3.component2();
            if (anchorSection == null) continue;
            String message = ClassOrderingKt.access$toDescription(declaration) + " should be declared " + directionMsg + ' ' + anchorSection.toDescription() + '.';
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)declaration), (int)0, (int)2, null), message, null, CollectionsKt.listOf((Object)Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)classBody), (int)0, (int)2, null)), 8, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<Pair<KtDeclaration, Section>>, List<Section>> getMinimalNumberOfViolations(List<? extends KtDeclaration> declarations) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object v1;
        void $this$mapNotNullTo$iv$iv22;
        Iterable $this$mapNotNull$iv = declarations;
        int $i$f$mapNotNull = 0;
        Iterable iterable = $this$mapNotNull$iv;
        Object destination$iv$iv22 = new ArrayList();
        int $i$f$mapNotNullTo22 = 0;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv22;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KtDeclaration declaration = (KtDeclaration)element$iv$iv;
            boolean bl2 = false;
            if (ClassOrderingKt.access$toSection(declaration) != null) {
                Section it;
                boolean bl3 = false;
                pair = TuplesKt.to((Object)declaration, (Object)it);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv22.add(it$iv$iv);
        }
        List declarationWithSectionList = (List)destination$iv$iv22;
        $i$f$mapNotNull = 0;
        int $this$mapNotNullTo$iv$iv22 = declarationWithSectionList.size();
        destination$iv$iv22 = new int[$this$mapNotNullTo$iv$iv22];
        while ($i$f$mapNotNull < $this$mapNotNullTo$iv$iv22) {
            $i$f$mapNotNullTo22 = $i$f$mapNotNull++;
            destination$iv$iv22[$i$f$mapNotNullTo22] = true;
        }
        Object dp = destination$iv$iv22;
        $this$mapNotNullTo$iv$iv22 = 0;
        int destination$iv$iv22 = declarationWithSectionList.size();
        int[] $i$f$mapNotNullTo22 = new int[destination$iv$iv22];
        while ($this$mapNotNullTo$iv$iv22 < destination$iv$iv22) {
            $i$f$mapNotNullTo22[$this$forEach$iv$iv$iv] = $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv22++;
        }
        int[] backTrack = $i$f$mapNotNullTo22;
        destination$iv$iv22 = ((Object)dp).length;
        for (int i = 0; i < destination$iv$iv22; ++i) {
            for (int j = 0; j < i; ++j) {
                if (((Section)((Pair)declarationWithSectionList.get(i)).getSecond()).getPriority() < ((Section)((Pair)declarationWithSectionList.get(j)).getSecond()).getPriority() || dp[i] >= dp[j] + true) continue;
                dp[i] = dp[j] + true;
                backTrack[i] = j;
            }
        }
        int index = 0;
        Iterable $this$maxByOrNull$iv = (Iterable)ArraysKt.getIndices((int[])dp);
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = maxElem$iv;
            } else {
                int it = ((Number)maxElem$iv).intValue();
                boolean bl = false;
                Object maxValue$iv = dp[it];
                do {
                    Object e$iv = iterator$iv.next();
                    int it2 = ((Number)e$iv).intValue();
                    pair = false;
                    Object v$iv = dp[it2];
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = maxElem$iv;
            }
        }
        Integer n = v1;
        if (n == null) {
            return null;
        }
        index = n;
        Iterable $this$getMinimalNumberOfViolations_u24lambda_u248 = $this$maxByOrNull$iv = CollectionsKt.createListBuilder();
        boolean $i$a$-buildList-ClassOrdering$getMinimalNumberOfViolations$listOfIncreasingSection$22 = false;
        int oldIndex = 0;
        do {
            $this$getMinimalNumberOfViolations_u24lambda_u248.add(declarationWithSectionList.get(index));
        } while ((index = backTrack[index]) != (oldIndex = index));
        List listOfIncreasingSection = CollectionsKt.reversed((Iterable)CollectionsKt.build((List)$this$maxByOrNull$iv));
        $this$maxByOrNull$iv = listOfIncreasingSection;
        List list = CollectionsKt.minus((Iterable)declarationWithSectionList, (Iterable)CollectionsKt.toSet((Iterable)listOfIncreasingSection));
        boolean $i$f$map = false;
        void $i$a$-buildList-ClassOrdering$getMinimalNumberOfViolations$listOfIncreasingSection$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Section)it.getSecond());
        }
        return TuplesKt.to((Object)list, (Object)((List)destination$iv$iv));
    }

    public ClassOrdering() {
        this(null, 1, null);
    }
}

