/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Location;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.TextLocation;
import io.gitlab.arturbosch.detekt.api.ValueWithReason;
import io.gitlab.arturbosch.detekt.api.ValuesWithReasonKt;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import io.gitlab.arturbosch.detekt.rules.style.ForbiddenAnnotation;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@RequiresTypeResolution
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\u0004\u0018\u00010 *\u00020\u001eH\u0002J\u000e\u0010!\u001a\u0004\u0018\u00010\u0018*\u00020\"H\u0002R-\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenAnnotation;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "annotations", "", "", "Lio/gitlab/arturbosch/detekt/api/ValueWithReason;", "getAnnotations$annotations", "()V", "getAnnotations", "()Ljava/util/Map;", "annotations$delegate", "Lkotlin/properties/ReadOnlyProperty;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "check", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "visitAnnotationEntry", "annotation", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "visitExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionTypeOrNull", "Lorg/jetbrains/kotlin/types/KotlinType;", "fqNameOrNull", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "detekt-rules-style"})
public final class ForbiddenAnnotation
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty annotations$delegate;

    public ForbiddenAnnotation(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Avoid using this annotation.", Debt.Companion.getFIVE_MINS());
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"java.lang.SuppressWarnings", (Object)"it is a java annotation. Use `Suppress` instead."), TuplesKt.to((Object)"java.lang.Deprecated", (Object)"it is a java annotation. Use `kotlin.Deprecated` instead."), TuplesKt.to((Object)"java.lang.annotation.Documented", (Object)"it is a java annotation. Use `kotlin.annotation.MustBeDocumented` instead."), TuplesKt.to((Object)"java.lang.annotation.Target", (Object)"it is a java annotation. Use `kotlin.annotation.Target` instead."), TuplesKt.to((Object)"java.lang.annotation.Retention", (Object)"it is a java annotation. Use `kotlin.annotation.Retention` instead."), TuplesKt.to((Object)"java.lang.annotation.Repeatable", (Object)"it is a java annotation. Use `kotlin.annotation.Repeatable` instead."), TuplesKt.to((Object)"java.lang.annotation.Inherited", (Object)"Kotlin does not support @Inherited annotation, see https://youtrack.jetbrains.com/issue/KT-22265")};
        this.annotations$delegate = ConfigPropertyKt.config((Object)ValuesWithReasonKt.valuesWithReason((Pair[])pairArray), (Function1)annotations.2.INSTANCE);
    }

    public /* synthetic */ ForbiddenAnnotation(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final Map<String, ValueWithReason> getAnnotations() {
        return (Map)this.annotations$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="List of fully qualified annotation classes which are forbidden.")
    private static /* synthetic */ void getAnnotations$annotations() {
    }

    public void visitAnnotationEntry(@NotNull KtAnnotationEntry annotation) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            super.visitAnnotationEntry(annotation);
            KtTypeReference ktTypeReference = annotation.getTypeReference();
            if (ktTypeReference == null || (ktTypeReference = this.fqNameOrNull(ktTypeReference)) == null) break block0;
            KtTypeReference it = ktTypeReference;
            boolean bl = false;
            this.check((KtElement)annotation, (FqName)it);
        }
    }

    public void visitExpression(@NotNull KtExpression expression) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            super.visitExpression(expression);
            KotlinType kotlinType = this.expressionTypeOrNull(expression);
            if (kotlinType == null || (kotlinType = TypeUtilsKt.fqNameOrNull((KotlinType)kotlinType)) == null) break block0;
            KotlinType it = kotlinType;
            boolean bl = false;
            this.check((KtElement)expression, (FqName)it);
        }
    }

    private final void check(KtElement element, FqName fqName) {
        ValueWithReason forbidden = this.getAnnotations().get(fqName.asString());
        if (forbidden != null) {
            String message = forbidden.getReason() != null ? "The annotation `" + forbidden.getValue() + "` has been forbidden: " + forbidden.getReason() : "The annotation `" + forbidden.getValue() + "` has been forbidden in the detekt config.";
            Location location = Location.Companion.from$default((Location.Companion)Location.Companion, (PsiElement)((PsiElement)element), (int)0, (int)2, null);
            boolean bl = false;
            TextLocation textLocation = location.getText();
            PsiElement[] psiElementArray = element.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            PsiElement psiElement = (PsiElement)ArraysKt.firstOrNull((Object[])psiElementArray);
            Location location2 = Location.copy$default((Location)location, null, (TextLocation)TextLocation.copy$default((TextLocation)textLocation, (int)0, (int)(psiElement != null ? PsiUtilsKt.getEndOffset((PsiElement)psiElement) : location.getText().getEnd()), (int)1, null), null, null, (int)13, null);
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from((PsiElement)element, location2), message, null, null, 24, null));
        }
    }

    private final FqName fqNameOrNull(KtTypeReference $this$fqNameOrNull) {
        KotlinType kotlinType = (KotlinType)this.getBindingContext().get((ReadOnlySlice)BindingContext.TYPE, (Object)$this$fqNameOrNull);
        return kotlinType != null ? TypeUtilsKt.fqNameOrNull((KotlinType)kotlinType) : null;
    }

    private final KotlinType expressionTypeOrNull(KtExpression $this$expressionTypeOrNull) {
        KotlinTypeInfo kotlinTypeInfo = (KotlinTypeInfo)this.getBindingContext().get((ReadOnlySlice)BindingContext.EXPRESSION_TYPE_INFO, (Object)$this$expressionTypeOrNull);
        return kotlinTypeInfo != null ? kotlinTypeInfo.getType() : null;
    }

    public ForbiddenAnnotation() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ForbiddenAnnotation.class, "annotations", "getAnnotations()Ljava/util/Map;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

