/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ValuesWithReasonKt;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.style.ForbiddenComment;
import io.gitlab.arturbosch.detekt.rules.style.ForbiddenComment$visitKtFile$;
import io.gitlab.arturbosch.detekt.rules.style.ForbiddenCommentKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocSection;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 22\u00020\u0001:\u000212B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u000fH\u0002J\u0010\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u0015H\u0002J\u0018\u0010)\u001a\u00020#2\u0006\u0010%\u001a\u00020&2\u0006\u0010*\u001a\u00020\u0015H\u0002J\u0010\u0010+\u001a\u00020#2\u0006\u0010%\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020#2\u0006\u0010.\u001a\u00020/H\u0016J\f\u00100\u001a\u00020\u0015*\u00020,H\u0002R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR'\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\f\u0012\u0004\b\u0010\u0010\b\u001a\u0004\b\u0011\u0010\u0012R!\u0010\u0014\u001a\u00020\u00158BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\f\u0012\u0004\b\u0016\u0010\b\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR'\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\u000e8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\f\u0012\u0004\b\u001f\u0010\b\u001a\u0004\b \u0010\u0012\u00a8\u00063"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenComment;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "allowedPatterns", "Lkotlin/text/Regex;", "getAllowedPatterns$annotations", "()V", "getAllowedPatterns", "()Lkotlin/text/Regex;", "allowedPatterns$delegate", "Lkotlin/properties/ReadOnlyProperty;", "comments", "", "Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenComment$Comment;", "getComments$annotations", "getComments", "()Ljava/util/List;", "comments$delegate", "customMessage", "", "getCustomMessage$annotations", "getCustomMessage", "()Ljava/lang/String;", "customMessage$delegate", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "values", "getValues$annotations", "getValues", "values$delegate", "checkForbiddenComment", "", "text", "comment", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "getErrorMessage", "value", "reportIssue", "msg", "visitComment", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiComment;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getContent", "Comment", "Companion", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nForbiddenComment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForbiddenComment.kt\nio/gitlab/arturbosch/detekt/rules/style/ForbiddenComment\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,223:1\n286#2,15:224\n228#2,2:239\n240#2:241\n305#2:242\n1855#3,2:243\n1855#3,2:245\n1855#3,2:247\n1#4:249\n*S KotlinDebug\n*F\n+ 1 ForbiddenComment.kt\nio/gitlab/arturbosch/detekt/rules/style/ForbiddenComment\n*L\n130#1:224,15\n130#1:239,2\n130#1:241\n130#1:242\n130#1:243,2\n140#1:245,2\n146#1:247,2\n*E\n"})
public final class ForbiddenComment
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty values$delegate;
    @NotNull
    private final ReadOnlyProperty comments$delegate;
    @NotNull
    private final ReadOnlyProperty allowedPatterns$delegate;
    @NotNull
    private final ReadOnlyProperty customMessage$delegate;
    @NotNull
    public static final String DEFAULT_ERROR_MESSAGE = "This comment contains '%s' that has been defined as forbidden.";

    public ForbiddenComment(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Flags a forbidden comment.", Debt.Companion.getTEN_MINS());
        this.values$delegate = ConfigPropertyKt.config((Object)CollectionsKt.emptyList());
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"FIXME:", (Object)"Forbidden FIXME todo marker in comment, please fix the problem."), TuplesKt.to((Object)"STOPSHIP:", (Object)"Forbidden STOPSHIP todo marker in comment, please address the problem before shipping the code."), TuplesKt.to((Object)"TODO:", (Object)"Forbidden TODO todo marker in comment, please do the changes.")};
        this.comments$delegate = ConfigPropertyKt.config((Object)ValuesWithReasonKt.valuesWithReason((Pair[])pairArray), (Function1)comments.2.INSTANCE);
        this.allowedPatterns$delegate = ConfigPropertyKt.config((Object)"", (Function1)allowedPatterns.2.INSTANCE);
        this.customMessage$delegate = ConfigPropertyKt.config((Object)"");
    }

    public /* synthetic */ ForbiddenComment(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<String> getValues() {
        return (List)this.values$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="forbidden comment strings")
    @Deprecated(message="Use `comments` instead, make sure you escape your text for Regular Expressions.")
    private static /* synthetic */ void getValues$annotations() {
    }

    private final List<Comment> getComments() {
        return (List)this.comments$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="forbidden comment string patterns")
    private static /* synthetic */ void getComments$annotations() {
    }

    private final Regex getAllowedPatterns() {
        return (Regex)this.allowedPatterns$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @Configuration(description="ignores comments which match the specified regular expression. For example `Ticket|Task`.")
    private static /* synthetic */ void getAllowedPatterns$annotations() {
    }

    private final String getCustomMessage() {
        return (String)this.customMessage$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    @Configuration(description="error message which overrides the default one")
    @Deprecated(message="Use `comments` and provide `reason` against each `value`.")
    private static /* synthetic */ void getCustomMessage$annotations() {
    }

    public void visitComment(@NotNull PsiComment comment) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        super.visitComment(comment);
        String text = this.getContent(comment);
        this.checkForbiddenComment(text, (PsiElement)comment);
    }

    /*
     * WARNING - void declaration
     */
    public void visitKtFile(@NotNull KtFile file) {
        void $this$forEachDescendantOfType$iv$iv$iv$iv;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super.visitKtFile(file);
        PsiElement $this$collectDescendantsOfType_u24default$iv = (PsiElement)file;
        Function1 predicate$iv = visitKtFile$$inlined$collectDescendantsOfType$default$1.INSTANCE;
        boolean $i$f$collectDescendantsOfType = false;
        PsiElement $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType_u24default$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        PsiElement psiElement = $this$collectDescendantsOfType$iv$iv;
        Collection to$iv$iv$iv = new ArrayList();
        boolean $i$f$collectDescendantsOfTypeTo = false;
        void var10_14 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Function1 action$iv$iv$iv$iv = (Function1)new Function1<KDocSection, Unit>(predicate$iv, to$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
        $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KDocSection) {
                    this.$action.invoke((Object)element);
                }
            }
        });
        Iterable $this$forEach$iv = (List)to$iv$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KDocSection comment = (KDocSection)element$iv;
            boolean bl = false;
            String text = comment.getContent();
            this.checkForbiddenComment(text, (PsiElement)comment);
        }
    }

    private final void checkForbiddenComment(String text, PsiElement comment) {
        Object it;
        if (((CharSequence)this.getAllowedPatterns().getPattern()).length() > 0 && this.getAllowedPatterns().containsMatchIn((CharSequence)text)) {
            return;
        }
        Iterable $this$forEach$iv = this.getValues();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            if (!StringsKt.contains((CharSequence)text, (CharSequence)((CharSequence)it), (boolean)true)) continue;
            this.reportIssue(comment, this.getErrorMessage((String)it));
        }
        $this$forEach$iv = this.getComments();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Comment)element$iv;
            boolean bl = false;
            if (!((Comment)it).getValue().containsMatchIn((CharSequence)text)) continue;
            this.reportIssue(comment, this.getErrorMessage((Comment)it));
        }
    }

    private final void reportIssue(PsiElement comment, String msg) {
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)comment, (int)0, (int)2, null), msg, null, null, 24, null));
    }

    private final String getContent(PsiComment $this$getContent) {
        String string = $this$getContent.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return ForbiddenCommentKt.getCommentContent(string);
    }

    private final String getErrorMessage(Comment comment) {
        String string = comment.getReason();
        if (string == null) {
            String string2 = DEFAULT_ERROR_MESSAGE;
            Object[] objectArray = new Object[]{comment.getValue().getPattern()};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        }
        return string;
    }

    private final String getErrorMessage(String value) {
        String string;
        String it = string = this.getCustomMessage();
        boolean bl = false;
        String string2 = !(((CharSequence)it).length() == 0) ? string : null;
        if (string2 == null) {
            String string3 = DEFAULT_ERROR_MESSAGE;
            Object[] objectArray = new Object[]{value};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        }
        return string2;
    }

    public ForbiddenComment() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ForbiddenComment.class, "values", "getValues()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ForbiddenComment.class, "comments", "getComments()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ForbiddenComment.class, "allowedPatterns", "getAllowedPatterns()Lkotlin/text/Regex;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ForbiddenComment.class, "customMessage", "getCustomMessage()Ljava/lang/String;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenComment$Comment;", "", "value", "Lkotlin/text/Regex;", "reason", "", "(Lkotlin/text/Regex;Ljava/lang/String;)V", "getReason", "()Ljava/lang/String;", "getValue", "()Lkotlin/text/Regex;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "detekt-rules-style"})
    private static final class Comment {
        @NotNull
        private final Regex value;
        @Nullable
        private final String reason;

        public Comment(@NotNull Regex value, @Nullable String reason) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = value;
            this.reason = reason;
        }

        @NotNull
        public final Regex getValue() {
            return this.value;
        }

        @Nullable
        public final String getReason() {
            return this.reason;
        }

        @NotNull
        public final Regex component1() {
            return this.value;
        }

        @Nullable
        public final String component2() {
            return this.reason;
        }

        @NotNull
        public final Comment copy(@NotNull Regex value, @Nullable String reason) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Comment(value, reason);
        }

        public static /* synthetic */ Comment copy$default(Comment comment, Regex regex, String string, int n, Object object) {
            if ((n & 1) != 0) {
                regex = comment.value;
            }
            if ((n & 2) != 0) {
                string = comment.reason;
            }
            return comment.copy(regex, string);
        }

        @NotNull
        public String toString() {
            return "Comment(value=" + this.value + ", reason=" + this.reason + ')';
        }

        public int hashCode() {
            int result = this.value.hashCode();
            result = result * 31 + (this.reason == null ? 0 : this.reason.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Comment)) {
                return false;
            }
            Comment comment = (Comment)other;
            if (!Intrinsics.areEqual((Object)this.value, (Object)comment.value)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.reason, (Object)comment.reason);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenComment$Companion;", "", "()V", "DEFAULT_ERROR_MESSAGE", "", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

