/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ValuesWithReasonKt;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.style.Forbidden;
import io.gitlab.arturbosch.detekt.rules.style.ForbiddenImport;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtImportDirective;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001bH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR'\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\f\u0012\u0004\b\u0010\u0010\b\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\""}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenImport;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "forbiddenPatterns", "Lkotlin/text/Regex;", "getForbiddenPatterns$annotations", "()V", "getForbiddenPatterns", "()Lkotlin/text/Regex;", "forbiddenPatterns$delegate", "Lkotlin/properties/ReadOnlyProperty;", "imports", "", "Lio/gitlab/arturbosch/detekt/rules/style/Forbidden;", "getImports$annotations", "getImports", "()Ljava/util/List;", "imports$delegate", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "containsForbiddenPattern", "", "import", "", "defaultReason", "forbiddenImport", "visitImportDirective", "", "importDirective", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nForbiddenImport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForbiddenImport.kt\nio/gitlab/arturbosch/detekt/rules/style/ForbiddenImport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class ForbiddenImport
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty imports$delegate;
    @NotNull
    private final ReadOnlyProperty forbiddenPatterns$delegate;

    public ForbiddenImport(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Mark forbidden imports. A forbidden import could be an import for an unstable / experimental api and hence you might want to mark it as forbidden in order to get warned about the usage.", Debt.Companion.getTEN_MINS());
        this.imports$delegate = ConfigPropertyKt.config((Object)ValuesWithReasonKt.valuesWithReason((Pair[])new Pair[0]), (Function1)imports.2.INSTANCE);
        this.forbiddenPatterns$delegate = ConfigPropertyKt.config((Object)"", (Function1)forbiddenPatterns.2.INSTANCE);
    }

    public /* synthetic */ ForbiddenImport(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<Forbidden> getImports() {
        return (List)this.imports$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="imports which should not be used")
    private static /* synthetic */ void getImports$annotations() {
    }

    private final Regex getForbiddenPatterns() {
        return (Regex)this.forbiddenPatterns$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="reports imports which match the specified regular expression. For example `net.*R`.")
    private static /* synthetic */ void getForbiddenPatterns$annotations() {
    }

    public void visitImportDirective(@NotNull KtImportDirective importDirective) {
        String reason;
        Object v2;
        String string;
        block3: {
            Intrinsics.checkNotNullParameter((Object)importDirective, (String)"importDirective");
            super.visitImportDirective(importDirective);
            FqName fqName = importDirective.getImportedFqName();
            String string2 = fqName != null ? fqName.asString() : null;
            if (string2 == null) {
                string2 = "";
            }
            string = string2;
            Iterable iterable = this.getImports();
            for (Object t : iterable) {
                Forbidden it = (Forbidden)t;
                boolean bl = false;
                if (!it.getImport().matches((CharSequence)string)) continue;
                v2 = t;
                break block3;
            }
            v2 = null;
        }
        Forbidden forbidden = v2;
        String string3 = forbidden != null ? (forbidden.getReason() != null ? "The import `" + string + "` has been forbidden: " + forbidden.getReason() : this.defaultReason(string)) : (reason = this.containsForbiddenPattern(string) ? this.defaultReason(string) : null);
        if (reason != null) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)importDirective), (int)0, (int)2, null), reason, null, null, 24, null));
        }
    }

    private final String defaultReason(String forbiddenImport) {
        return "The import `" + forbiddenImport + "` has been forbidden in the detekt config.";
    }

    private final boolean containsForbiddenPattern(String string) {
        return ((CharSequence)this.getForbiddenPatterns().getPattern()).length() > 0 && this.getForbiddenPatterns().containsMatchIn((CharSequence)string);
    }

    public ForbiddenImport() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ForbiddenImport.class, "imports", "getImports()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ForbiddenImport.class, "forbiddenPatterns", "getForbiddenPatterns()Lkotlin/text/Regex;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

