/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.style.MaxChainedCallsOnSameLine$getReceiverEndPosition$;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@RequiresTypeResolution
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0017H\u0002J\f\u0010\u001a\u001a\u00020\n*\u00020\u0013H\u0002J\f\u0010\u001b\u001a\u00020\u0019*\u00020\u0013H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u00020\n8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/MaxChainedCallsOnSameLine;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "maxChainedCalls", "", "getMaxChainedCalls$annotations", "()V", "getMaxChainedCalls", "()I", "maxChainedCalls$delegate", "Lkotlin/properties/ReadOnlyProperty;", "getReceiverEndPosition", "receiver", "Lorg/jetbrains/kotlin/psi/KtExpression;", "visitQualifiedExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "callOnNewLine", "", "countChainedCalls", "isReferenceToPackageOrClass", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nMaxChainedCallsOnSameLine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MaxChainedCallsOnSameLine.kt\nio/gitlab/arturbosch/detekt/rules/style/MaxChainedCallsOnSameLine\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,122:1\n257#2,7:123\n276#2:130\n*S KotlinDebug\n*F\n+ 1 MaxChainedCallsOnSameLine.kt\nio/gitlab/arturbosch/detekt/rules/style/MaxChainedCallsOnSameLine\n*L\n107#1:123,7\n107#1:130\n*E\n"})
public final class MaxChainedCallsOnSameLine
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty maxChainedCalls$delegate;

    public MaxChainedCallsOnSameLine(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Chained calls beyond the maximum should be wrapped to a new line.", Debt.Companion.getFIVE_MINS());
        this.maxChainedCalls$delegate = ConfigPropertyKt.config((Object)5);
    }

    public /* synthetic */ MaxChainedCallsOnSameLine(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getMaxChainedCalls() {
        return ((Number)this.maxChainedCalls$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="maximum chained calls allowed on a single line")
    private static /* synthetic */ void getMaxChainedCalls$annotations() {
    }

    public void visitQualifiedExpression(@NotNull KtQualifiedExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitQualifiedExpression(expression);
        PsiElement parent = expression.getParent();
        if (parent instanceof KtQualifiedExpression && !this.callOnNewLine((KtQualifiedExpression)parent)) {
            return;
        }
        if (parent instanceof KtImportDirective || parent instanceof KtPackageDirective) {
            return;
        }
        int chainedCalls = this.countChainedCalls((KtExpression)expression) + 1;
        if (chainedCalls > this.getMaxChainedCalls()) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), chainedCalls + " chained calls on a single line; more than " + this.getMaxChainedCalls() + " calls should be wrapped to a new line.", null, null, 24, null));
        }
    }

    private final int countChainedCalls(KtExpression $this$countChainedCalls) {
        int n;
        KtExpression ktExpression = $this$countChainedCalls;
        if (ktExpression instanceof KtQualifiedExpression) {
            n = this.isReferenceToPackageOrClass(((KtQualifiedExpression)$this$countChainedCalls).getReceiverExpression()) || this.callOnNewLine((KtQualifiedExpression)$this$countChainedCalls) ? 0 : this.countChainedCalls(((KtQualifiedExpression)$this$countChainedCalls).getReceiverExpression()) + 1;
        } else if (ktExpression instanceof KtUnaryExpression) {
            KtExpression ktExpression2 = ((KtUnaryExpression)$this$countChainedCalls).getBaseExpression();
            n = ktExpression2 != null ? this.countChainedCalls(ktExpression2) : 0;
        } else {
            n = 0;
        }
        return n;
    }

    private final boolean isReferenceToPackageOrClass(KtExpression $this$isReferenceToPackageOrClass) {
        KtQualifiedExpression selectorOrThis;
        KtQualifiedExpression ktQualifiedExpression = $this$isReferenceToPackageOrClass instanceof KtQualifiedExpression ? (KtQualifiedExpression)$this$isReferenceToPackageOrClass : null;
        if (ktQualifiedExpression == null || (ktQualifiedExpression = ktQualifiedExpression.getSelectorExpression()) == null) {
            ktQualifiedExpression = $this$isReferenceToPackageOrClass;
        }
        if (!((selectorOrThis = ktQualifiedExpression) instanceof KtReferenceExpression)) {
            return false;
        }
        DeclarationDescriptor descriptor = (DeclarationDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)selectorOrThis);
        return descriptor instanceof PackageViewDescriptor || descriptor instanceof ClassDescriptor;
    }

    private final boolean callOnNewLine(KtQualifiedExpression $this$callOnNewLine) {
        KtExpression receiver = $this$callOnNewLine.getReceiverExpression();
        KtExpression ktExpression = $this$callOnNewLine.getSelectorExpression();
        if (ktExpression == null) {
            return false;
        }
        KtExpression selector = ktExpression;
        int receiverEnd = this.getReceiverEndPosition(receiver);
        int selectorStart = selector.getStartOffsetInParent();
        return StringsKt.contains$default((CharSequence)$this$callOnNewLine.getText().subSequence(receiverEnd, selectorStart + 1), (char)'\n', (boolean)false, (int)2, null);
    }

    private final int getReceiverEndPosition(KtExpression receiver) {
        int n;
        Ref.BooleanRef receiverDotQualifiedExpressionPassed = new Ref.BooleanRef();
        PsiElement $this$findDescendantOfType_u24default$iv = (PsiElement)receiver;
        Function1 predicate$iv = getReceiverEndPosition$$inlined$findDescendantOfType$default$1.INSTANCE;
        boolean $i$f$findDescendantOfType = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType_u24default$iv);
        Ref.ObjectRef result$iv = new Ref.ObjectRef();
        $this$findDescendantOfType_u24default$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv, receiver, receiverDotQualifiedExpressionPassed){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ KtExpression $receiver$inlined;
            final /* synthetic */ Ref.BooleanRef $receiverDotQualifiedExpressionPassed$inlined;
            {
                this.$predicate = $predicate;
                this.$result = $result;
                this.$receiver$inlined = ktExpression;
                this.$receiverDotQualifiedExpressionPassed$inlined = booleanRef;
            }

            public void visitElement(@NotNull PsiElement element) {
                boolean canGoInside;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtCallExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                boolean bl2 = canGoInside = Intrinsics.areEqual((Object)it, (Object)this.$receiver$inlined) || !this.$receiverDotQualifiedExpressionPassed$inlined.element || !(it instanceof KtDotQualifiedExpression);
                if (it instanceof KtDotQualifiedExpression) {
                    this.$receiverDotQualifiedExpressionPassed$inlined.element = true;
                }
                if (canGoInside) {
                    super.visitElement(element);
                }
            }
        });
        KtCallExpression callExpression = (KtCallExpression)((PsiElement)result$iv.element);
        KtCallExpression ktCallExpression = callExpression;
        if (ktCallExpression != null && (ktCallExpression = ktCallExpression.getCalleeExpression()) != null) {
            KtCallExpression it = ktCallExpression;
            boolean bl = false;
            PsiElement psiElement = (PsiElement)it;
            PsiElement psiElement2 = receiver.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getParent(...)");
            n = PsiUtilsKt.getStartOffsetIn((PsiElement)psiElement, (PsiElement)psiElement2) + it.getTextLength() - 1;
        } else {
            n = MaxChainedCallsOnSameLine.getReceiverEndPosition$indexOfReceiverEnd(receiver);
        }
        return n;
    }

    private static final int getReceiverEndPosition$indexOfReceiverEnd(KtExpression $receiver) {
        return $receiver.getStartOffsetInParent() + $receiver.getTextLength() - 1;
    }

    public MaxChainedCallsOnSameLine() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MaxChainedCallsOnSameLine.class, "maxChainedCalls", "getMaxChainedCalls()I", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

