/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.github.detekt.psi.KtFilesKt;
import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Location;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.SourceLocation;
import io.gitlab.arturbosch.detekt.api.TextLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\f\u0010\u0005\u001a\u00020\u0003*\u00020\u0001H\u0002\u001a\u0014\u0010\u0006\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0002\u001a\u001c\u0010\t\u001a\u00020\n*\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002\u001a\f\u0010\u0011\u001a\u00020\u000f*\u00020\u0012H\u0002\u001a\f\u0010\u0013\u001a\u00020\u000f*\u00020\u0014H\u0002\u001a$\u0010\u0015\u001a\u00020\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0000\u001a\u00020\u0001H\u0002\u00a8\u0006\u001b"}, d2={"message", "", "desiredIntent", "", "currentIndent", "countIndent", "getLine", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;", "line", "getLocation", "Lio/gitlab/arturbosch/detekt/api/Location;", "start", "Lio/gitlab/arturbosch/detekt/api/SourceLocation;", "end", "isBlankOrLineBreak", "", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;", "isSurroundedByLineBreaks", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "isTabChar", "", "report", "", "Lio/gitlab/arturbosch/detekt/api/Rule;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "location", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nMultilineRawStringIndentation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultilineRawStringIndentation.kt\nio/gitlab/arturbosch/detekt/rules/style/MultilineRawStringIndentationKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Junk.kt\nio/gitlab/arturbosch/detekt/rules/JunkKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,211:1\n5261#2,7:212\n5135#2,6:222\n1747#3,3:219\n1747#3,3:228\n40#4:231\n1064#5,2:232\n643#5,5:234\n*S KotlinDebug\n*F\n+ 1 MultilineRawStringIndentation.kt\nio/gitlab/arturbosch/detekt/rules/style/MultilineRawStringIndentationKt\n*L\n176#1:212,7\n177#1:222,6\n176#1:219,3\n177#1:228,3\n181#1:231\n182#1:232,2\n187#1:234,5\n*E\n"})
public final class MultilineRawStringIndentationKt {
    private static final void report(Rule $this$report, KtElement element, Location location, String message) {
        $this$report.report((Finding)new CodeSmell($this$report.getIssue(), Entity.Companion.from((PsiElement)element, location), message, null, null, 24, null));
    }

    private static final String message(int desiredIntent, int currentIndent) {
        return "The indentation should be " + desiredIntent + " but it is " + currentIndent + '.';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isSurroundedByLineBreaks(KtStringTemplateExpression $this$isSurroundedByLineBreaks) {
        KtStringTemplateEntry it;
        List list;
        boolean $i$f$any;
        Iterable $this$any$iv;
        block6: {
            KtStringTemplateEntry it2;
            Object[] entries;
            Object[] objectArray = $this$isSurroundedByLineBreaks.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getEntries(...)");
            Object[] $this$takeWhile$iv = entries = objectArray;
            boolean $i$f$takeWhile = false;
            Object list$iv = new ArrayList();
            int n = $this$takeWhile$iv.length;
            for (int i = 0; i < n; ++i) {
                KtStringTemplateEntry item$iv;
                KtStringTemplateEntry it3 = item$iv = $this$takeWhile$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it3);
                if (!MultilineRawStringIndentationKt.isBlankOrLineBreak(it3)) break;
                ((ArrayList)list$iv).add(item$iv);
            }
            $this$any$iv = (List)list$iv;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            list$iv = $this$any$iv.iterator();
            do {
                if (!list$iv.hasNext()) return false;
                Object element$iv = list$iv.next();
                it2 = (KtStringTemplateEntry)element$iv;
                boolean bl = false;
            } while (!Intrinsics.areEqual((Object)it2.getText(), (Object)"\n"));
            boolean bl = true;
            if (!bl) return false;
            Object[] $this$takeLastWhile$iv = entries;
            boolean $i$f$takeLastWhile = false;
            for (int index$iv = ArraysKt.getLastIndex((Object[])$this$takeLastWhile$iv); -1 < index$iv; --index$iv) {
                Object it4 = $this$takeLastWhile$iv[index$iv];
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it4);
                if (MultilineRawStringIndentationKt.isBlankOrLineBreak((KtStringTemplateEntry)it4)) continue;
                list = ArraysKt.drop((Object[])$this$takeLastWhile$iv, (int)(index$iv + 1));
                break block6;
            }
            list = ArraysKt.toList((Object[])$this$takeLastWhile$iv);
        }
        $this$any$iv = list;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (KtStringTemplateEntry)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual((Object)it.getText(), (Object)"\n"));
        return true;
    }

    private static final boolean isBlankOrLineBreak(KtStringTemplateEntry $this$isBlankOrLineBreak) {
        boolean bl;
        String text;
        block3: {
            KtStringTemplateEntry $this$safeAs$iv = $this$isBlankOrLineBreak;
            boolean $i$f$safeAs = false;
            KtStringTemplateEntry ktStringTemplateEntry = $this$safeAs$iv;
            if (!(ktStringTemplateEntry instanceof KtLiteralStringTemplateEntry)) {
                ktStringTemplateEntry = null;
            }
            KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = (KtLiteralStringTemplateEntry)ktStringTemplateEntry;
            String string = ktLiteralStringTemplateEntry != null ? ktLiteralStringTemplateEntry.getText() : null;
            if (string == null) {
                return false;
            }
            text = string;
            CharSequence $this$all$iv = text;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (MultilineRawStringIndentationKt.isTabChar(it)) continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        return bl || Intrinsics.areEqual((Object)text, (Object)"\n");
    }

    private static final boolean isTabChar(char $this$isTabChar) {
        return $this$isTabChar == ' ' || $this$isTabChar == '\t';
    }

    /*
     * WARNING - void declaration
     */
    private static final int countIndent(String $this$countIndent) {
        String string;
        block1: {
            void var1_1;
            String $this$takeWhile$iv = $this$countIndent;
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (MultilineRawStringIndentationKt.isTabChar(it)) continue;
                String string2 = $this$takeWhile$iv;
                int n2 = 0;
                String string3 = string2.substring(n2, index$iv);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block1;
            }
            string = var1_1;
        }
        return ((CharSequence)string).length();
    }

    private static final String getLine(PsiFile $this$getLine, int line) {
        String string = $this$getLine.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return (String)SequencesKt.first((Sequence)SequencesKt.drop((Sequence)StringsKt.lineSequence((CharSequence)string), (int)(line - 1)));
    }

    private static final Location getLocation(PsiFile $this$getLocation, SourceLocation start, SourceLocation end) {
        String string = $this$getLocation.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        List lines = StringsKt.lines((CharSequence)string);
        int startOffset = 0;
        int n = start.getLine();
        for (int i = 1; i < n; ++i) {
            startOffset += ((String)lines.get(i - 1)).length() + 1;
        }
        int endOffset = startOffset;
        int n2 = end.getLine();
        for (int i = start.getLine(); i < n2; ++i) {
            endOffset += ((String)lines.get(i - 1)).length() + 1;
        }
        String string2 = $this$getLocation.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        StringsKt.lines((CharSequence)string2);
        return new Location(start, end, new TextLocation(startOffset + start.getColumn() - 1, endOffset + end.getColumn() - 1), KtFilesKt.toFilePath((PsiFile)$this$getLocation));
    }

    public static final /* synthetic */ boolean access$isSurroundedByLineBreaks(KtStringTemplateExpression $receiver) {
        return MultilineRawStringIndentationKt.isSurroundedByLineBreaks($receiver);
    }

    public static final /* synthetic */ int access$countIndent(String $receiver) {
        return MultilineRawStringIndentationKt.countIndent($receiver);
    }

    public static final /* synthetic */ String access$getLine(PsiFile $receiver, int line) {
        return MultilineRawStringIndentationKt.getLine($receiver, line);
    }

    public static final /* synthetic */ Location access$getLocation(PsiFile $receiver, SourceLocation start, SourceLocation end) {
        return MultilineRawStringIndentationKt.getLocation($receiver, start, end);
    }

    public static final /* synthetic */ void access$report(Rule $receiver, KtElement element, Location location, String message) {
        MultilineRawStringIndentationKt.report($receiver, element, location, message);
    }

    public static final /* synthetic */ String access$message(int desiredIntent, int currentIndent) {
        return MultilineRawStringIndentationKt.message(desiredIntent, currentIndent);
    }
}

