/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@RequiresTypeResolution
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/NullableBooleanCheck;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitBinaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "isBooleanConstant", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "detekt-rules-style"})
public final class NullableBooleanCheck
extends Rule {
    @NotNull
    private final Issue issue;

    public NullableBooleanCheck(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Nullable boolean check should use `==` rather than `?:`", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ NullableBooleanCheck(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (Intrinsics.areEqual((Object)expression.getOperationToken(), (Object)KtTokens.ELVIS)) {
            KtExpression ktExpression = expression.getRight();
            boolean bl = ktExpression != null ? this.isBooleanConstant((PsiElement)ktExpression) : false;
            if (bl) {
                KtExpression ktExpression2 = expression.getLeft();
                boolean bl2 = ktExpression2 != null && (ktExpression2 = CallUtilKt.getType((KtExpression)ktExpression2, (BindingContext)this.getBindingContext())) != null ? TypeUtilsKt.isBooleanOrNullableBoolean((KotlinType)ktExpression2) : false;
                if (bl2) {
                    KtExpression ktExpression3 = expression.getRight();
                    String messageSuffix = Intrinsics.areEqual((Object)(ktExpression3 != null ? ktExpression3.getText() : null), (Object)"true") ? "`!= false` rather than `?: true`" : "`== true` rather than `?: false`";
                    this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "The nullable boolean check `" + expression.getText() + "` should use " + messageSuffix, null, null, 24, null));
                }
            }
        }
        super.visitBinaryExpression(expression);
    }

    private final boolean isBooleanConstant(PsiElement $this$isBooleanConstant) {
        return Intrinsics.areEqual((Object)$this$isBooleanConstant.getNode().getElementType(), (Object)KtNodeTypes.BOOLEAN_CONSTANT);
    }

    public NullableBooleanCheck() {
        this(null, 1, null);
    }
}

