/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.GuardClausesKt;
import io.gitlab.arturbosch.detekt.rules.style.ReturnCount;
import io.gitlab.arturbosch.detekt.rules.style.ReturnCount$countReturnStatements$;
import io.gitlab.arturbosch.detekt.rules.style.ReturnCountKt;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010'\u001a\u00020(H\u0016J\f\u0010,\u001a\u00020\u0006*\u00020-H\u0002R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR!\u0010\r\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\f\u0012\u0004\b\u000e\u0010\b\u001a\u0004\b\u000f\u0010\nR!\u0010\u0011\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\f\u0012\u0004\b\u0012\u0010\b\u001a\u0004\b\u0013\u0010\nR'\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\f\u0012\u0004\b\u0018\u0010\b\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR!\u0010 \u001a\u00020!8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b%\u0010\f\u0012\u0004\b\"\u0010\b\u001a\u0004\b#\u0010$\u00a8\u0006."}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ReturnCount;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "excludeGuardClauses", "", "getExcludeGuardClauses$annotations", "()V", "getExcludeGuardClauses", "()Z", "excludeGuardClauses$delegate", "Lkotlin/properties/ReadOnlyProperty;", "excludeLabeled", "getExcludeLabeled$annotations", "getExcludeLabeled", "excludeLabeled$delegate", "excludeReturnFromLambda", "getExcludeReturnFromLambda$annotations", "getExcludeReturnFromLambda", "excludeReturnFromLambda$delegate", "excludedFunctions", "", "Lkotlin/text/Regex;", "getExcludedFunctions$annotations", "getExcludedFunctions", "()Ljava/util/List;", "excludedFunctions$delegate", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "max", "", "getMax$annotations", "getMax", "()I", "max$delegate", "countReturnStatements", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "shouldBeIgnored", "visitNamedFunction", "", "isNamedReturnFromLambda", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nReturnCount.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReturnCount.kt\nio/gitlab/arturbosch/detekt/rules/style/ReturnCount\n+ 2 GuardClauses.kt\nio/gitlab/arturbosch/detekt/rules/GuardClausesKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 5 Traversing.kt\nio/gitlab/arturbosch/detekt/rules/TraversingKt\n*L\n1#1,122:1\n15#2,11:123\n1268#3,2:134\n1270#3:137\n125#4:136\n12#5,10:138\n*S KotlinDebug\n*F\n+ 1 ReturnCount.kt\nio/gitlab/arturbosch/detekt/rules/style/ReturnCount\n*L\n100#1:123,11\n107#1:134,2\n107#1:137\n107#1:136\n113#1:138,10\n*E\n"})
public final class ReturnCount
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty max$delegate;
    @NotNull
    private final ReadOnlyProperty excludedFunctions$delegate;
    @NotNull
    private final ReadOnlyProperty excludeLabeled$delegate;
    @NotNull
    private final ReadOnlyProperty excludeReturnFromLambda$delegate;
    @NotNull
    private final ReadOnlyProperty excludeGuardClauses$delegate;

    public ReturnCount(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Restrict the number of return statements in methods.", Debt.Companion.getTEN_MINS());
        this.max$delegate = ConfigPropertyKt.config((Object)2);
        this.excludedFunctions$delegate = ConfigPropertyKt.config((Object)CollectionsKt.listOf((Object)"equals"), (Function1)excludedFunctions.2.INSTANCE);
        this.excludeLabeled$delegate = ConfigPropertyKt.config((Object)false);
        this.excludeReturnFromLambda$delegate = ConfigPropertyKt.config((Object)true);
        this.excludeGuardClauses$delegate = ConfigPropertyKt.config((Object)false);
    }

    public /* synthetic */ ReturnCount(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getMax() {
        return ((Number)this.max$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="define the maximum number of return statements allowed per function")
    private static /* synthetic */ void getMax$annotations() {
    }

    private final List<Regex> getExcludedFunctions() {
        return (List)this.excludedFunctions$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="define a list of function names to be ignored by this check")
    private static /* synthetic */ void getExcludedFunctions$annotations() {
    }

    private final boolean getExcludeLabeled() {
        return (Boolean)this.excludeLabeled$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @Configuration(description="if labeled return statements should be ignored")
    private static /* synthetic */ void getExcludeLabeled$annotations() {
    }

    private final boolean getExcludeReturnFromLambda() {
        return (Boolean)this.excludeReturnFromLambda$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    @Configuration(description="if labeled return from a lambda should be ignored")
    private static /* synthetic */ void getExcludeReturnFromLambda$annotations() {
    }

    private final boolean getExcludeGuardClauses() {
        return (Boolean)this.excludeGuardClauses$delegate.getValue((Object)this, $$delegatedProperties[4]);
    }

    @Configuration(description="if true guard clauses at the beginning of a method should be ignored")
    private static /* synthetic */ void getExcludeGuardClauses$annotations() {
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        int numberOfReturns;
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        super.visitNamedFunction(function);
        if (!this.shouldBeIgnored(function) && (numberOfReturns = this.countReturnStatements(function)) > this.getMax()) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)function), "Function " + function.getName() + " has " + numberOfReturns + " return statements which exceeds the limit of " + this.getMax() + '.', null, null, 24, null));
        }
    }

    private final boolean shouldBeIgnored(KtNamedFunction function) {
        return ReturnCountKt.access$contains(this.getExcludedFunctions(), function.getName());
    }

    /*
     * WARNING - void declaration
     */
    private final int countReturnStatements(KtNamedFunction function) {
        Sequence sequence;
        if (this.getExcludeGuardClauses()) {
            KtNamedFunction $this$yieldStatementsSkippingGuardClauses$iv = function;
            boolean $i$f$yieldStatementsSkippingGuardClauses = false;
            sequence = SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super KtExpression>, Continuation<? super Unit>, Object>($this$yieldStatementsSkippingGuardClauses$iv, null){
                Object L$1;
                Object L$2;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ KtNamedFunction $this_yieldStatementsSkippingGuardClauses;
                {
                    this.$this_yieldStatementsSkippingGuardClauses = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2;
                    Object object3;
                    boolean bl;
                    Iterator<T> iterator;
                    Ref.BooleanRef firstNonGuardFound;
                    SequenceScope $this$sequence;
                    Object object4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            $this$sequence = (SequenceScope)this.L$0;
                            firstNonGuardFound = new Ref.BooleanRef();
                            KtBlockExpression ktBlockExpression = this.$this_yieldStatementsSkippingGuardClauses.getBodyBlockExpression();
                            Object object5 = ktBlockExpression;
                            if (ktBlockExpression == null) return Unit.INSTANCE;
                            List list = object5.getStatements();
                            object5 = list;
                            if (list == null) return Unit.INSTANCE;
                            Iterable $this$forEach$iv = (Iterable)object5;
                            boolean $i$f$forEach = false;
                            iterator = $this$forEach$iv.iterator();
                            break;
                        }
                        case 1: {
                            void $result;
                            boolean $i$f$forEach = false;
                            bl = false;
                            iterator = (Iterator<T>)this.L$2;
                            firstNonGuardFound = (Ref.BooleanRef)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            object3 = $result;
                            break;
                        }
                        case 2: {
                            void $result;
                            boolean $i$f$forEach = false;
                            bl = false;
                            iterator = (Iterator)this.L$2;
                            firstNonGuardFound = (Ref.BooleanRef)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }
                    }
                    while (iterator.hasNext()) {
                        KtExpression descendantExpr$iv;
                        T element$iv = iterator.next();
                        KtExpression it = (KtExpression)element$iv;
                        bl = false;
                        if (firstNonGuardFound.element) {
                            Intrinsics.checkNotNull((Object)it);
                            this.L$0 = $this$sequence;
                            this.L$1 = firstNonGuardFound;
                            this.L$2 = iterator;
                            this.label = 1;
                            object3 = $this$sequence.yield((Object)it, (Continuation)this);
                            if (object3 != object4) continue;
                            return object4;
                        }
                        Intrinsics.checkNotNull((Object)it);
                        KtExpression $this$isGuardClause$iv = it;
                        boolean $i$f$isGuardClause = false;
                        PsiElement $this$findDescendantOfType_u24default$iv$iv = (PsiElement)$this$isGuardClause$iv;
                        Function1 predicate$iv$iv = countReturnStatements$$inlined$yieldStatementsSkippingGuardClauses$1$1.INSTANCE;
                        boolean $i$f$findDescendantOfType = false;
                        PsiElement $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType_u24default$iv$iv;
                        boolean $i$f$findDescendantOfType2 = false;
                        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
                        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
                        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv$iv, result$iv$iv$iv){
                            final /* synthetic */ Function1 $predicate;
                            final /* synthetic */ Ref.ObjectRef $result;
                            {
                                this.$predicate = $predicate;
                                this.$result = $result;
                            }

                            public void visitElement(@NotNull PsiElement element) {
                                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                                if (element instanceof KtReturnExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                                    this.$result.element = element;
                                    this.stopWalking();
                                    return;
                                }
                                PsiElement it = element;
                                boolean bl = false;
                                super.visitElement(element);
                            }
                        });
                        if (((KtExpression)((PsiElement)result$iv$iv$iv.element) == null ? false : GuardClausesKt.isIfConditionGuardClause((KtExpression)$this$isGuardClause$iv, (KtExpression)descendantExpr$iv) || GuardClausesKt.isElvisOperatorGuardClause((KtExpression)$this$isGuardClause$iv, (KtExpression)descendantExpr$iv)) || GuardClausesKt.isSuperCall((KtExpression)it)) continue;
                        firstNonGuardFound.element = true;
                        this.L$0 = $this$sequence;
                        this.L$1 = firstNonGuardFound;
                        this.L$2 = iterator;
                        this.label = 2;
                        object2 = $this$sequence.yield((Object)it, (Continuation)this);
                        if (object2 == object4) return object4;
                    }
                    return Unit.INSTANCE;
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<SequenceScope<? super KtExpression>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull SequenceScope<? super KtExpression> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        } else {
            Object object = function.getBodyBlockExpression();
            if ((object != null && (object = object.getStatements()) != null ? CollectionsKt.asSequence((Iterable)((Iterable)object)) : (sequence = null)) == null) {
                sequence = SequencesKt.emptySequence();
            }
        }
        Sequence statements = sequence;
        Sequence $this$count$iv = SequencesKt.filterNot((Sequence)SequencesKt.flatMap((Sequence)statements, (Function1)countReturnStatements.1.INSTANCE), (Function1)((Function1)new Function1<KtReturnExpression, Boolean>(this){
            final /* synthetic */ ReturnCount this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtReturnExpression it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ReturnCount.access$countReturnStatements$isExcluded(it, this.this$0);
            }
        }));
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            void $this$getParentOfType$iv;
            KtReturnExpression it = (KtReturnExpression)element$iv;
            boolean bl = false;
            PsiElement psiElement = (PsiElement)it;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            if (!Intrinsics.areEqual((Object)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtNamedFunction.class, (boolean)strict$iv), (Object)function) || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        return count$iv;
    }

    private final boolean isNamedReturnFromLambda(KtReturnExpression $this$isNamedReturnFromLambda) {
        PsiElement label = $this$isNamedReturnFromLambda.getLabeledExpression();
        if (label != null) {
            KtElement $this$parentsOfTypeUntil_u24default$iv = (KtElement)$this$isNamedReturnFromLambda;
            boolean strict$iv = true;
            boolean $i$f$parentsOfTypeUntil = false;
            return SequencesKt.any((Sequence)SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super KtLambdaExpression>, Continuation<? super Unit>, Object>(strict$iv, $this$parentsOfTypeUntil_u24default$iv, null){
                Object L$1;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ boolean $strict;
                final /* synthetic */ KtElement $this_parentsOfTypeUntil;
                {
                    this.$strict = $strict;
                    this.$this_parentsOfTypeUntil = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$sequence = (SequenceScope)this.L$0;
                            v0 = current = this.$strict != false ? this.$this_parentsOfTypeUntil.getParent() : (PsiElement)this.$this_parentsOfTypeUntil;
lbl7:
                            // 2 sources

                            while (current != null && !(current instanceof KtNamedFunction)) {
                                if (current instanceof KtLambdaExpression) {
                                    this.L$0 = $this$sequence;
                                    this.L$1 = current;
                                    this.label = 1;
                                    v1 = $this$sequence.yield((Object)current, (Continuation)this);
                                    if (v1 == var2_2) {
                                        var5_5 = var2_2;
                                        return var5_5;
                                    }
                                }
                                ** GOTO lbl23
                            }
                            break;
                        }
                        case 1: {
                            current = (PsiElement)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl23:
                            // 2 sources

                            current = current.getParent();
                            ** GOTO lbl7
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<SequenceScope<? super KtLambdaExpression>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull SequenceScope<? super KtLambdaExpression> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })));
        }
        return false;
    }

    private static final boolean countReturnStatements$isExcluded(KtReturnExpression $this$countReturnStatements_u24isExcluded, ReturnCount this$0) {
        return this$0.getExcludeReturnFromLambda() && this$0.isNamedReturnFromLambda($this$countReturnStatements_u24isExcluded) || this$0.getExcludeLabeled() && $this$countReturnStatements_u24isExcluded.getLabeledExpression() != null;
    }

    public ReturnCount() {
        this(null, 1, null);
    }

    public static final /* synthetic */ boolean access$countReturnStatements$isExcluded(KtReturnExpression $receiver, ReturnCount this$0) {
        return ReturnCount.countReturnStatements$isExcluded($receiver, this$0);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ReturnCount.class, "max", "getMax()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ReturnCount.class, "excludedFunctions", "getExcludedFunctions()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ReturnCount.class, "excludeLabeled", "getExcludeLabeled()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ReturnCount.class, "excludeReturnFromLambda", "getExcludeReturnFromLambda()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ReturnCount.class, "excludeGuardClauses", "getExcludeGuardClauses()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

