/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.style.UnusedPrivatePropertyKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020#H\u0016J\f\u0010$\u001a\u00020\u0010*\u00020 H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnusedPrivatePropertyVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "allowedNames", "Lkotlin/text/Regex;", "(Lkotlin/text/Regex;)V", "nameAccesses", "", "", "properties", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "getUnusedReports", "", "Lio/gitlab/arturbosch/detekt/api/CodeSmell;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "isConstructorForDataOrValueClass", "", "constructor", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "maybeAddUnusedProperty", "", "it", "skipNode", "expression", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "visitPrimaryConstructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitReferenceExpression", "visitSecondaryConstructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "isMemberOrTopLevel", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nUnusedPrivateProperty.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnusedPrivateProperty.kt\nio/gitlab/arturbosch/detekt/rules/style/UnusedPrivatePropertyVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n766#2:167\n857#2,2:168\n1549#2:170\n1620#2,3:171\n766#2:174\n857#2,2:175\n1855#2,2:177\n1855#2,2:179\n*S KotlinDebug\n*F\n+ 1 UnusedPrivateProperty.kt\nio/gitlab/arturbosch/detekt/rules/style/UnusedPrivatePropertyVisitor\n*L\n83#1:167\n83#1:168,2\n84#1:170\n84#1:171,3\n110#1:174\n110#1:175,2\n115#1:177,2\n125#1:179,2\n*E\n"})
final class UnusedPrivatePropertyVisitor
extends DetektVisitor {
    @NotNull
    private final Regex allowedNames;
    @NotNull
    private final Set<KtNamedDeclaration> properties;
    @NotNull
    private final Set<String> nameAccesses;

    public UnusedPrivatePropertyVisitor(@NotNull Regex allowedNames2) {
        Intrinsics.checkNotNullParameter((Object)allowedNames2, (String)"allowedNames");
        this.allowedNames = allowedNames2;
        this.properties = new LinkedHashSet();
        this.nameAccesses = new LinkedHashSet();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CodeSmell> getUnusedReports(@NotNull Issue issue) {
        void $this$mapTo$iv$iv;
        KtNamedDeclaration it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Iterable $this$filter$iv = this.properties;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (KtNamedDeclaration)element$iv$iv;
            boolean bl = false;
            if (!(!this.nameAccesses.contains(it.getNameAsSafeName().getIdentifier()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (KtNamedDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new CodeSmell(issue, Entity.Companion.atName(it), "Private property `" + it.getNameAsSafeName().getIdentifier() + "` is unused.", null, null, 24, null));
        }
        return (List)destination$iv$iv;
    }

    public void visitParameter(@NotNull KtParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        super.visitParameter(parameter);
        if (parameter.isLoopParameter()) {
            KtDestructuringDeclaration destructuringDeclaration = parameter.getDestructuringDeclaration();
            if (destructuringDeclaration != null) {
                for (KtDestructuringDeclarationEntry variable : destructuringDeclaration.getEntries()) {
                    Intrinsics.checkNotNull((Object)variable);
                    this.maybeAddUnusedProperty((KtNamedDeclaration)variable);
                }
            } else {
                this.maybeAddUnusedProperty((KtNamedDeclaration)parameter);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor) {
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        super.visitPrimaryConstructor(constructor);
        $this$filter$iv = constructor.getValueParameters();
        $i$f$filter = false;
        var4_4 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (KtParameter)element$iv$iv;
            $i$a$-filter-UnusedPrivatePropertyVisitor$visitPrimaryConstructor$1 = false;
            Intrinsics.checkNotNull((Object)it);
            if (!KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)it)) && (it.hasValOrVar() || KtModifierListKt.isActual((KtModifierListOwner)((KtModifierListOwner)constructor)))) ** GOTO lbl-1000
            v0 = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)it));
            v1 = v0 != null ? !KtModifierListKt.isExpect((KtModifierListOwner)((KtModifierListOwner)v0)) : false;
            if (v1 && !this.isConstructorForDataOrValueClass((PsiElement)constructor)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (E element$iv : $this$forEach$iv) {
            it = (KtParameter)element$iv;
            $i$a$-forEach-UnusedPrivatePropertyVisitor$visitPrimaryConstructor$2 = false;
            Intrinsics.checkNotNull((Object)it);
            this.maybeAddUnusedProperty((KtNamedDeclaration)it);
        }
    }

    private final boolean isConstructorForDataOrValueClass(PsiElement constructor) {
        PsiElement psiElement = constructor.getParent();
        KtClass ktClass = psiElement instanceof KtClass ? (KtClass)psiElement : null;
        if (ktClass == null) {
            return false;
        }
        KtClass parent = ktClass;
        return parent.isData() || parent.isValue() || parent.isInline();
    }

    public void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor) {
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        super.visitSecondaryConstructor(constructor);
        Iterable $this$forEach$iv = constructor.getValueParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtParameter it = (KtParameter)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.maybeAddUnusedProperty((KtNamedDeclaration)it);
        }
    }

    private final void maybeAddUnusedProperty(KtNamedDeclaration it) {
        String string = it.getNameAsSafeName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdentifier(...)");
        if (!this.allowedNames.matches((CharSequence)string)) {
            this.properties.add(it);
        }
    }

    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)property)) && this.isMemberOrTopLevel(property) || property.isLocal()) {
            this.maybeAddUnusedProperty((KtNamedDeclaration)property);
        }
        super.visitProperty(property);
    }

    private final boolean isMemberOrTopLevel(KtProperty $this$isMemberOrTopLevel) {
        return $this$isMemberOrTopLevel.isMember() || $this$isMemberOrTopLevel.isTopLevel();
    }

    public void visitReferenceExpression(@NotNull KtReferenceExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (!this.skipNode(expression)) {
            String string = expression.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            this.nameAccesses.add(StringsKt.removeSurrounding((String)string, (CharSequence)"`"));
        }
        super.visitReferenceExpression(expression);
    }

    private final boolean skipNode(KtReferenceExpression expression) {
        return UnusedPrivatePropertyKt.access$isPackageDirective((PsiElement)expression) ? true : UnusedPrivatePropertyKt.access$isImportDirective((PsiElement)expression);
    }
}

