/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.KtIfExpressionKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@RequiresTypeResolution
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000e*\u00020\fH\u0002J\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0013H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseIfEmptyOrIfBlank;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitIfExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "condition", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "", "replacement", "Lio/gitlab/arturbosch/detekt/rules/style/UseIfEmptyOrIfBlank$Replacement;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Companion", "Replacement", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nUseIfEmptyOrIfBlank.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UseIfEmptyOrIfBlank.kt\nio/gitlab/arturbosch/detekt/rules/style/UseIfEmptyOrIfBlank\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n1194#2,2:138\n1222#2,4:140\n1549#2:144\n1620#2,3:145\n*S KotlinDebug\n*F\n+ 1 UseIfEmptyOrIfBlank.kt\nio/gitlab/arturbosch/detekt/rules/style/UseIfEmptyOrIfBlank\n*L\n132#1:138,2\n132#1:140,4\n134#1:144\n134#1:145,3\n*E\n"})
public final class UseIfEmptyOrIfBlank
extends Rule {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Issue issue;
    @NotNull
    private static final String ifBlank = "ifBlank";
    @NotNull
    private static final String ifEmpty = "ifEmpty";
    @NotNull
    private static final Map<FqName, Replacement> replacements;
    @NotNull
    private static final Set<String> conditionFunctionShortNames;

    public UseIfEmptyOrIfBlank(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("UseIfEmptyOrIfBlank", Severity.Style, "Use `ifEmpty` or `ifBlank` instead of `isEmpty` or `isBlank` to assign a default value.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UseIfEmptyOrIfBlank(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitIfExpression(@NotNull KtIfExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitIfExpression(expression);
        if (KtIfExpressionKt.isElseIf((KtIfExpression)expression)) {
            return;
        }
        KtExpression ktExpression = expression.getThen();
        if (ktExpression == null) {
            return;
        }
        KtExpression thenExpression = ktExpression;
        KtExpression ktExpression2 = expression.getElse();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression elseExpression = ktExpression2;
        if (elseExpression instanceof KtIfExpression) {
            return;
        }
        Pair<KtExpression, Boolean> pair = this.condition(expression);
        if (pair == null) {
            return;
        }
        Pair<KtExpression, Boolean> pair2 = pair;
        KtExpression condition = (KtExpression)pair2.component1();
        boolean isNegatedCondition = (Boolean)pair2.component2();
        KtCallExpression ktCallExpression = KtPsiUtilKt.getPossiblyQualifiedCallExpression((KtExpression)condition);
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression conditionCallExpression = ktCallExpression;
        KtExpression ktExpression3 = conditionCallExpression.getCalleeExpression();
        if (ktExpression3 == null) {
            return;
        }
        KtExpression conditionCalleeExpression = ktExpression3;
        String conditionCalleeExpressionText = conditionCalleeExpression.getText();
        if (!conditionFunctionShortNames.contains(conditionCalleeExpressionText)) {
            return;
        }
        Replacement replacement = this.replacement(conditionCallExpression);
        if (replacement == null) {
            return;
        }
        Replacement replacement2 = replacement;
        KtExpression selfBranch = isNegatedCondition ^ replacement2.getNegativeCondition() ? thenExpression : elseExpression;
        KtElement ktElement = (KtElement)SequencesKt.singleOrNull((Sequence)KtPsiUtilKt.blockExpressionsOrSingle((KtElement)((KtElement)selfBranch)));
        if (ktElement == null) {
            return;
        }
        KtElement selfValueExpression = ktElement;
        if (condition instanceof KtDotQualifiedExpression ? !Intrinsics.areEqual((Object)selfValueExpression.getText(), (Object)((KtDotQualifiedExpression)condition).getReceiverExpression().getText()) : !(selfValueExpression instanceof KtThisExpression)) {
            return;
        }
        String message = "This '" + conditionCalleeExpressionText + "' call can be replaced with '" + replacement2.getReplacementFunctionName() + '\'';
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)conditionCalleeExpression), (int)0, (int)2, null), message, null, null, 24, null));
    }

    private final Pair<KtExpression, Boolean> condition(KtIfExpression $this$condition) {
        Pair pair;
        KtExpression ktExpression = $this$condition.getCondition();
        if (ktExpression == null) {
            return null;
        }
        KtExpression condition = ktExpression;
        if (condition instanceof KtPrefixExpression) {
            if (!Intrinsics.areEqual((Object)((KtPrefixExpression)condition).getOperationToken(), (Object)KtTokens.EXCL)) {
                return null;
            }
            KtExpression ktExpression2 = ((KtPrefixExpression)condition).getBaseExpression();
            if (ktExpression2 == null) {
                return null;
            }
            KtExpression baseExpression = ktExpression2;
            pair = TuplesKt.to((Object)baseExpression, (Object)true);
        } else {
            pair = TuplesKt.to((Object)condition, (Object)false);
        }
        return pair;
    }

    private final Replacement replacement(KtCallExpression $this$replacement) {
        ReceiverParameterDescriptor receiverParameter;
        ReceiverParameterDescriptor receiverParameterDescriptor;
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)$this$replacement), (BindingContext)this.getBindingContext());
        if (resolvedCall == null || (resolvedCall = resolvedCall.getResultingDescriptor()) == null) {
            return null;
        }
        ResolvedCall descriptor = resolvedCall;
        ReceiverParameterDescriptor receiverParameterDescriptor2 = descriptor.getDispatchReceiverParameter();
        if (receiverParameterDescriptor2 == null) {
            receiverParameterDescriptor2 = descriptor.getExtensionReceiverParameter();
        }
        if ((receiverParameterDescriptor = (receiverParameter = receiverParameterDescriptor2)) == null || (receiverParameterDescriptor = receiverParameterDescriptor.getType()) == null) {
            return null;
        }
        ReceiverParameterDescriptor receiverType = receiverParameterDescriptor;
        if (KotlinBuiltIns.isArrayOrPrimitiveArray((KotlinType)receiverType)) {
            return null;
        }
        FqName fqName = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)descriptor));
        if (fqName == null) {
            return null;
        }
        FqName conditionCallFqName = fqName;
        return replacements.get(conditionCallFqName);
    }

    public UseIfEmptyOrIfBlank() {
        this(null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$mapTo$iv$iv;
        Object object;
        void $this$associateByTo$iv$iv;
        Companion = new Companion(null);
        Object[] objectArray = new Replacement[]{new Replacement(new FqName("kotlin.text.isBlank"), ifBlank, false, 4, null), new Replacement(new FqName("kotlin.text.isEmpty"), ifEmpty, false, 4, null), new Replacement(new FqName("kotlin.collections.List.isEmpty"), ifEmpty, false, 4, null), new Replacement(new FqName("kotlin.collections.Set.isEmpty"), ifEmpty, false, 4, null), new Replacement(new FqName("kotlin.collections.Map.isEmpty"), ifEmpty, false, 4, null), new Replacement(new FqName("kotlin.collections.Collection.isEmpty"), ifEmpty, false, 4, null), new Replacement(new FqName("kotlin.text.isNotBlank"), ifBlank, true), new Replacement(new FqName("kotlin.text.isNotEmpty"), ifEmpty, true), new Replacement(new FqName("kotlin.collections.isNotEmpty"), ifEmpty, true), new Replacement(new FqName("kotlin.String.isEmpty"), ifEmpty, false, 4, null)};
        Iterable $this$associateBy$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Replacement replacement = (Replacement)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.put(it.getConditionFunctionFqName(), element$iv$iv);
        }
        replacements = destination$iv$iv;
        Iterable $this$map$iv = replacements.keySet();
        boolean $i$f$map = false;
        Iterable capacity$iv22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object element$iv$iv;
            element$iv$iv = (FqName)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add(it.shortName().asString());
        }
        conditionFunctionShortNames = CollectionsKt.toSet((Iterable)((List)iterable));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseIfEmptyOrIfBlank$Companion;", "", "()V", "conditionFunctionShortNames", "", "", "ifBlank", "ifEmpty", "replacements", "", "Lorg/jetbrains/kotlin/name/FqName;", "Lio/gitlab/arturbosch/detekt/rules/style/UseIfEmptyOrIfBlank$Replacement;", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseIfEmptyOrIfBlank$Replacement;", "", "conditionFunctionFqName", "Lorg/jetbrains/kotlin/name/FqName;", "replacementFunctionName", "", "negativeCondition", "", "(Lorg/jetbrains/kotlin/name/FqName;Ljava/lang/String;Z)V", "getConditionFunctionFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getNegativeCondition", "()Z", "getReplacementFunctionName", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "detekt-rules-style"})
    private static final class Replacement {
        @NotNull
        private final FqName conditionFunctionFqName;
        @NotNull
        private final String replacementFunctionName;
        private final boolean negativeCondition;

        public Replacement(@NotNull FqName conditionFunctionFqName, @NotNull String replacementFunctionName, boolean negativeCondition) {
            Intrinsics.checkNotNullParameter((Object)conditionFunctionFqName, (String)"conditionFunctionFqName");
            Intrinsics.checkNotNullParameter((Object)replacementFunctionName, (String)"replacementFunctionName");
            this.conditionFunctionFqName = conditionFunctionFqName;
            this.replacementFunctionName = replacementFunctionName;
            this.negativeCondition = negativeCondition;
        }

        public /* synthetic */ Replacement(FqName fqName, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            this(fqName, string, bl);
        }

        @NotNull
        public final FqName getConditionFunctionFqName() {
            return this.conditionFunctionFqName;
        }

        @NotNull
        public final String getReplacementFunctionName() {
            return this.replacementFunctionName;
        }

        public final boolean getNegativeCondition() {
            return this.negativeCondition;
        }

        @NotNull
        public final FqName component1() {
            return this.conditionFunctionFqName;
        }

        @NotNull
        public final String component2() {
            return this.replacementFunctionName;
        }

        public final boolean component3() {
            return this.negativeCondition;
        }

        @NotNull
        public final Replacement copy(@NotNull FqName conditionFunctionFqName, @NotNull String replacementFunctionName, boolean negativeCondition) {
            Intrinsics.checkNotNullParameter((Object)conditionFunctionFqName, (String)"conditionFunctionFqName");
            Intrinsics.checkNotNullParameter((Object)replacementFunctionName, (String)"replacementFunctionName");
            return new Replacement(conditionFunctionFqName, replacementFunctionName, negativeCondition);
        }

        public static /* synthetic */ Replacement copy$default(Replacement replacement, FqName fqName, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                fqName = replacement.conditionFunctionFqName;
            }
            if ((n & 2) != 0) {
                string = replacement.replacementFunctionName;
            }
            if ((n & 4) != 0) {
                bl = replacement.negativeCondition;
            }
            return replacement.copy(fqName, string, bl);
        }

        @NotNull
        public String toString() {
            return "Replacement(conditionFunctionFqName=" + this.conditionFunctionFqName + ", replacementFunctionName=" + this.replacementFunctionName + ", negativeCondition=" + this.negativeCondition + ')';
        }

        public int hashCode() {
            int result = this.conditionFunctionFqName.hashCode();
            result = result * 31 + this.replacementFunctionName.hashCode();
            result = result * 31 + Boolean.hashCode(this.negativeCondition);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Replacement)) {
                return false;
            }
            Replacement replacement = (Replacement)other;
            if (!Intrinsics.areEqual((Object)this.conditionFunctionFqName, (Object)replacement.conditionFunctionFqName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.replacementFunctionName, (Object)replacement.replacementFunctionName)) {
                return false;
            }
            return this.negativeCondition == replacement.negativeCondition;
        }
    }
}

