/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtValueArgumentKt;
import io.gitlab.arturbosch.detekt.rules.ThrowExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\fH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseRequire;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitThrowExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "hasMoreExpressionsInBlock", "", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nUseRequire.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UseRequire.kt\nio/gitlab/arturbosch/detekt/rules/style/UseRequire\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public final class UseRequire
extends Rule {
    @NotNull
    private final Issue issue;

    public UseRequire(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("UseRequire", Severity.Style, "Use require() instead of throwing an IllegalArgumentException.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UseRequire(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitThrowExpression(@NotNull KtThrowExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (!ThrowExtensionsKt.isIllegalArgumentException((KtThrowExpression)expression)) {
            return;
        }
        if (this.hasMoreExpressionsInBlock(expression)) {
            return;
        }
        if (ThrowExtensionsKt.isEnclosedByConditionalStatement((KtThrowExpression)expression) && KtValueArgumentKt.isEmptyOrSingleStringArgument((List)ThrowExtensionsKt.getArguments((KtThrowExpression)expression), (BindingContext)this.getBindingContext())) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    private final boolean hasMoreExpressionsInBlock(KtThrowExpression $this$hasMoreExpressionsInBlock) {
        boolean bl;
        PsiElement psiElement = $this$hasMoreExpressionsInBlock.getParent();
        KtBlockExpression ktBlockExpression = psiElement instanceof KtBlockExpression ? (KtBlockExpression)psiElement : null;
        if (ktBlockExpression != null) {
            KtBlockExpression $this$hasMoreExpressionsInBlock_u24lambda_u240 = ktBlockExpression;
            boolean bl2 = false;
            bl = $this$hasMoreExpressionsInBlock_u24lambda_u240.getStatements().size() > 1;
        } else {
            bl = false;
        }
        return bl;
    }

    public UseRequire() {
        this(null, 1, null);
    }
}

