/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style.optional;

import io.github.detekt.metrics.LinesOfCodeKt;
import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.style.optional.MandatoryBracesLoops$checkForBraces$;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0012H\u0016J\f\u0010\u0013\u001a\u00020\u0014*\u00020\rH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/optional/MandatoryBracesLoops;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "checkForBraces", "", "expression", "Lorg/jetbrains/kotlin/psi/KtDoWhileExpression;", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "visitDoWhileExpression", "visitForExpression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "visitWhileExpression", "Lorg/jetbrains/kotlin/psi/KtWhileExpression;", "isNotBlockExpression", "", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nMandatoryBracesLoops.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MandatoryBracesLoops.kt\nio/gitlab/arturbosch/detekt/rules/style/optional/MandatoryBracesLoops\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,108:1\n473#2:109\n1247#2,2:110\n473#2:112\n1247#2,2:113\n*S KotlinDebug\n*F\n+ 1 MandatoryBracesLoops.kt\nio/gitlab/arturbosch/detekt/rules/style/optional/MandatoryBracesLoops\n*L\n84#1:109\n85#1:110,2\n98#1:112\n99#1:113,2\n*E\n"})
public final class MandatoryBracesLoops
extends Rule {
    @NotNull
    private final Issue issue;

    public MandatoryBracesLoops(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("MandatoryBracesLoops", Severity.Style, "A multi-line loop was found that does not have braces. These should be added to improve readability.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ MandatoryBracesLoops(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitForExpression(@NotNull KtForExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.checkForBraces((KtLoopExpression)expression);
        super.visitForExpression(expression);
    }

    public void visitWhileExpression(@NotNull KtWhileExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.checkForBraces((KtLoopExpression)expression);
        super.visitWhileExpression(expression);
    }

    public void visitDoWhileExpression(@NotNull KtDoWhileExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.checkForBraces(expression);
        super.visitDoWhileExpression(expression);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void checkForBraces(KtLoopExpression expression) {
        PsiWhiteSpace it;
        void $this$any$iv;
        void $this$filterIsInstance$iv;
        if (!this.isNotBlockExpression(expression)) return;
        PsiElement psiElement = expression.getRightParenthesis();
        if (psiElement == null) return;
        Sequence sequence = PsiUtilsKt.siblings((PsiElement)psiElement, (boolean)true, (boolean)false);
        if (sequence == null) return;
        Sequence sequence2 = sequence;
        boolean $i$f$filterIsInstance22 = false;
        Sequence sequence3 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)checkForBraces$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence3, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence sequence4 = sequence3;
        if (sequence4 == null) return;
        Sequence $i$f$filterIsInstance22 = sequence4;
        boolean $i$f$any = false;
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return;
            Object element$iv = iterator.next();
            it = (PsiWhiteSpace)element$iv;
            boolean bl = false;
        } while (!it.textContains('\n'));
        boolean bl = true;
        boolean hasNoBraces2 = bl;
        if (!hasNoBraces2) return;
        Issue issue = this.getIssue();
        KtExpression ktExpression = expression.getBody();
        if (ktExpression == null) {
            ktExpression = (KtExpression)expression;
        }
        psiElement = ktExpression;
        Intrinsics.checkNotNull((Object)psiElement);
        this.report((Finding)new CodeSmell(issue, Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)psiElement, (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
    }

    private final void checkForBraces(KtDoWhileExpression expression) {
        if (this.isNotBlockExpression((KtLoopExpression)expression) && LinesOfCodeKt.linesOfCode$default((KtElement)((KtElement)expression), null, (int)1, null) > 1) {
            boolean hasNoBraces2;
            block4: {
                boolean bl;
                Sequence $this$filterIsInstance$iv = SequencesKt.takeWhile((Sequence)PsiUtilsKt.siblings((PsiElement)((PsiElement)expression), (boolean)true, (boolean)false), (Function1)((Function1)new Function1<PsiElement, Boolean>(expression){
                    final /* synthetic */ KtDoWhileExpression $expression;
                    {
                        this.$expression = $expression;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull PsiElement it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return !Intrinsics.areEqual((Object)it, (Object)this.$expression.getWhileKeyword());
                    }
                }));
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)checkForBraces$$inlined$filterIsInstance$2.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                Sequence $this$any$iv = sequence;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    PsiWhiteSpace it = (PsiWhiteSpace)element$iv;
                    boolean bl2 = false;
                    if (!it.textContains('\n')) continue;
                    bl = true;
                    break block4;
                }
                bl = hasNoBraces2 = false;
            }
            if (hasNoBraces2) {
                Issue issue = this.getIssue();
                KtExpression ktExpression = expression.getBody();
                if (ktExpression == null) {
                    ktExpression = (KtExpression)expression;
                }
                KtExpression ktExpression2 = ktExpression;
                Intrinsics.checkNotNull((Object)ktExpression2);
                this.report((Finding)new CodeSmell(issue, Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)ktExpression2), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
            }
        }
    }

    private final boolean isNotBlockExpression(KtLoopExpression $this$isNotBlockExpression) {
        return !($this$isNotBlockExpression.getBody() instanceof KtBlockExpression);
    }

    public MandatoryBracesLoops() {
        this(null, 1, null);
    }
}

