/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\fH\u0002J\f\u0010\u000f\u001a\u00020\u000e*\u00020\fH\u0002J\f\u0010\u0010\u001a\u00020\u000e*\u00020\fH\u0002J\f\u0010\u0011\u001a\u00020\u000e*\u00020\fH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenVoid;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitTypeReference", "", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "isGenericArgument", "", "isParameterTypeOfFunction", "isPartOfOverriddenSignature", "isPartOfReturnTypeOfFunction", "Companion", "detekt-rules"})
public final class ForbiddenVoid
extends Rule {
    @NotNull
    private final Issue issue;
    @NotNull
    public static final String IGNORE_OVERRIDDEN = "ignoreOverridden";
    @NotNull
    public static final String IGNORE_USAGE_IN_GENERICS = "ignoreUsageInGenerics";
    @NotNull
    public static final String VOID_CLASS_NAME = "java.lang.Void";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitTypeReference(@NotNull KtTypeReference typeReference) {
        Intrinsics.checkParameterIsNotNull((Object)typeReference, (String)"typeReference");
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        KotlinType kotlinType = BindingContextUtilsKt.getAbbreviatedTypeOrType((KtTypeReference)typeReference, (BindingContext)this.getBindingContext());
        if (kotlinType == null) {
            return;
        }
        KotlinType kotlinType2 = kotlinType;
        ClassifierDescriptor classifierDescriptor = kotlinType2.getConstructor().getDeclarationDescriptor();
        if (Intrinsics.areEqual(classifierDescriptor != null && (classifierDescriptor = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptor))) != null ? classifierDescriptor.asString() : null, (Object)VOID_CLASS_NAME)) {
            if (((Boolean)this.getRuleSetConfig().valueOrDefault(IGNORE_OVERRIDDEN, (Object)false)).booleanValue() && this.isPartOfOverriddenSignature(typeReference)) {
                return;
            }
            if (((Boolean)this.getRuleSetConfig().valueOrDefault(IGNORE_USAGE_IN_GENERICS, (Object)false)).booleanValue() && this.isGenericArgument(typeReference)) {
                return;
            }
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)typeReference), (int)0, (int)2, null), "'Void' should be replaced with 'Unit'.", null, null, 24, null));
        }
        super.visitTypeReference(typeReference);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPartOfOverriddenSignature(@NotNull KtTypeReference $this$isPartOfOverriddenSignature) {
        if (!this.isPartOfReturnTypeOfFunction($this$isPartOfOverriddenSignature)) {
            if (!this.isParameterTypeOfFunction($this$isPartOfOverriddenSignature)) return false;
        }
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$isPartOfOverriddenSignature;
        boolean $i$f$getStrictParentOfType = false;
        KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtNamedFunction.class, (boolean)true);
        if (ktNamedFunction == null) return false;
        if (!KtModifierListKt.isOverride((KtModifierListOwner)ktNamedFunction)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isPartOfReturnTypeOfFunction(@NotNull KtTypeReference $this$isPartOfReturnTypeOfFunction) {
        boolean bl;
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$isPartOfReturnTypeOfFunction;
        boolean $i$f$getStrictParentOfType = false;
        KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtNamedFunction.class, (boolean)true);
        if (ktNamedFunction != null && (ktNamedFunction = ktNamedFunction.getTypeReference()) != null) {
            void result$iv$iv$iv;
            void $this$anyDescendantOfType$iv;
            $this$getStrictParentOfType$iv = (PsiElement)ktNamedFunction;
            Function1 predicate$iv = (Function1)new Function1<KtTypeReference, Boolean>($this$isPartOfReturnTypeOfFunction){
                final /* synthetic */ KtTypeReference $this_isPartOfReturnTypeOfFunction;

                public final boolean invoke(@NotNull KtTypeReference it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it, (Object)this.$this_isPartOfReturnTypeOfFunction);
                }
                {
                    this.$this_isPartOfReturnTypeOfFunction = ktTypeReference;
                    super(1);
                }
            };
            boolean $i$f$anyDescendantOfType = false;
            void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
            boolean $i$f$findDescendantOfType = false;
            void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
            boolean $i$f$findDescendantOfType2 = false;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, (Ref.ObjectRef)result$iv$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Ref.ObjectRef $result;
                {
                    this.$predicate = $captured_local_variable$0;
                    this.$result = $captured_local_variable$1;
                }

                public void visitElement(@NotNull PsiElement element) {
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    if (element instanceof KtTypeReference && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                        this.$result.element = element;
                        this.stopWalking();
                        return;
                    }
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                }
            });
            bl = (PsiElement)result$iv$iv$iv.element != null;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isParameterTypeOfFunction(@NotNull KtTypeReference $this$isParameterTypeOfFunction) {
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$isParameterTypeOfFunction;
        boolean $i$f$getStrictParentOfType = false;
        return PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtParameter.class, (boolean)true) != null;
    }

    private final boolean isGenericArgument(@NotNull KtTypeReference $this$isGenericArgument) {
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$isGenericArgument;
        boolean $i$f$getStrictParentOfType = false;
        return PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtTypeArgumentList.class, (boolean)true) != null;
    }

    public ForbiddenVoid(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "`Unit` should be used instead of `Void`.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ ForbiddenVoid(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public ForbiddenVoid() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenVoid$Companion;", "", "()V", "IGNORE_OVERRIDDEN", "", "IGNORE_USAGE_IN_GENERICS", "VOID_CLASS_NAME", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

