/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.style.UnusedMemberVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u001fH\u0016J\f\u0010 \u001a\u00020!*\u00020\u001aH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnusedPropertyVisitor;", "Lio/gitlab/arturbosch/detekt/rules/style/UnusedMemberVisitor;", "allowedNames", "Lkotlin/text/Regex;", "(Lkotlin/text/Regex;)V", "nameAccesses", "", "", "properties", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "getUnusedReports", "", "Lio/gitlab/arturbosch/detekt/api/CodeSmell;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "maybeAddUnusedProperty", "", "it", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "visitPrimaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitReferenceExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "visitSecondaryConstructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "isMemberOrTopLevel", "", "detekt-rules"})
final class UnusedPropertyVisitor
extends UnusedMemberVisitor {
    private final Set<KtNamedDeclaration> properties;
    private final Set<String> nameAccesses;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<CodeSmell> getUnusedReports(@NotNull Issue issue) {
        void $this$mapTo$iv$iv;
        KtNamedDeclaration it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Iterable $this$filter$iv = this.properties;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (KtNamedDeclaration)element$iv$iv;
            boolean bl = false;
            Name name = it.getNameAsSafeName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"it.nameAsSafeName");
            if (!(!this.nameAccesses.contains(name.getIdentifier()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (KtNamedDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Entity entity = Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)it), (int)0, (int)2, null);
            StringBuilder stringBuilder = new StringBuilder().append("Private property ");
            Name name = it.getNameAsSafeName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"it.nameAsSafeName");
            CodeSmell codeSmell = new CodeSmell(issue, entity, stringBuilder.append(name.getIdentifier()).append(" is unused.").toString(), null, null, 24, null);
            collection.add(codeSmell);
        }
        return (List)destination$iv$iv;
    }

    public void visitParameter(@NotNull KtParameter parameter) {
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        super.visitParameter(parameter);
        if (parameter.isLoopParameter()) {
            KtDestructuringDeclaration destructuringDeclaration = parameter.getDestructuringDeclaration();
            if (destructuringDeclaration != null) {
                Iterator iterator = destructuringDeclaration.getEntries().iterator();
                while (iterator.hasNext()) {
                    KtDestructuringDeclarationEntry variable;
                    KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = variable = (KtDestructuringDeclarationEntry)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktDestructuringDeclarationEntry, (String)"variable");
                    this.maybeAddUnusedProperty((KtNamedDeclaration)ktDestructuringDeclarationEntry);
                }
            } else {
                this.maybeAddUnusedProperty((KtNamedDeclaration)parameter);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor) {
        Intrinsics.checkParameterIsNotNull((Object)constructor, (String)"constructor");
        super.visitPrimaryConstructor(constructor);
        $this$filter$iv = constructor.getValueParameters();
        $i$f$filter = false;
        var4_4 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (KtParameter)element$iv$iv;
            $i$a$-filter-UnusedPropertyVisitor$visitPrimaryConstructor$1 = false;
            v0 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"it");
            if (!KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)v0)) && it.hasValOrVar()) ** GOTO lbl-1000
            v1 = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)it));
            if (v1 == null) ** GOTO lbl-1000
            if (!KtModifierListKt.isExpect((KtModifierListOwner)v1)) {
                v2 = true;
            } else lbl-1000:
            // 3 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (E element$iv : $this$forEach$iv) {
            it = (KtParameter)element$iv;
            $i$a$-forEach-UnusedPropertyVisitor$visitPrimaryConstructor$2 = false;
            v3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
            this.maybeAddUnusedProperty((KtNamedDeclaration)v3);
        }
    }

    public void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor) {
        Intrinsics.checkParameterIsNotNull((Object)constructor, (String)"constructor");
        super.visitSecondaryConstructor(constructor);
        Iterable $this$forEach$iv = constructor.getValueParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtParameter it = (KtParameter)element$iv;
            boolean bl = false;
            KtParameter ktParameter = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"it");
            this.maybeAddUnusedProperty((KtNamedDeclaration)ktParameter);
        }
    }

    private final void maybeAddUnusedProperty(KtNamedDeclaration it) {
        Regex regex = this.getAllowedNames();
        Name name = it.getNameAsSafeName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"it.nameAsSafeName");
        String string = name.getIdentifier();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.nameAsSafeName.identifier");
        if (!regex.matches((CharSequence)string)) {
            this.properties.add(it);
        }
    }

    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        if (KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)property)) && this.isMemberOrTopLevel(property) || property.isLocal()) {
            this.maybeAddUnusedProperty((KtNamedDeclaration)property);
        }
        super.visitProperty(property);
    }

    private final boolean isMemberOrTopLevel(@NotNull KtProperty $this$isMemberOrTopLevel) {
        return $this$isMemberOrTopLevel.isMember() || $this$isMemberOrTopLevel.isTopLevel();
    }

    public void visitReferenceExpression(@NotNull KtReferenceExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        String string = expression.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"expression.text");
        this.nameAccesses.add(string);
        super.visitReferenceExpression(expression);
    }

    public UnusedPropertyVisitor(@NotNull Regex allowedNames) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)allowedNames, (String)"allowedNames");
        super(allowedNames);
        UnusedPropertyVisitor unusedPropertyVisitor = this;
        boolean bl = false;
        unusedPropertyVisitor.properties = set = (Set)new LinkedHashSet();
        unusedPropertyVisitor = this;
        bl = false;
        unusedPropertyVisitor.nameAccesses = set = (Set)new LinkedHashSet();
    }
}

