/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.maven;

import com.puppycrawl.tools.checkstyle.Checker;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.moderne.maven.MeterRegistryProvider;
import io.moderne.serialization.OriginHelper;
import io.moderne.serialization.TreeSerializer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.config.Environment;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.style.CheckstyleConfigLoader;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.marker.ci.BuildEnvironment;
import org.openrewrite.maven.MavenMojoProjectParser;

@Mojo(name="ast", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true, defaultPhase=LifecyclePhase.PACKAGE)
public class ModerneAstMojo
extends AbstractMojo {
    @Parameter(property="configLocation", defaultValue="${maven.multiModuleProjectDirectory}/rewrite.yml")
    private String configLocation;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component
    private RuntimeInformation runtime;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession mavenSession;
    @Parameter(property="activeStyles")
    private Set<String> activeStyles = Collections.emptySet();
    @Nullable
    @Parameter(property="metricsUri")
    private String metricsUri;
    @Nullable
    @Parameter(property="metricsUsername")
    private String metricsUsername;
    @Nullable
    @Parameter(property="metricsPassword")
    private String metricsPassword;
    @Parameter(property="pomCacheEnabled", defaultValue="true")
    private boolean pomCacheEnabled;
    @Nullable
    @Parameter(property="pomCacheDirectory")
    private String pomCacheDirectory;
    @Parameter(property="skipMavenParsing", defaultValue="false")
    protected boolean skipMavenParsing;
    @Nullable
    @Parameter(property="checkstyleConfigFile")
    private String checkstyleConfigFile;
    @Parameter(property="exclusions")
    private Set<String> exclusions = Collections.emptySet();
    @Nullable
    @Parameter(property="rewrite.exclusions")
    private String rewriteExclusions;
    @Component
    private SettingsDecrypter settingsDecrypter;
    @Nullable
    @Parameter(property="sizeThresholdMb", defaultValue="10")
    protected int sizeThresholdMb;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    private String finalName;
    @Parameter(property="organization")
    private String organization;
    @Parameter(property="repository")
    private String repository;
    @Component
    private MavenProjectHelper projectHelper;

    protected Set<String> getExclusions() {
        if (this.rewriteExclusions == null) {
            return this.exclusions;
        }
        Set<String> allExclusions = this.toSet(this.rewriteExclusions);
        allExclusions.addAll(this.exclusions);
        return allExclusions;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File astJarFile = new File(this.outputDirectory, this.finalName + "-ast.jar");
        if (astJarFile.exists()) {
            if (!astJarFile.delete()) {
                throw new MojoFailureException("Unable to overwrite AST jar file: " + astJarFile.getAbsolutePath());
            }
        } else if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            throw new MojoFailureException("Output directory for AST file does not exist and cannot be created: " + this.outputDirectory.getAbsolutePath());
        }
        Properties scmProvenance = this.getScmProvenanceProps();
        List<SourceFile> asts = this.listAsts();
        try (OutputStream outputStream = Files.newOutputStream(astJarFile.toPath(), new OpenOption[0]);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
             JarOutputStream jarOutputStream = new JarOutputStream(bufferedOutputStream);){
            jarOutputStream.putNextEntry(new JarEntry("scm.properties"));
            scmProvenance.store(jarOutputStream, null);
            jarOutputStream.closeEntry();
            jarOutputStream.putNextEntry(new JarEntry(this.project.getName() + ".ast"));
            new TreeSerializer().write(asts, jarOutputStream);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        this.projectHelper.attachArtifact(this.project, astJarFile, "ast");
    }

    private Properties getScmProvenanceProps() throws MojoFailureException {
        GitProvenance gitProvenance = GitProvenance.fromProjectDirectory((Path)this.getBaseDir(), (BuildEnvironment)BuildEnvironment.build(System::getenv));
        Properties scmProperties = new Properties();
        scmProperties.setProperty("buildId", UUID.randomUUID().toString());
        if (gitProvenance == null) {
            if (this.organization == null || this.repository == null) {
                throw new MojoFailureException("Organization and repository parameters are required for projects that are not git repositories.");
            }
            scmProperties.setProperty("path", this.organization + "/" + this.repository);
        } else {
            scmProperties.setProperty("origin", OriginHelper.stripOrigin(gitProvenance.getOrigin()));
            scmProperties.setProperty("branch", gitProvenance.getBranch());
            scmProperties.setProperty("change", gitProvenance.getChange());
            scmProperties.setProperty("path", gitProvenance.getOrganizationName() + "/" + gitProvenance.getRepositoryName());
        }
        return scmProperties;
    }

    protected Environment environment() throws MojoExecutionException {
        File rewriteConfig;
        Environment.Builder env = Environment.builder((Properties)this.project.getProperties()).scanRuntimeClasspath(new String[0]).scanUserHome();
        Path absoluteConfigLocation = Paths.get(this.configLocation, new String[0]);
        if (!absoluteConfigLocation.isAbsolute()) {
            absoluteConfigLocation = this.project.getBasedir().toPath().resolve(this.configLocation);
        }
        if ((rewriteConfig = absoluteConfigLocation.toFile()).exists()) {
            try (FileInputStream is = new FileInputStream(rewriteConfig);){
                env.load((ResourceLoader)new YamlResourceLoader((InputStream)is, rewriteConfig.toURI(), this.project.getProperties()));
            }
            catch (IOException e2) {
                throw new MojoExecutionException("Unable to load rewrite configuration", (Exception)e2);
            }
        }
        return env.build();
    }

    ExecutionContext executionContext() {
        return new InMemoryExecutionContext(t -> {
            this.getLog().warn((CharSequence)t.getMessage());
            this.getLog().debug(t);
        });
    }

    protected Path getBaseDir() {
        Object maybeMultiModuleDir = System.getProperties().get("maven.multiModuleProjectDirectory");
        try {
            if (maybeMultiModuleDir instanceof String) {
                return Paths.get((String)maybeMultiModuleDir, new String[0]).toRealPath(new LinkOption[0]);
            }
            return this.project.getBasedir().toPath().toRealPath(new LinkOption[0]);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    protected List<SourceFile> listAsts() throws MojoExecutionException {
        MeterRegistryProvider meterRegistryProvider = new MeterRegistryProvider(this.getLog(), this.metricsUri, this.metricsUsername, this.metricsPassword);
        try {
            List styles;
            Path baseDir;
            block18: {
                Metrics.addRegistry((MeterRegistry)meterRegistryProvider.registry());
                baseDir = this.getBaseDir();
                Environment env = this.environment();
                styles = env.activateStyles(this.activeStyles);
                try {
                    Object checkstyleConfRaw;
                    Plugin checkstylePlugin = this.project.getPlugin("org.apache.maven.plugins:maven-checkstyle-plugin");
                    if (this.checkstyleConfigFile != null && !this.checkstyleConfigFile.isEmpty()) {
                        styles.add(CheckstyleConfigLoader.loadCheckstyleConfig((Path)Paths.get(this.checkstyleConfigFile, new String[0]), Collections.emptyMap()));
                        break block18;
                    }
                    if (checkstylePlugin == null || !((checkstyleConfRaw = checkstylePlugin.getConfiguration()) instanceof Xpp3Dom)) break block18;
                    Xpp3Dom xmlCheckstyleConf = (Xpp3Dom)checkstyleConfRaw;
                    Xpp3Dom xmlConfigLocation = xmlCheckstyleConf.getChild("configLocation");
                    if (xmlConfigLocation == null) {
                        try (InputStream is = Checker.class.getResourceAsStream("/sun_checks.xml");){
                            if (is != null) {
                                styles.add(CheckstyleConfigLoader.loadCheckstyleConfig((InputStream)is, Collections.emptyMap()));
                            }
                            break block18;
                        }
                    }
                    Path configPath = Paths.get(xmlConfigLocation.getValue(), new String[0]);
                    styles.add(CheckstyleConfigLoader.loadCheckstyleConfig((Path)configPath, Collections.emptyMap()));
                }
                catch (Exception e2) {
                    this.getLog().warn((CharSequence)"Unable to parse checkstyle configuration. Checkstyle will not inform rewrite execution.", (Throwable)e2);
                }
            }
            ExecutionContext ctx = this.executionContext();
            MavenMojoProjectParser projectParser = new MavenMojoProjectParser(this.getLog(), baseDir, this.pomCacheEnabled, this.pomCacheDirectory, this.runtime, this.skipMavenParsing, this.getExclusions(), this.sizeThresholdMb, this.mavenSession, this.settingsDecrypter);
            List sourceFiles = projectParser.listSourceFiles(this.project, (Iterable)styles, ctx);
            Metrics.removeRegistry((MeterRegistry)meterRegistryProvider.registry());
            List list = sourceFiles;
            meterRegistryProvider.close();
            return list;
        }
        catch (Throwable throwable) {
            try {
                try {
                    meterRegistryProvider.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (DependencyResolutionRequiredException e3) {
                throw new MojoExecutionException("Dependency resolution required", (Exception)((Object)e3));
            }
        }
    }

    private Set<String> toSet(@Nullable String propertyValue) {
        return Optional.ofNullable(propertyValue).filter(s -> !s.isEmpty()).map(s -> new HashSet<String>(Arrays.asList(s.split(",")))).orElseGet(HashSet::new);
    }
}

