/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

public final class DefineClassContext {
    private static final ThreadLocal<DefineClassContext> contextThreadLocal = new ThreadLocal();
    private int counter;
    private boolean helpersInjected;

    private DefineClassContext() {
    }

    public static void enter() {
        DefineClassContext context = contextThreadLocal.get();
        if (context == null) {
            context = new DefineClassContext();
            contextThreadLocal.set(context);
        }
        ++context.counter;
    }

    public static void exit() {
        DefineClassContext.exitAndGet();
    }

    public static boolean exitAndGet() {
        DefineClassContext context = contextThreadLocal.get();
        --context.counter;
        if (context.counter == 0) {
            contextThreadLocal.remove();
        }
        return context.helpersInjected;
    }

    public static void helpersInjected() {
        DefineClassContext context = contextThreadLocal.get();
        if (context != null) {
            context.helpersInjected = true;
        }
    }
}

