/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import io.opentelemetry.javaagent.shaded.instrumentation.api.config.Config;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.CapturedHttpHeaders;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import java.util.List;

public final class HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> {
    final HttpServerAttributesGetter<REQUEST, RESPONSE> getter;
    CapturedHttpHeaders capturedHttpHeaders = CapturedHttpHeaders.server(Config.get());

    HttpServerAttributesExtractorBuilder(HttpServerAttributesGetter<REQUEST, RESPONSE> getter) {
        this.getter = getter;
    }

    @Deprecated
    public HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> captureHttpHeaders(CapturedHttpHeaders capturedHttpHeaders) {
        this.capturedHttpHeaders = capturedHttpHeaders;
        return this;
    }

    public HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> setCapturedRequestHeaders(List<String> requestHeaders) {
        this.capturedHttpHeaders = CapturedHttpHeaders.create(requestHeaders, this.capturedHttpHeaders.responseHeaders());
        return this;
    }

    public HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> setCapturedResponseHeaders(List<String> responseHeaders) {
        this.capturedHttpHeaders = CapturedHttpHeaders.create(this.capturedHttpHeaders.requestHeaders(), responseHeaders);
        return this;
    }

    public HttpServerAttributesExtractor<REQUEST, RESPONSE> build() {
        return new HttpServerAttributesExtractor<REQUEST, RESPONSE>(this.getter, this.capturedHttpHeaders);
    }
}

