/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.loader;

import com.mitchellbosecke.pebble.error.LoaderException;
import com.mitchellbosecke.pebble.loader.Loader;
import com.mitchellbosecke.pebble.utils.PathUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLoader
implements Loader<String> {
    private static final Logger logger = LoggerFactory.getLogger(FileLoader.class);
    private String prefix;
    private String suffix;
    private String charset = "UTF-8";

    @Override
    public Reader getReader(String templateName) {
        StringBuilder path = new StringBuilder();
        if (this.getPrefix() != null) {
            path.append(this.getPrefix());
            if (!this.getPrefix().endsWith(String.valueOf(File.separatorChar))) {
                path.append(File.separatorChar);
            }
        }
        templateName = templateName + (this.getSuffix() == null ? "" : this.getSuffix());
        logger.debug("Looking for template in {}{}.", (Object)path.toString(), (Object)templateName);
        String[] pathSegments = PathUtils.PATH_SEPARATOR_REGEX.split(templateName);
        if (pathSegments.length > 1) {
            templateName = pathSegments[pathSegments.length - 1];
        }
        for (int i = 0; i < pathSegments.length - 1; ++i) {
            path.append(pathSegments[i]).append(File.separatorChar);
        }
        FileInputStream is = null;
        File file = new File(path.toString(), templateName);
        if (file.exists() && file.isFile()) {
            try {
                is = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (is == null) {
            throw new LoaderException(null, "Could not find template \"" + path.toString() + templateName + "\"");
        }
        try {
            return new BufferedReader(new InputStreamReader((InputStream)is, this.charset));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getCharset() {
        return this.charset;
    }

    @Override
    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public String resolveRelativePath(String relativePath, String anchorPath) {
        return PathUtils.resolveRelativePath(relativePath, anchorPath, File.separatorChar);
    }

    @Override
    public String createCacheKey(String templateName) {
        return templateName;
    }
}

