/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.elab;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.elab.BooleanEvaluator;
import net.sf.saxon.expr.elab.EagerPullEvaluator;
import net.sf.saxon.expr.elab.EagerPushEvaluator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.LazyPullEvaluator;
import net.sf.saxon.expr.elab.LearningEvaluator;
import net.sf.saxon.expr.elab.MemoClosureEvaluator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.elab.SequenceEvaluator;
import net.sf.saxon.expr.elab.SingleItemEvaluator;
import net.sf.saxon.expr.elab.StringEvaluator;
import net.sf.saxon.expr.elab.UnicodeStringEvaluator;
import net.sf.saxon.expr.elab.UpdateEvaluator;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.value.Cardinality;

public abstract class Elaborator {
    private Expression expression;

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expr) {
        this.expression = expr;
    }

    protected Configuration getConfiguration() {
        return this.expression.getConfiguration();
    }

    public SequenceEvaluator eagerly() {
        Expression expr = this.getExpression();
        int m = expr.getImplementationMethod();
        if ((m & 1) != 0 && !Cardinality.allowsMany(expr.getCardinality())) {
            ItemEvaluator itemEvaluator = this.elaborateForItem();
            return new SingleItemEvaluator(itemEvaluator);
        }
        if ((m & 2) != 0) {
            PullEvaluator pullEvaluator = this.elaborateForPull();
            return new EagerPullEvaluator(pullEvaluator);
        }
        PushEvaluator pushEvaluator = this.elaborateForPush();
        return new EagerPushEvaluator(pushEvaluator);
    }

    public SequenceEvaluator lazily(boolean repeatable) {
        Expression expr = this.getExpression();
        if (!expr.supportsLazyEvaluation()) {
            return this.eagerly();
        }
        if (repeatable) {
            return new LearningEvaluator(expr, new MemoClosureEvaluator(expr, this.elaborateForPull()));
        }
        PullEvaluator pullEvaluator = this.elaborateForPull();
        return new LazyPullEvaluator(pullEvaluator);
    }

    public abstract PullEvaluator elaborateForPull();

    public abstract PushEvaluator elaborateForPush();

    public abstract ItemEvaluator elaborateForItem();

    public abstract BooleanEvaluator elaborateForBoolean();

    public abstract UnicodeStringEvaluator elaborateForUnicodeString(boolean var1);

    public StringEvaluator elaborateForString(boolean zeroLengthWhenAbsent) {
        UnicodeStringEvaluator evaluator = this.elaborateForUnicodeString(zeroLengthWhenAbsent);
        return context -> evaluator.eval(context).toString();
    }

    protected final UnicodeString handleNullUnicodeString(boolean zeroLengthWhenAbsent) {
        return zeroLengthWhenAbsent ? EmptyUnicodeString.getInstance() : null;
    }

    protected final UnicodeString handlePossiblyNullUnicodeString(UnicodeString str, boolean zeroLengthWhenAbsent) {
        if (str == null && zeroLengthWhenAbsent) {
            return EmptyUnicodeString.getInstance();
        }
        return str;
    }

    protected final String handleNullString(boolean zeroLengthWhenAbsent) {
        return zeroLengthWhenAbsent ? "" : null;
    }

    protected final String handlePossiblyNullString(String str, boolean zeroLengthWhenAbsent) {
        if (str == null && zeroLengthWhenAbsent) {
            return "";
        }
        return str;
    }

    public UpdateEvaluator elaborateForUpdate() {
        throw new UnsupportedOperationException("Update not supported");
    }
}

