/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceExtent;

public class GroupBreakingIterator
implements LookaheadIterator,
GroupIterator {
    private final PullEvaluator select;
    private final FocusIterator population;
    private final FunctionItem breakWhen;
    private final XPathContext baseContext;
    private final XPathContext runningContext;
    private List<Item> currentMembers;
    private Item nextItem;
    private Item current = null;
    private int position = 0;

    public GroupBreakingIterator(PullEvaluator select, FunctionItem breakWhen, XPathContext baseContext) throws XPathException {
        this.select = select;
        this.breakWhen = breakWhen;
        this.baseContext = baseContext;
        this.runningContext = baseContext.newMinorContext();
        this.population = this.runningContext.trackFocus(select.iterate(baseContext));
        this.nextItem = this.population.next();
    }

    private void advance() throws XPathException {
        Item nextCandidate;
        this.currentMembers = new ArrayList<Item>(20);
        this.currentMembers.add(this.current);
        while ((nextCandidate = this.population.next()) != null) {
            BooleanValue result = (BooleanValue)this.breakWhen.call(this.runningContext, new Sequence[]{SequenceExtent.makeSequenceExtent(this.currentMembers), nextCandidate}).head();
            try {
                if (!result.getBooleanValue()) {
                    this.currentMembers.add(nextCandidate);
                    continue;
                }
                this.nextItem = nextCandidate;
                return;
            }
            catch (ClassCastException e) {
                String message = "Grouping key values are of non-comparable types";
                XPathException err = new XPathException(message);
                err.setIsTypeError(true);
                err.setXPathContext(this.runningContext);
                throw err;
            }
        }
        this.nextItem = null;
    }

    @Override
    public AtomicSequence getCurrentGroupingKey() {
        return null;
    }

    @Override
    public GroundedValue currentGroup() throws XPathException {
        return SequenceExtent.makeSequenceExtent(this.currentMembers);
    }

    @Override
    public boolean supportsHasNext() {
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.nextItem != null;
    }

    @Override
    public Item next() {
        try {
            if (this.nextItem == null) {
                this.current = null;
                this.position = -1;
                return null;
            }
            this.current = this.nextItem;
            ++this.position;
            this.advance();
            return this.current;
        }
        catch (XPathException e) {
            throw new UncheckedXPathException(e);
        }
    }

    @Override
    public void close() {
        this.population.close();
    }
}

