/*
 * Decompiled with CFR 0.152.
 */
package no.geosoft.cc.io;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import no.geosoft.cc.io.FileListener;

public class FileMonitor {
    private Timer timer_;
    private HashMap files_ = new HashMap();
    private Collection listeners_ = new ArrayList();

    public FileMonitor(long l) {
        this.timer_ = new Timer(true);
        this.timer_.schedule((TimerTask)new FileMonitorNotifier(), 0L, l);
    }

    public void stop() {
        this.timer_.cancel();
    }

    public void addFile(File file) {
        if (!this.files_.containsKey(file)) {
            long l = file.exists() ? file.lastModified() : -1L;
            this.files_.put(file, new Long(l));
        }
    }

    public void removeFile(File file) {
        this.files_.remove(file);
    }

    public void addListener(FileListener fileListener) {
        for (WeakReference weakReference : this.listeners_) {
            FileListener fileListener2 = (FileListener)weakReference.get();
            if (fileListener2 != fileListener) continue;
            return;
        }
        this.listeners_.add(new WeakReference<FileListener>(fileListener));
    }

    public void removeListener(FileListener fileListener) {
        Iterator iterator = this.listeners_.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            FileListener fileListener2 = (FileListener)weakReference.get();
            if (fileListener2 != fileListener) continue;
            iterator.remove();
            break;
        }
    }

    public static void main(String[] stringArray) {
        FileMonitor fileMonitor = new FileMonitor(1000L);
        fileMonitor.addFile(new File("/home/jacob/test1.txt"));
        fileMonitor.addFile(new File("/home/jacob/test2.txt"));
        fileMonitor.addFile(new File("/home/jacob/"));
        FileMonitor fileMonitor2 = fileMonitor;
        fileMonitor2.getClass();
        fileMonitor.addListener(fileMonitor2.new TestListener());
        while (true) {
            // Infinite loop
        }
    }

    private class TestListener
    implements FileListener {
        private TestListener() {
        }

        @Override
        public void fileChanged(File file) {
            System.out.println("File changed: " + file);
        }
    }

    private class FileMonitorNotifier
    extends TimerTask {
        private FileMonitorNotifier() {
        }

        @Override
        public void run() {
            ArrayList arrayList = new ArrayList(FileMonitor.this.files_.keySet());
            for (File file : arrayList) {
                long l = (Long)FileMonitor.this.files_.get(file);
                long l2 = file.exists() ? file.lastModified() : -1L;
                if (l2 == l) continue;
                FileMonitor.this.files_.put(file, new Long(l2));
                Iterator iterator = FileMonitor.this.listeners_.iterator();
                while (iterator.hasNext()) {
                    WeakReference weakReference = (WeakReference)iterator.next();
                    FileListener fileListener = (FileListener)weakReference.get();
                    if (fileListener == null) {
                        iterator.remove();
                        continue;
                    }
                    fileListener.fileChanged(file);
                }
            }
        }
    }
}

