/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.jspc;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.apache.maven.plugin.logging.Log;

public class JspCServletContext
implements ServletContext {
    private static final String WEB_XML = "/WEB-INF/web.xml";
    protected Hashtable<String, Object> attributes = new Hashtable();
    protected Log log;
    protected URL resourceBaseURL;

    public JspCServletContext(Log log, URL resourceBaseURL) {
        this.log = log;
        this.resourceBaseURL = resourceBaseURL;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.attributes.keys();
    }

    public ServletContext getContext(String uripath) {
        return null;
    }

    public String getInitParameter(String name) {
        return null;
    }

    public Enumeration<String> getInitParameterNames() {
        return new Vector().elements();
    }

    public int getMajorVersion() {
        return 3;
    }

    public String getMimeType(String file) {
        return null;
    }

    public int getMinorVersion() {
        return 1;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return null;
    }

    public String getRealPath(String path) {
        if (!this.resourceBaseURL.getProtocol().equals("file")) {
            return null;
        }
        if (!path.startsWith("/")) {
            return null;
        }
        try {
            return this.getResource(path).getFile().replace('/', File.separatorChar);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getResource(String path) throws MalformedURLException {
        if (WEB_XML.equals(path)) {
            return this.getClass().getResource("web.xml");
        }
        if (!path.startsWith("/")) {
            throw new MalformedURLException("Path '" + path + "' does not start with '/'");
        }
        URL url = new URL(this.resourceBaseURL, path.substring(1));
        InputStream is = null;
        try {
            is = url.openStream();
        }
        catch (Throwable t) {
            url = null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return url;
    }

    public InputStream getResourceAsStream(String path) {
        try {
            return this.getResource(path).openStream();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public Set<String> getResourcePaths(String path) {
        String basePath;
        HashSet<String> thePaths = new HashSet<String>();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if ((basePath = this.getRealPath(path)) == null) {
            return thePaths;
        }
        File theBaseDir = new File(basePath);
        if (!theBaseDir.exists() || !theBaseDir.isDirectory()) {
            return thePaths;
        }
        String[] theFiles = theBaseDir.list();
        for (int i = 0; i < theFiles.length; ++i) {
            File testFile = new File(basePath + File.separator + theFiles[i]);
            if (testFile.isFile()) {
                thePaths.add(path + theFiles[i]);
                continue;
            }
            if (!testFile.isDirectory()) continue;
            thePaths.add(path + theFiles[i] + "/");
        }
        return thePaths;
    }

    public String getServerInfo() {
        return "JspCServletContext/1.0";
    }

    @Deprecated
    public Servlet getServlet(String name) {
        return null;
    }

    public String getServletContextName() {
        return this.getServerInfo();
    }

    public String getContextPath() {
        return "/";
    }

    @Deprecated
    public Enumeration<String> getServletNames() {
        return new Vector().elements();
    }

    @Deprecated
    public Enumeration<Servlet> getServlets() {
        return new Vector().elements();
    }

    public void log(String message) {
        this.log.info((CharSequence)message);
    }

    @Deprecated
    public void log(Exception exception, String message) {
        this.log(message, exception);
    }

    public void log(String message, Throwable exception) {
        this.log.error((CharSequence)message, exception);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public int getEffectiveMajorVersion() {
        return this.getMinorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.getMajorVersion();
    }

    public boolean setInitParameter(String name, String value) {
        throw new IllegalStateException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        throw new IllegalStateException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        throw new IllegalStateException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        throw new IllegalStateException();
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        throw new IllegalStateException();
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return null;
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        throw new IllegalStateException();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        throw new IllegalStateException();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        throw new IllegalStateException();
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        throw new IllegalStateException();
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return null;
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return null;
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return null;
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return null;
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return null;
    }

    public void addListener(String className) {
        throw new IllegalStateException();
    }

    public <T extends EventListener> void addListener(T t) {
        throw new IllegalStateException();
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        throw new IllegalStateException();
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        throw new IllegalStateException();
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return null;
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public void declareRoles(String ... roleNames) {
        throw new IllegalStateException();
    }

    public String getVirtualServerName() {
        return null;
    }
}

