/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring;

import org.directwebremoting.extend.AbstractCreator;
import org.directwebremoting.spring.CreatorConfig;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class BeanCreator
extends AbstractCreator
implements BeanFactoryAware,
InitializingBean {
    private Object bean;
    private Class<?> beanClass;
    private String beanId;
    private BeanFactory beanFactory;
    private CreatorConfig config;
    private final Object monitor = new Object();

    public void afterPropertiesSet() {
        if (this.bean != null) {
            this.beanClass = this.bean.getClass();
        } else if (this.beanId != null) {
            this.beanClass = this.beanFactory.getType(this.beanId);
        } else {
            throw new FatalBeanException("You should either set the bean property directly or set the beanId property");
        }
        if (AopUtils.isCglibProxyClass(this.beanClass)) {
            this.beanClass = this.beanClass.getSuperclass();
        }
    }

    @Override
    public Class<?> getType() {
        return this.beanClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getInstance() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.bean == null) {
                Assert.notNull((Object)this.beanId, (String)"The bean id needs to be specified");
                this.bean = this.beanFactory.getBean(this.beanId);
            }
        }
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public void setBeanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    public void setBeanId(String beanId) {
        this.beanId = beanId;
    }

    public void setConfig(CreatorConfig config) {
        this.config = config;
    }

    public CreatorConfig getConfig() {
        return this.config;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

