/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;
import org.ehcache.event.CacheEvent;
import org.ehcache.event.CacheEventListener;
import org.ehcache.jsr107.Eh107CacheEntryEvent;

class EventListenerAdaptors {
    static <K, V> List<EventListenerAdaptor<K, V>> ehListenersFor(CacheEntryListener<? super K, ? super V> listener, CacheEntryEventFilter<? super K, ? super V> filter, Cache<K, V> source, boolean requestsOld) {
        ArrayList<EventListenerAdaptor<K, V>> rv = new ArrayList<EventListenerAdaptor<K, V>>();
        if (listener instanceof CacheEntryUpdatedListener) {
            rv.add(new UpdatedAdaptor<K, V>(source, (CacheEntryUpdatedListener)listener, filter, requestsOld));
        }
        if (listener instanceof CacheEntryCreatedListener) {
            rv.add(new CreatedAdaptor<K, V>(source, (CacheEntryCreatedListener)listener, filter, requestsOld));
        }
        if (listener instanceof CacheEntryRemovedListener) {
            rv.add(new RemovedAdaptor<K, V>(source, (CacheEntryRemovedListener)listener, filter, requestsOld));
        }
        if (listener instanceof CacheEntryExpiredListener) {
            rv.add(new ExpiredAdaptor<K, V>(source, (CacheEntryExpiredListener)listener, filter, requestsOld));
        }
        return rv;
    }

    private EventListenerAdaptors() {
    }

    static class UpdatedAdaptor<K, V>
    extends EventListenerAdaptor<K, V> {
        private final CacheEntryUpdatedListener<K, V> listener;

        UpdatedAdaptor(Cache<K, V> source, CacheEntryUpdatedListener<K, V> listener, CacheEntryEventFilter<K, V> filter, boolean requestsOld) {
            super(source, filter, requestsOld);
            this.listener = listener;
        }

        @Override
        org.ehcache.event.EventType getEhcacheEventType() {
            return org.ehcache.event.EventType.UPDATED;
        }

        public void onEvent(CacheEvent<? extends K, ? extends V> ehEvent) {
            Eh107CacheEntryEvent.NormalEvent<? extends K, ? extends V> event = new Eh107CacheEntryEvent.NormalEvent<K, V>(this.source, EventType.UPDATED, ehEvent, this.requestsOld);
            if (this.filter.evaluate(event)) {
                Set<Eh107CacheEntryEvent.NormalEvent<? extends K, ? extends V>> events = Collections.singleton(event);
                this.listener.onUpdated(events);
            }
        }
    }

    static class CreatedAdaptor<K, V>
    extends EventListenerAdaptor<K, V> {
        private final CacheEntryCreatedListener<K, V> listener;

        CreatedAdaptor(Cache<K, V> source, CacheEntryCreatedListener<K, V> listener, CacheEntryEventFilter<K, V> filter, boolean requestsOld) {
            super(source, filter, requestsOld);
            this.listener = listener;
        }

        @Override
        org.ehcache.event.EventType getEhcacheEventType() {
            return org.ehcache.event.EventType.CREATED;
        }

        public void onEvent(CacheEvent<? extends K, ? extends V> ehEvent) {
            Eh107CacheEntryEvent.NormalEvent<? extends K, ? extends V> event = new Eh107CacheEntryEvent.NormalEvent<K, V>(this.source, EventType.CREATED, ehEvent, false);
            if (this.filter.evaluate(event)) {
                Set<Eh107CacheEntryEvent.NormalEvent<? extends K, ? extends V>> events = Collections.singleton(event);
                this.listener.onCreated(events);
            }
        }
    }

    static class RemovedAdaptor<K, V>
    extends EventListenerAdaptor<K, V> {
        private final CacheEntryRemovedListener<K, V> listener;

        RemovedAdaptor(Cache<K, V> source, CacheEntryRemovedListener<K, V> listener, CacheEntryEventFilter<K, V> filter, boolean requestsOld) {
            super(source, filter, requestsOld);
            this.listener = listener;
        }

        @Override
        org.ehcache.event.EventType getEhcacheEventType() {
            return org.ehcache.event.EventType.REMOVED;
        }

        public void onEvent(CacheEvent<? extends K, ? extends V> ehEvent) {
            Eh107CacheEntryEvent.RemovingEvent<? extends K, ? extends V> event = new Eh107CacheEntryEvent.RemovingEvent<K, V>(this.source, EventType.REMOVED, ehEvent, this.requestsOld);
            if (this.filter.evaluate(event)) {
                Set<Eh107CacheEntryEvent.RemovingEvent<? extends K, ? extends V>> events = Collections.singleton(event);
                this.listener.onRemoved(events);
            }
        }
    }

    static class ExpiredAdaptor<K, V>
    extends EventListenerAdaptor<K, V> {
        private final CacheEntryExpiredListener<K, V> listener;

        ExpiredAdaptor(Cache<K, V> source, CacheEntryExpiredListener<K, V> listener, CacheEntryEventFilter<K, V> filter, boolean requestsOld) {
            super(source, filter, requestsOld);
            this.listener = listener;
        }

        @Override
        org.ehcache.event.EventType getEhcacheEventType() {
            return org.ehcache.event.EventType.EXPIRED;
        }

        public void onEvent(CacheEvent<? extends K, ? extends V> ehEvent) {
            Eh107CacheEntryEvent.RemovingEvent<? extends K, ? extends V> event = new Eh107CacheEntryEvent.RemovingEvent<K, V>(this.source, EventType.EXPIRED, ehEvent, this.requestsOld);
            if (this.filter.evaluate(event)) {
                Set<Eh107CacheEntryEvent.RemovingEvent<? extends K, ? extends V>> events = Collections.singleton(event);
                this.listener.onExpired(events);
            }
        }
    }

    static abstract class EventListenerAdaptor<K, V>
    implements CacheEventListener<K, V> {
        final CacheEntryEventFilter<K, V> filter;
        final Cache<K, V> source;
        final boolean requestsOld;

        EventListenerAdaptor(Cache<K, V> source, CacheEntryEventFilter<K, V> filter, boolean requestsOld) {
            this.source = source;
            this.filter = filter;
            this.requestsOld = requestsOld;
        }

        abstract org.ehcache.event.EventType getEhcacheEventType();
    }
}

