/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.connectionpool;

import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectorHandler;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.connectionpool.SingleEndpointPool;

public abstract class Endpoint<E> {
    public abstract Object getId();

    public abstract GrizzlyFuture<Connection> connect();

    protected void onConnect(Connection connection, SingleEndpointPool<E> pool) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Endpoint)) {
            return false;
        }
        return this.getId().equals(((Endpoint)o).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public static final class Factory {
        public static <E> Endpoint<E> create(E targetAddress, ConnectorHandler<E> connectorHandler) {
            return Factory.create(targetAddress, null, connectorHandler);
        }

        public static <E> Endpoint<E> create(E targetAddress, E localAddress, ConnectorHandler<E> connectorHandler) {
            return Factory.create(targetAddress.toString() + (localAddress != null ? localAddress.toString() : ""), targetAddress, localAddress, connectorHandler);
        }

        public static <E> Endpoint<E> create(final Object id, final E targetAddress, final E localAddress, final ConnectorHandler<E> connectorHandler) {
            return new Endpoint<E>(){

                @Override
                public Object getId() {
                    return id;
                }

                @Override
                public GrizzlyFuture<Connection> connect() {
                    return (GrizzlyFuture)connectorHandler.connect(targetAddress, localAddress);
                }
            };
        }
    }
}

